/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.model.TermAnnotation;
import omero.model.TermAnnotationI;
import omero.rtypes;
import org.apache.commons.lang.StringUtils;

public class TermAnnotationData
extends AnnotationData {
    public TermAnnotationData(String term) {
        super(TermAnnotationI.class);
        this.setTerm(term);
    }

    public TermAnnotationData(TermAnnotation annotation) {
        super(annotation);
    }

    public void setTerm(String term) {
        if (term == null) {
            return;
        }
        this.setDirty(true);
        ((TermAnnotation)this.asAnnotation()).setTermValue(rtypes.rstring(term));
    }

    public String getTerm() {
        return this.getContentAsString();
    }

    public String getTermDescription() {
        RString value = this.asAnnotation().getDescription();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setTermDescription(String value) {
        if (StringUtils.isBlank(value)) {
            return;
        }
        this.setDirty(true);
        this.asAnnotation().setDescription(rtypes.rstring(value));
    }

    @Override
    public Object getContent() {
        RString s = ((TermAnnotation)this.asAnnotation()).getTermValue();
        return s == null ? null : s.getValue();
    }

    @Override
    public String getContentAsString() {
        Object o = this.getContent();
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    @Override
    public void setContent(Object content) {
        if (content == null) {
            throw new IllegalArgumentException("Term not valid.");
        }
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("Term not valid.");
        }
        this.setTerm((String)content);
    }
}

