/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.IllegalArgumentException;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ROIData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.lang.StringUtils;

public class TableDataColumn {
    private String name = "";
    private String description = "";
    private int index = -1;
    private Class<?> type = null;

    public TableDataColumn(String name, int index, Class<?> type) {
        this(name, "", index, type);
    }

    public TableDataColumn(String name, String description, int index, Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("No type specified.");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Index must be a positive integer.");
        }
        if (type.equals(Integer.class)) {
            throw new IllegalArgumentException("Integer class is not supported, please use Long instead.");
        }
        if (type.equals(Float.class)) {
            throw new IllegalArgumentException("Float class is not supported, please use Double instead.");
        }
        if (!(type.equals(Object.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Double[].class) || type.equals(FileAnnotationData.class) || type.equals(Float[].class) || type.equals(ImageData.class) || type.equals(Long.class) || type.equals(Long[].class) || type.equals(MaskData.class) || type.equals(PlateData.class) || type.equals(ROIData.class) || type.equals(String.class) || type.equals(WellSampleData.class))) {
            throw new IllegalArgumentException(type.getSimpleName() + " class is not supported.");
        }
        this.name = name != null ? name : "";
        this.description = description != null ? description : "";
        this.index = index;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.getCanonicalName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableDataColumn other = (TableDataColumn)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : (other.type == null ? this.type != null : !this.type.getCanonicalName().equals(other.type.getCanonicalName())));
    }

    public String toString() {
        String s = this.name;
        if (StringUtils.isNotEmpty(this.description)) {
            s = s + " '" + this.description + "'";
        }
        if (this.index > -1) {
            s = s + " (" + this.index + ")";
        }
        if (this.type != null) {
            s = s + " [" + this.type.getSimpleName() + "]";
        }
        return s;
    }
}

