/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.awt.Color;
import java.awt.Font;
import ome.formats.model.UnitsFactory;
import ome.model.units.BigResult;
import omero.RInt;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Line;
import omero.model.Shape;
import omero.model.enums.UnitsLength;
import omero.rtypes;

public class ShapeSettingsData
extends DataObject {
    public static final Color DEFAULT_FILL_COLOUR = new Color(0, 0, 0, 64);
    public static final Color DEFAULT_FILL_COLOUR_ALPHA = new Color(0, 0, 0, 32);
    public static final Color DEFAULT_STROKE_COLOUR = new Color(196, 196, 196, 196);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_FONT_FAMILY = "sans-serif";
    public static final double DEFAULT_STROKE_WIDTH = 1.0;
    public static final String FONT_ITALIC = "Italic";
    public static final String FONT_BOLD = "Bold";
    public static final String FONT_BOLD_ITALIC = "BoldItalic";
    public static final String FONT_REGULAR = "Normal";

    public static int getRGBA(Color c) {
        int rgba = 0;
        rgba |= (c.getRed() & 0xFF) << 24;
        rgba |= (c.getGreen() & 0xFF) << 16;
        rgba |= (c.getBlue() & 0xFF) << 8;
        return rgba |= c.getAlpha() & 0xFF;
    }

    public static Color getColor(int rgba) {
        int r = rgba >> 24 & 0xFF;
        int g = rgba >> 16 & 0xFF;
        int b = rgba >> 8 & 0xFF;
        int a = rgba & 0xFF;
        return new Color(r, g, b, a);
    }

    private String formatFontStyle(String value) {
        if (value == null) {
            return FONT_REGULAR;
        }
        String v = value.trim();
        v = v.toLowerCase();
        if (FONT_ITALIC.toLowerCase().equals(v)) {
            return FONT_ITALIC;
        }
        if (FONT_BOLD.toLowerCase().equals(v)) {
            return FONT_BOLD;
        }
        if (FONT_BOLD_ITALIC.toLowerCase().equals(v)) {
            return FONT_BOLD_ITALIC;
        }
        return FONT_REGULAR;
    }

    ShapeSettingsData(Shape shape) {
        this.setValue(shape);
        this.setFontStyle(FONT_REGULAR);
    }

    public String getFillRule() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getFillRule();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setFillRule(String fillRule) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFillRule(rtypes.rstring(fillRule));
        this.setDirty(true);
    }

    public Color getFill() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getFillColor();
        if (value == null) {
            return DEFAULT_FILL_COLOUR;
        }
        Color c = ShapeSettingsData.getColor(value.getValue());
        return c;
    }

    public void setFill(Color fillColour) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (fillColour == null) {
            return;
        }
        shape.setFillColor(rtypes.rint(ShapeSettingsData.getRGBA(fillColour)));
        this.setDirty(true);
    }

    public Color getStroke() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getStrokeColor();
        if (value == null) {
            return DEFAULT_STROKE_COLOUR;
        }
        Color c = ShapeSettingsData.getColor(value.getValue());
        return c;
    }

    public void setStroke(Color strokeColour) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (strokeColour == null) {
            return;
        }
        shape.setStrokeColor(rtypes.rint(ShapeSettingsData.getRGBA(strokeColour)));
        this.setDirty(true);
    }

    @Deprecated
    public double getStrokeWidth() {
        Shape shape = (Shape)this.asIObject();
        Length value = shape.getStrokeWidth();
        if (value == null) {
            return 1.0;
        }
        try {
            return new LengthI(value, UnitsFactory.Shape_StrokeWidth).getValue();
        }
        catch (BigResult e) {
            return value.getValue();
        }
    }

    public Length getStrokeWidth(UnitsLength unit) throws BigResult {
        Shape shape = (Shape)this.asIObject();
        Length value = shape.getStrokeWidth();
        if (value == null || value.getValue() <= 0.0) {
            return new LengthI(1.0, UnitsLength.PIXEL);
        }
        return unit == null ? value : new LengthI(value, unit);
    }

    @Deprecated
    public void setStrokeWidth(Double strokeWidth) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setStrokeWidth(new LengthI((double)strokeWidth, UnitsFactory.Shape_StrokeWidth));
        this.setDirty(true);
    }

    public void setStrokeWidth(Length strokeWidth) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setStrokeWidth(strokeWidth);
        this.setDirty(true);
    }

    public double[] getStrokeDashArray() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeDashArray();
        if (value == null) {
            return null;
        }
        String v = value.getValue();
        String[] values = v.split("\\s*,\\s*");
        double[] dashes = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            dashes[i] = new Double(values[i]);
        }
        return dashes;
    }

    public void setStrokeDashArray(double[] dashArray) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (dashArray == null || dashArray.length < 2) {
            return;
        }
        StringBuffer values = new StringBuffer();
        for (int i = 0; i < dashArray.length - 1; ++i) {
            values.append(dashArray[i] + ",");
        }
        String v = values.toString() + dashArray[dashArray.length - 1];
        shape.setStrokeDashArray(rtypes.rstring(v));
        this.setDirty(true);
    }

    public Font getFont() {
        int style = 0;
        if (this.isFontBold()) {
            style |= 1;
        }
        if (this.isFontItalic()) {
            style |= 2;
        }
        return new Font(this.getFontFamily(), style, (int)this.getFontSize());
    }

    public String getFontFamily() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RString family = shape.getFontFamily();
        if (family != null) {
            return family.getValue();
        }
        return DEFAULT_FONT_FAMILY;
    }

    public void setFontFamily(String fontFamily) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (fontFamily == null || fontFamily.trim().length() == 0) {
            fontFamily = DEFAULT_FONT_FAMILY;
        }
        shape.setFontFamily(rtypes.rstring(fontFamily));
        this.setDirty(true);
    }

    @Deprecated
    public double getFontSize() {
        block5: {
            Shape shape = (Shape)this.asIObject();
            if (shape == null) {
                throw new IllegalArgumentException("No shape specified.");
            }
            Length size = shape.getFontSize();
            if (size != null) {
                try {
                    if (size.getUnit().equals(UnitsLength.PIXEL)) {
                        return size.getValue();
                    }
                    return new LengthI(size, UnitsLength.POINT).getValue();
                }
                catch (Exception e) {
                    if (!(e instanceof BigResult)) break block5;
                    BigResult ex = (BigResult)e;
                    if (ex.result == null) break block5;
                    return ex.result.doubleValue();
                }
            }
        }
        return 12.0;
    }

    public Length getFontSize(UnitsLength unit) throws BigResult {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        Length size = shape.getFontSize();
        if (size != null) {
            return unit == null ? size : new LengthI(size, unit);
        }
        return new LengthI(12.0, UnitsLength.POINT);
    }

    @Deprecated
    public void setFontSize(int fontSize) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (fontSize <= 0) {
            fontSize = 12;
        }
        shape.setFontSize(new LengthI((double)fontSize, UnitsLength.POINT));
        this.setDirty(true);
    }

    public void setFontSize(Length fontSize) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (fontSize == null) {
            fontSize = new LengthI(12.0, UnitsLength.POINT);
        }
        shape.setFontSize(fontSize);
        this.setDirty(true);
    }

    public String getFontStyle() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RString style = shape.getFontStyle();
        if (style != null) {
            return style.getValue();
        }
        return FONT_REGULAR;
    }

    public void setFontStyle(String fontStyle) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFontStyle(rtypes.rstring(this.formatFontStyle(fontStyle)));
        this.setDirty(true);
    }

    public String getMarkerStart() {
        Shape shape = (Shape)this.asIObject();
        if (shape instanceof Line) {
            Line l = (Line)shape;
            return l.getMarkerStart() != null ? l.getMarkerStart().getValue() : "";
        }
        return "";
    }

    public String getMarkerEnd() {
        Shape shape = (Shape)this.asIObject();
        if (shape instanceof Line) {
            Line l = (Line)shape;
            return l.getMarkerEnd() != null ? l.getMarkerEnd().getValue() : "";
        }
        return "";
    }

    public void setMarkerStart(String start) {
        Shape shape = (Shape)this.asIObject();
        if (shape instanceof Line) {
            Line l = (Line)shape;
            l.setMarkerStart(rtypes.rstring(start));
        }
    }

    public void setMarkerEnd(String end) {
        Shape shape = (Shape)this.asIObject();
        if (shape instanceof Line) {
            Line l = (Line)shape;
            l.setMarkerEnd(rtypes.rstring(end));
        }
    }

    public boolean isFontItalic() {
        String style = this.getFontStyle();
        return FONT_ITALIC.equalsIgnoreCase(style) || FONT_BOLD_ITALIC.equalsIgnoreCase(style);
    }

    public boolean isFontBold() {
        String style = this.getFontStyle();
        return FONT_BOLD.equalsIgnoreCase(style) || FONT_BOLD_ITALIC.equalsIgnoreCase(style);
    }
}

