/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import omero.RInt;
import omero.gateway.model.DataObject;
import omero.gateway.model.ROICoordinate;
import omero.gateway.model.ShapeSettingsData;
import omero.model.AffineTransform;
import omero.model.IObject;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Shape;
import omero.rtypes;

public abstract class ShapeData
extends DataObject {
    public static boolean READONLY_FLAG = true;
    protected ShapeSettingsData settings;
    private boolean clientObject;

    private String convertPoints(String pts, String type) {
        if (pts.length() == 0) {
            return "";
        }
        if (!pts.contains(type)) {
            return pts;
        }
        String exp = type + '[';
        int typeStr = pts.indexOf(exp, 0);
        int start = pts.indexOf(91, typeStr);
        int end = pts.indexOf(93, start);
        return pts.substring(start + 1, end);
    }

    protected String fromPoints(String type) {
        IObject o = this.asIObject();
        if (o instanceof Polygon) {
            Polygon shape = (Polygon)this.asIObject();
            return this.convertPoints(shape.getPoints().getValue(), type);
        }
        if (o instanceof Polyline) {
            Polyline shape = (Polyline)this.asIObject();
            return this.convertPoints(shape.getPoints().getValue(), type);
        }
        throw new IllegalArgumentException("No shape specified.");
    }

    protected List<Point2D.Double> parsePointsToPoint2DList(String str) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        if (str == null) {
            return points;
        }
        StringTokenizer tt = new StringTokenizer(str, " ");
        int numTokens = tt.countTokens();
        for (int i = 0; i < numTokens; ++i) {
            StringTokenizer t = new StringTokenizer(tt.nextToken(), ",");
            int n = t.countTokens() / 2;
            for (int j = 0; j < n; ++j) {
                points.add(new Point2D.Double(new Double(t.nextToken()), new Double(t.nextToken())));
            }
        }
        return points;
    }

    protected List<Integer> parsePointsToIntegerList(String str) {
        ArrayList<Integer> points = new ArrayList<Integer>();
        if (str == null) {
            return points;
        }
        StringTokenizer tt = new StringTokenizer(str, ",");
        int numTokens = tt.countTokens();
        for (int i = 0; i < numTokens; ++i) {
            StringTokenizer t = new StringTokenizer(tt.nextToken(), " ");
            int n = t.countTokens();
            for (int j = 0; j < n; ++j) {
                points.add(Double.valueOf(t.nextToken()).intValue());
            }
        }
        return points;
    }

    protected static String toPoints(Point2D.Double[] points) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            buf.append(ShapeData.toNumber(points[i].x));
            buf.append(',');
            buf.append(ShapeData.toNumber(points[i].y));
        }
        return buf.toString();
    }

    protected static String toNumber(double number) {
        String str = Double.toString(number);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    protected ShapeData(Shape shape, boolean clientObject) {
        this.setClientObject(clientObject);
        this.setValue(shape);
        shape.setLocked(rtypes.rbool(false));
        this.settings = new ShapeSettingsData(shape);
    }

    protected ShapeData(Shape shape) {
        this(shape, false);
    }

    public ShapeSettingsData getShapeSettings() {
        return this.settings;
    }

    protected void setShapeSettings(Shape shape) {
        this.settings = new ShapeSettingsData(shape);
    }

    public boolean isReadOnly() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        return shape.getLocked().getValue() == READONLY_FLAG;
    }

    public void setReadOnly(boolean readOnly) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setLocked(rtypes.rbool(readOnly));
    }

    public boolean isClientObject() {
        return this.clientObject;
    }

    public void setClientObject(boolean clientObject) {
        this.clientObject = clientObject;
    }

    public int getZ() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RInt value = shape.getTheZ();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setZ(int z) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (z < 0) {
            z = 0;
        }
        shape.setTheZ(rtypes.rint(z));
        this.setDirty(true);
    }

    public int getC() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RInt value = shape.getTheC();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setC(int c) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (c < 0) {
            c = 0;
        }
        shape.setTheC(rtypes.rint(c));
        this.setDirty(true);
    }

    public int getT() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RInt value = shape.getTheT();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public void setT(int t) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (t < 0) {
            t = 0;
        }
        shape.setTheT(rtypes.rint(t));
        this.setDirty(true);
    }

    public void setROICoordinate(ROICoordinate coord) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (coord == null) {
            throw new IllegalArgumentException("No Coordinate specified.");
        }
        this.setZ(coord.getZSection());
        this.setT(coord.getTimePoint());
        this.setDirty(true);
    }

    public ROICoordinate getROICoordinate() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        int z = this.getZ();
        int t = this.getT();
        if (z < 0 || t < 0) {
            return null;
        }
        return new ROICoordinate(z, t);
    }

    public AffineTransform getTransform() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        return shape.getTransform();
    }

    public void setTransform(AffineTransform transform) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTransform(transform);
        this.setDirty(true);
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }
}

