/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROIData;

public class ROIResult {
    private Collection<ROIData> rois;
    private Collection<FolderData> folders;
    private long fileID;
    private Object result;

    public ROIResult(Collection<ROIData> rois) {
        this(rois, -1L, null);
    }

    public ROIResult(Collection<ROIData> rois, long fileID) {
        this(rois, fileID, null);
    }

    public ROIResult(Collection<ROIData> rois, long fileID, Object result) {
        this.rois = rois;
        this.fileID = fileID;
        this.result = result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Collection<ROIData> getROIs() {
        return this.rois;
    }

    public long getFileID() {
        return this.fileID;
    }

    public Object getResult() {
        return this.result;
    }

    public void setFolders(Collection<FolderData> folders) {
        HashMap<Long, FolderData> folderById = new HashMap<Long, FolderData>();
        for (FolderData f : folders) {
            folderById.put(f.getId(), f);
        }
        if (this.rois != null) {
            for (ROIData roi : this.rois) {
                for (FolderData folder : roi.getFolders()) {
                    FolderData initFolder = (FolderData)folderById.get(folder.getId());
                    folder.setFolder(initFolder.asFolder());
                }
            }
        }
        this.folders = folderById.values();
    }

    public Collection<FolderData> getFolders() {
        return this.folders == null ? Collections.EMPTY_LIST : new ArrayList<FolderData>(this.folders);
    }
}

