/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import omero.UnloadedCollectionException;
import omero.gateway.model.DataObject;
import omero.gateway.model.EllipseData;
import omero.gateway.model.FolderData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LineData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PointData;
import omero.gateway.model.PolygonData;
import omero.gateway.model.PolylineData;
import omero.gateway.model.ROICoordinate;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ShapeData;
import omero.gateway.model.TextData;
import omero.model.Ellipse;
import omero.model.FolderRoiLink;
import omero.model.Image;
import omero.model.Label;
import omero.model.Line;
import omero.model.Mask;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Rectangle;
import omero.model.Roi;
import omero.model.RoiI;
import omero.model.Shape;

public class ROIData
extends DataObject {
    private TreeMap<ROICoordinate, List<ShapeData>> roiShapes;
    private boolean clientSide;
    private Collection<FolderData> folders = new ArrayList<FolderData>();
    private String uuid = "";

    private void initialize() {
        this.roiShapes = new TreeMap(new ROICoordinate());
        Roi roi = (Roi)this.asIObject();
        List<Shape> shapes = roi.copyShapes();
        if (shapes == null) {
            return;
        }
        for (Shape shape : shapes) {
            List<Object> data;
            ShapeData s = null;
            if (shape instanceof Rectangle) {
                s = new RectangleData(shape);
            } else if (shape instanceof Ellipse) {
                s = new EllipseData(shape);
            } else if (shape instanceof Point) {
                s = new PointData(shape);
            } else if (shape instanceof Polyline) {
                s = new PolylineData(shape);
            } else if (shape instanceof Polygon) {
                s = new PolygonData(shape);
            } else if (shape instanceof Label) {
                s = new TextData(shape);
            } else if (shape instanceof Line) {
                s = new LineData(shape);
            } else if (shape instanceof Mask) {
                s = new MaskData(shape);
            }
            if (s == null) continue;
            ROICoordinate coord = new ROICoordinate(s.getZ(), s.getT());
            if (!this.roiShapes.containsKey(coord)) {
                data = new ArrayList();
                this.roiShapes.put(coord, data);
            } else {
                data = this.roiShapes.get(coord);
            }
            data.add(s);
        }
        try {
            List<FolderRoiLink> folderLinks = roi.copyFolderLinks();
            if (folderLinks != null) {
                for (FolderRoiLink fl : folderLinks) {
                    this.folders.add(new FolderData(fl.getParent()));
                }
            }
        }
        catch (UnloadedCollectionException unloadedCollectionException) {
            // empty catch block
        }
    }

    public ROIData(Roi roi) {
        this.setValue(roi);
        if (roi != null) {
            this.initialize();
        }
    }

    public ROIData() {
        this.setValue(new RoiI());
        this.roiShapes = new TreeMap(new ROICoordinate());
    }

    public void setImage(Image image) {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        roi.setImage(image);
        this.setDirty(true);
    }

    public ImageData getImage() {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        Image image = roi.getImage();
        if (image == null) {
            return null;
        }
        return new ImageData(image);
    }

    public void addShapeData(ShapeData shape) {
        List<Object> shapeList;
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        ROICoordinate coord = shape.getROICoordinate();
        if (!this.roiShapes.containsKey(coord)) {
            shapeList = new ArrayList();
            this.roiShapes.put(coord, shapeList);
        } else {
            shapeList = this.roiShapes.get(coord);
        }
        shapeList.add(shape);
        roi.addShape((Shape)shape.asIObject());
        this.setDirty(true);
    }

    public void removeShapeData(ShapeData shape) {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        ROICoordinate coord = shape.getROICoordinate();
        List<ShapeData> shapeList = this.roiShapes.get(coord);
        shapeList.remove(shape);
        roi.removeShape((Shape)shape.asIObject());
        this.setDirty(true);
    }

    public int getPlaneCount() {
        return this.roiShapes.size();
    }

    public int getShapeCount() {
        Iterator<ROICoordinate> i = this.roiShapes.keySet().iterator();
        int cnt = 0;
        while (i.hasNext()) {
            List<ShapeData> shapeList = this.roiShapes.get(i.next());
            cnt += shapeList.size();
        }
        return cnt;
    }

    public List<ShapeData> getShapes(int z, int t) {
        return this.roiShapes.get(new ROICoordinate(z, t));
    }

    public Iterator<List<ShapeData>> getIterator() {
        return this.roiShapes.values().iterator();
    }

    public ROICoordinate firstPlane() {
        return this.roiShapes.firstKey();
    }

    public ROICoordinate lastPlane() {
        return this.roiShapes.lastKey();
    }

    public Iterator<List<ShapeData>> getShapesInRange(ROICoordinate start, ROICoordinate end) {
        return this.roiShapes.subMap(start, end).values().iterator();
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public Collection<FolderData> getFolders() {
        return this.folders;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

