/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import omero.RString;
import omero.gateway.model.ShapeData;
import omero.model.Polyline;
import omero.model.PolylineI;
import omero.model.Shape;
import omero.rtypes;

public class PolylineData
extends ShapeData {
    public PolylineData(Shape shape) {
        super(shape);
    }

    public PolylineData() {
        this(new ArrayList<Point2D.Double>());
    }

    public PolylineData(List<Point2D.Double> points, List<Point2D.Double> points1, List<Point2D.Double> points2, List<Integer> maskList) {
        super(new PolylineI(), true);
        this.setPoints(points, points1, points2, maskList);
    }

    public PolylineData(List<Point2D.Double> points) {
        super(new PolylineI(), true);
        this.setPoints(points);
    }

    public String getText() {
        Polyline shape = (Polyline)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polyline shape = (Polyline)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring(text));
    }

    public List<Point2D.Double> getPoints() {
        String pts = this.fromPoints("points");
        return this.parsePointsToPoint2DList(pts);
    }

    public List<Point2D.Double> getPoints1() {
        String pts = this.fromPoints("points1");
        return this.parsePointsToPoint2DList(pts);
    }

    public List<Point2D.Double> getPoints2() {
        String pts = this.fromPoints("points2");
        return this.parsePointsToPoint2DList(pts);
    }

    public List<Integer> getMaskPoints() {
        String pts = this.fromPoints("mask");
        return this.parsePointsToIntegerList(pts);
    }

    public void setPoints(List<Point2D.Double> points, List<Point2D.Double> points1, List<Point2D.Double> points2, List<Integer> maskList) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polyline shape = (Polyline)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        String pointsValues = PolylineData.toPoints(points.toArray(new Point2D.Double[points.size()]));
        shape.setPoints(rtypes.rstring(pointsValues));
    }

    public void setPoints(List<Point2D.Double> points) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polyline shape = (Polyline)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        String pointsValues = PolylineData.toPoints(points.toArray(new Point2D.Double[points.size()]));
        shape.setPoints(rtypes.rstring(pointsValues));
    }
}

