/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.model.units.BigResult;
import omero.RBool;
import omero.RInt;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.model.Arc;
import omero.model.ArcType;
import omero.model.Filament;
import omero.model.FilamentType;
import omero.model.Frequency;
import omero.model.FrequencyI;
import omero.model.Laser;
import omero.model.LaserMedium;
import omero.model.LaserType;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.LightEmittingDiode;
import omero.model.LightSource;
import omero.model.Power;
import omero.model.PowerI;
import omero.model.Pulse;
import omero.model.enums.UnitsFrequency;
import omero.model.enums.UnitsLength;
import omero.model.enums.UnitsPower;

public class LightSourceData
extends DataObject {
    public static final String LASER = Laser.class.getName();
    public static final String FILAMENT = Filament.class.getName();
    public static final String ARC = Arc.class.getName();
    public static final String LIGHT_EMITTING_DIODE = LightEmittingDiode.class.getName();

    public LightSourceData(LightSource source) {
        if (source == null) {
            throw new IllegalArgumentException("No light source.");
        }
        this.setValue(source);
    }

    public String getSerialNumber() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return "";
        }
        RString value = light.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLotNumber() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return "";
        }
        RString value = light.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getManufacturer() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return "";
        }
        RString value = light.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLightSourceModel() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return "";
        }
        RString value = light.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public Power getPower(UnitsPower unit) throws BigResult {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return null;
        }
        Power p = light.getPower();
        return unit == null ? p : new PowerI(p, unit);
    }

    @Deprecated
    public double getPower() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return -1.0;
        }
        Power value = light.getPower();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getType() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return "";
        }
        RString value = null;
        if (light instanceof Laser) {
            LaserType t = ((Laser)light).getType();
            value = t.getValue();
        } else if (light instanceof Filament) {
            FilamentType t = ((Filament)light).getType();
            value = t.getValue();
        } else if (light instanceof Arc) {
            ArcType t = ((Arc)light).getType();
            value = t.getValue();
        }
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLaserMedium() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null || !(light instanceof Laser)) {
            return "";
        }
        Laser laser = (Laser)light;
        LaserMedium medium = laser.getLaserMedium();
        return medium.getValue().getValue();
    }

    public Length getLaserWavelength(UnitsLength unit) throws BigResult {
        if (!LASER.equals(this.getKind())) {
            return null;
        }
        Laser laser = (Laser)this.asIObject();
        Length l = laser.getWavelength();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    @Deprecated
    public double getLaserWavelength() {
        if (!LASER.equals(this.getKind())) {
            return -1.0;
        }
        Laser laser = (Laser)this.asIObject();
        Length value = laser.getWavelength();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public Object getLaserTuneable() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null || !(light instanceof Laser)) {
            return null;
        }
        Laser laser = (Laser)light;
        RBool value = laser.getTuneable();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getKind() {
        LightSource light = (LightSource)this.asIObject();
        if (light == null) {
            return "";
        }
        if (light instanceof Laser) {
            return LASER;
        }
        if (light instanceof Filament) {
            return FILAMENT;
        }
        if (light instanceof Arc) {
            return ARC;
        }
        if (light instanceof LightEmittingDiode) {
            return LIGHT_EMITTING_DIODE;
        }
        return "";
    }

    public boolean hasPump() {
        if (!LASER.equals(this.getKind())) {
            return false;
        }
        Laser laser = (Laser)this.asIObject();
        return laser.getPump() != null;
    }

    public int getLaserFrequencyMultiplication() {
        if (!LASER.equals(this.getKind())) {
            return -1;
        }
        Laser laser = (Laser)this.asIObject();
        RInt value = laser.getFrequencyMultiplication();
        if (value == null) {
            return -1;
        }
        return value.getValue();
    }

    public String getLaserPulse() {
        if (!LASER.equals(this.getKind())) {
            return null;
        }
        Laser laser = (Laser)this.asIObject();
        Pulse value = laser.getPulse();
        if (value == null) {
            return null;
        }
        return value.getValue().getValue();
    }

    public Object getLaserPockelCell() {
        if (!LASER.equals(this.getKind())) {
            return null;
        }
        Laser laser = (Laser)this.asIObject();
        RBool value = laser.getPockelCell();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Frequency getLaserRepetitionRate(UnitsFrequency unit) throws BigResult {
        if (!LASER.equals(this.getKind())) {
            return null;
        }
        Laser laser = (Laser)this.asIObject();
        Frequency f = laser.getRepetitionRate();
        if (f == null) {
            return null;
        }
        return unit == null ? f : new FrequencyI(f, unit);
    }

    @Deprecated
    public double getLaserRepetitionRate() {
        if (!LASER.equals(this.getKind())) {
            return -1.0;
        }
        Laser laser = (Laser)this.asIObject();
        Frequency value = laser.getRepetitionRate();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public LightSourceData getLaserPump() {
        if (!LASER.equals(this.getKind())) {
            return null;
        }
        Laser laser = (Laser)this.asIObject();
        LightSource pump = laser.getPump();
        if (pump == null) {
            return null;
        }
        return new LightSourceData(pump);
    }
}

