/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.model.units.BigResult;
import omero.RDouble;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.model.Filter;
import omero.model.FilterType;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.TransmittanceRange;
import omero.model.enums.UnitsLength;

public class FilterData
extends DataObject {
    public FilterData(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot null.");
        }
        this.setValue(filter);
    }

    public Length getCutIn(UnitsLength unit) throws BigResult {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length l = range.getCutIn();
        return unit == null ? l : new LengthI(l, unit);
    }

    @Deprecated
    public Integer getCutIn() {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length value = range.getCutIn();
        if (value == null) {
            return null;
        }
        return (int)value.getValue();
    }

    public Length getCutInTolerance(UnitsLength unit) throws BigResult {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length l = range.getCutInTolerance();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    @Deprecated
    public Integer getCutInTolerance() {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length value = range.getCutInTolerance();
        if (value == null) {
            return null;
        }
        return (int)value.getValue();
    }

    public Length getCutOut(UnitsLength unit) throws BigResult {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length l = range.getCutOut();
        return unit == null ? l : new LengthI(l, unit);
    }

    @Deprecated
    public Integer getCutOut() {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length value = range.getCutOut();
        if (value == null) {
            return null;
        }
        return (int)value.getValue();
    }

    public Length getCutOutTolerance(UnitsLength unit) throws BigResult {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length l = range.getCutOutTolerance();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    @Deprecated
    public Integer getCutOutTolerance() {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        Length value = range.getCutOutTolerance();
        if (value == null) {
            return null;
        }
        return (int)value.getValue();
    }

    public Double getTransmittance() {
        Filter f = (Filter)this.asIObject();
        TransmittanceRange range = f.getTransmittanceRange();
        if (range == null) {
            return null;
        }
        RDouble value = range.getTransmittance();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getManufacturer() {
        Filter f = (Filter)this.asIObject();
        RString value = f.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getModel() {
        Filter f = (Filter)this.asIObject();
        RString value = f.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLotNumber() {
        Filter f = (Filter)this.asIObject();
        RString value = f.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSerialNumber() {
        Filter f = (Filter)this.asIObject();
        RString value = f.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getType() {
        Filter f = (Filter)this.asIObject();
        FilterType type = f.getType();
        if (type == null) {
            return "";
        }
        return type.getValue().getValue();
    }

    public String getFilterWheel() {
        Filter f = (Filter)this.asIObject();
        RString value = f.getFilterWheel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }
}

