/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.formats.model.UnitsFactory;
import ome.model.units.BigResult;
import omero.RDouble;
import omero.gateway.model.DataObject;
import omero.gateway.model.DetectorData;
import omero.gateway.model.FilterSetData;
import omero.gateway.model.LightPathData;
import omero.gateway.model.LightSourceData;
import omero.gateway.model.OTFData;
import omero.model.AcquisitionMode;
import omero.model.Binning;
import omero.model.ContrastMethod;
import omero.model.DetectorSettings;
import omero.model.DetectorSettingsI;
import omero.model.ElectricPotential;
import omero.model.ElectricPotentialI;
import omero.model.FilterSet;
import omero.model.Frequency;
import omero.model.FrequencyI;
import omero.model.Illumination;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.LightSettingsI;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.enums.UnitsElectricPotential;
import omero.model.enums.UnitsFrequency;
import omero.model.enums.UnitsLength;
import omero.rtypes;

public class ChannelAcquisitionData
extends DataObject {
    private DetectorSettings detectorSettings;
    private LightSettings lightSettings;
    private FilterSetData filterSet;
    private LightPathData lightPath;
    private LightSourceData lightSource;
    private boolean detectorSettingsDirty;
    private boolean lightSourceSettingsDirty;
    private DetectorData detector;
    private OTFData otf;
    private Binning binning;

    public ChannelAcquisitionData(LogicalChannel channel) {
        LightPath path;
        if (channel == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(channel);
        this.detectorSettings = channel.getDetectorSettings();
        this.lightSettings = channel.getLightSourceSettings();
        FilterSet set = channel.getFilterSet();
        if (set != null) {
            this.filterSet = new FilterSetData(set);
        }
        if ((path = channel.getLightPath()) != null) {
            this.lightPath = new LightPathData(path);
        }
        if (channel.getOtf() != null) {
            this.otf = new OTFData(channel.getOtf());
        }
    }

    public DetectorData getDetector() {
        if (this.detectorSettings == null) {
            return null;
        }
        if (this.detector == null) {
            this.detector = new DetectorData(this.detectorSettings.getDetector());
        }
        return this.detector;
    }

    public OTFData getOTF() {
        return this.otf;
    }

    public Double getDetectorSettingsOffset() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getOffsetValue();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsGain() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getGain();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public ElectricPotential getDetectorSettingsVoltage(UnitsElectricPotential unit) throws BigResult {
        if (this.detectorSettings == null) {
            return null;
        }
        ElectricPotential e = this.detectorSettings.getVoltage();
        if (e == null) {
            return null;
        }
        return unit == null ? e : new ElectricPotentialI(e, unit);
    }

    @Deprecated
    public Double getDetectorSettingsVoltage() {
        if (this.detectorSettings == null) {
            return null;
        }
        ElectricPotential value = this.detectorSettings.getVoltage();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Frequency getDetectorSettingsReadOutRate(UnitsFrequency unit) throws BigResult {
        if (this.detectorSettings == null) {
            return null;
        }
        Frequency f = this.detectorSettings.getReadOutRate();
        if (f == null) {
            return null;
        }
        return unit == null ? f : new FrequencyI(f, unit);
    }

    @Deprecated
    public Double getDetectorSettingsReadOutRate() {
        if (this.detectorSettings == null) {
            return null;
        }
        Frequency value = this.detectorSettings.getReadOutRate();
        if (value == null) {
            return null;
        }
        try {
            return new FrequencyI(value, UnitsFactory.DetectorSettings_ReadOutRate).getValue();
        }
        catch (BigResult e) {
            return e.result.doubleValue();
        }
    }

    public String getDetectorSettingsBinning() {
        if (this.detectorSettings == null) {
            return "";
        }
        Binning value = this.detectorSettings.getBinning();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public Double getLightSettingsAttenuation() {
        if (this.lightSettings == null) {
            return null;
        }
        RDouble value = this.lightSettings.getAttenuation();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Length getLightSettingsWavelength(UnitsLength unit) throws BigResult {
        if (this.lightSettings == null) {
            return null;
        }
        Length l = this.lightSettings.getWavelength();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    @Deprecated
    public Double getLightSettingsWavelength() {
        if (this.lightSettings == null) {
            return null;
        }
        Length value = this.lightSettings.getWavelength();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public boolean hasFilter() {
        return this.filterSet != null;
    }

    public boolean hasLightPath() {
        return this.lightPath != null;
    }

    public boolean hasDectector() {
        return this.getDetector() != null;
    }

    public void setLightSettingsAttenuation(double value) {
        this.lightSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setAttenuation(rtypes.rdouble(value));
    }

    public void setLightSettingsWavelength(Length value) {
        this.lightSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setWavelength(value);
    }

    @Deprecated
    public void setLightSettingsWavelength(double value) {
        this.lightSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setWavelength(new LengthI(value, UnitsFactory.LightSourceSettings_Wavelength));
    }

    public void setDetectorSettingOffset(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setOffsetValue(rtypes.rdouble(value));
    }

    public void setDetectorSettingsGain(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setGain(rtypes.rdouble(value));
    }

    public void setDetectorSettingsReadOutRate(Frequency value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setReadOutRate(value);
    }

    @Deprecated
    public void setDetectorSettingsReadOutRate(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setReadOutRate(new FrequencyI(value, UnitsFactory.DetectorSettings_ReadOutRate));
    }

    public void setDetectorSettingsVoltage(ElectricPotential value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setVoltage(value);
    }

    @Deprecated
    public void setDetectorSettingsVoltage(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setVoltage(new ElectricPotentialI(value, UnitsFactory.Detector_Voltage));
    }

    public void setDetectorSettingBinning(Binning binning) {
        this.binning = binning;
    }

    public Binning getDetectorBinningAsEnum() {
        return this.binning;
    }

    public boolean isDetectorSettingsDirty() {
        return this.detectorSettingsDirty;
    }

    public boolean isLightSourceSettingsDirty() {
        return this.lightSourceSettingsDirty;
    }

    public LightSourceData getLightSource() {
        if (this.lightSettings == null) {
            return null;
        }
        if (this.lightSource != null) {
            return this.lightSource;
        }
        LightSource src = this.lightSettings.getLightSource();
        if (src != null) {
            this.lightSource = new LightSourceData(src);
        }
        return this.lightSource;
    }

    public void setLightSource(LightSourceData lightSource) {
        this.lightSource = lightSource;
    }

    public LightPathData getLightPath() {
        return this.lightPath;
    }

    public FilterSetData getFilterSet() {
        return this.filterSet;
    }

    public String getIllumination() {
        LogicalChannel lc = (LogicalChannel)this.asIObject();
        if (lc == null) {
            return null;
        }
        Illumination value = lc.getIllumination();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public String getContrastMethod() {
        LogicalChannel lc = (LogicalChannel)this.asIObject();
        if (lc == null) {
            return null;
        }
        ContrastMethod value = lc.getContrastMethod();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public String getMode() {
        LogicalChannel lc = (LogicalChannel)this.asIObject();
        if (lc == null) {
            return null;
        }
        AcquisitionMode value = lc.getMode();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }
}

