/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import omero.ApiUsageException;
import omero.InternalException;
import omero.api.SearchPrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.Facility;
import omero.gateway.model.DataObject;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.SearchParameters;
import omero.gateway.model.SearchResult;
import omero.gateway.model.SearchResultCollection;
import omero.gateway.model.SearchScope;
import omero.gateway.util.PojoMapper;
import omero.model.DetailsI;
import omero.model.Experimenter;
import omero.model.IObject;

public class SearchFacility
extends Facility {
    private BrowseFacility browse;

    SearchFacility(Gateway gateway) throws ExecutionException {
        super(gateway);
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    public SearchResultCollection search(SecurityContext ctx, SearchParameters context) throws DSOutOfServiceException, DSAccessException {
        int batchSize;
        SearchResultCollection result = new SearchResultCollection();
        if (context.getTypes().isEmpty()) {
            return result;
        }
        SearchPrx service = this.gateway.getSearchService(ctx);
        int n = batchSize = context.getTypes().size() == 1 ? 1000 : context.getTypes().size() * 500;
        if (context.getTypes().contains(PlateData.class)) {
            context.getTypes().add(PlateAcquisitionData.class);
        }
        for (Class<? extends DataObject> type : context.getTypes()) {
            try {
                service.clearQueries();
                service.setAllowLeadingWildcard(true);
                service.setCaseSentivice(false);
                String searchForClass = PojoMapper.convertTypeForSearch(type);
                service.onlyType(searchForClass);
                service.setBatchSize(batchSize);
                if (context.getUserId() >= 0L) {
                    DetailsI ownerRestriction = new DetailsI();
                    Experimenter exp = (Experimenter)this.browse.findIObject(ctx, Experimenter.class.getName(), context.getUserId());
                    ownerRestriction.setOwner(exp);
                    service.onlyOwnedBy(ownerRestriction);
                }
                Date from = null;
                Date to = null;
                String dateType = null;
                if (context.getDateType() != -1) {
                    Timestamp start = context.getStart();
                    Timestamp end = context.getEnd();
                    from = start != null ? new Date(start.getTime()) : null;
                    to = end != null ? new Date(end.getTime()) : null;
                    dateType = context.getDateType() == 1 ? "acquisitionDate" : "details.creationEvent.time";
                }
                HashMap<String, String> m = new HashMap<String, String>();
                if (context.getGroupId() == -1L) {
                    m.put("omero.group", "-1");
                } else {
                    m.put("omero.group", "" + ctx.getGroupID());
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                String fields = SearchScope.getStringRepresentation(context.getScope());
                String dFrom = from != null ? df.format(from) : null;
                String dTo = to != null ? df.format(to) : null;
                try {
                    service.byLuceneQueryBuilder(fields, dFrom, dTo, dateType, context.getQuery(), m);
                }
                catch (ApiUsageException e) {
                    result.setError(1);
                    return result;
                }
                try {
                    if (service.hasNext(m)) {
                        List<IObject> l = service.results(m);
                        for (IObject object : l) {
                            if (!searchForClass.equals(object.getClass().getName())) continue;
                            SearchResult sr = new SearchResult();
                            sr.setObject(PojoMapper.asDataObject(object));
                            if (result.contains(sr)) continue;
                            result.add(sr);
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof InternalException) {
                        if (e.toString().contains("TooManyClauses")) {
                            result.setError(3);
                        } else {
                            result.setError(1);
                        }
                    } else {
                        result.setError(2);
                    }
                    this.gateway.closeService(ctx, service);
                    return result;
                }
                service.clearQueries();
            }
            catch (Throwable e) {
                this.handleException(this, e, "Could not load hierarchy");
            }
        }
        if (service != null) {
            this.gateway.closeService(ctx, service);
        }
        return result;
    }
}

