/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.Map;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.DataSourceException;
import omero.gateway.facility.Facility;
import omero.gateway.model.PixelsData;
import omero.gateway.rnd.DataSink;
import omero.gateway.rnd.Plane2D;
import omero.romio.PlaneDef;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.MultiKeyMap;

public class RawDataFacility
extends Facility
implements AutoCloseable {
    private MultiKeyMap cache = new MultiKeyMap();

    RawDataFacility(Gateway gateway) {
        super(gateway);
    }

    public Map<Integer, int[]> getHistogram(SecurityContext ctx, PixelsData pixels, int[] channels, int z, int t) throws DSOutOfServiceException, DSAccessException {
        z = z >= 0 ? z : 0;
        t = t >= 0 ? t : 0;
        PlaneDef plane = new PlaneDef(0, 0, 0, z, t, null, -1);
        return this.getHistogram(ctx, pixels, channels, 256, true, plane);
    }

    public Map<Integer, int[]> getHistogram(SecurityContext ctx, PixelsData pixels, int[] channels, int binCount, boolean globalRange, PlaneDef plane) throws DSOutOfServiceException, DSAccessException {
        try {
            if (plane == null) {
                plane = new PlaneDef(0, 0, 0, 0, 0, null, -1);
            }
            return this.getDataSink(ctx, pixels, this.gateway).getHistogram(channels, binCount, globalRange, plane);
        }
        catch (Exception e) {
            this.handleException(this, e, "Couldn't get histogram data.");
            return null;
        }
    }

    public Plane2D getPlane(SecurityContext ctx, PixelsData pixels, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        try {
            return this.getDataSink(ctx, pixels, this.gateway).getPlane(z, t, c);
        }
        catch (Exception e) {
            this.handleException(this, e, "Couldn't get plane z=" + z + " t=" + t + " c=" + c);
            return null;
        }
    }

    @Deprecated
    public Plane2D getPlane(SecurityContext ctx, PixelsData pixels, int z, int t, int c, boolean close) throws DataSourceException {
        Plane2D data = null;
        DataSink ds = null;
        try {
            ds = this.getDataSink(ctx, pixels, this.gateway);
            data = ds.getPlane(z, t, c);
        }
        catch (DSOutOfServiceException e) {
            throw new DataSourceException("Can't initiate DataSink", e);
        }
        finally {
            if (close) {
                ds.close();
            }
        }
        return data;
    }

    public Plane2D getTile(SecurityContext ctx, PixelsData pixels, int z, int t, int c, int x, int y, int w, int h) throws DataSourceException {
        try {
            return this.getDataSink(ctx, pixels, this.gateway).getTile(z, t, c, x, y, w, h);
        }
        catch (DSOutOfServiceException e) {
            throw new DataSourceException("Can't initiate DataSink", e);
        }
    }

    private DataSink getDataSink(SecurityContext ctx, PixelsData pixels, Gateway gateway) throws DSOutOfServiceException {
        DataSink ds = (DataSink)this.cache.get((Object)ctx.getGroupID(), (Object)pixels.getId());
        if (ds == null) {
            ds = new DataSink(ctx, pixels, gateway);
            this.cache.put((Object)ctx.getGroupID(), (Object)pixels.getId(), (Object)ds);
        }
        return ds;
    }

    @Override
    public void close() {
        MapIterator it = this.cache.mapIterator();
        while (it.hasNext()) {
            it.next();
            ((DataSink)it.getValue()).close();
        }
        this.firePropertyChanged("PROP_FACILITY_CLOSED", null, this.getClass().getName());
        this.removePropertyChangeListener(null);
    }
}

