/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import omero.api.IMetadataPrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.Facility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.util.PojoMapper;
import omero.model.Channel;
import omero.model.IObject;
import omero.model.Pixels;
import omero.sys.ParametersI;

public class MetadataFacility
extends Facility {
    private BrowseFacility browse;

    MetadataFacility(Gateway gateway) throws ExecutionException {
        super(gateway);
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    public ImageAcquisitionData getImageAcquisitionData(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        ParametersI params = new ParametersI();
        params.acquisitionData();
        ImageData img = this.browse.getImage(ctx, imageId, params);
        return new ImageAcquisitionData(img.asImage());
    }

    public List<ChannelData> getChannelData(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ChannelData> result = new ArrayList<ChannelData>();
        try {
            ImageData img = this.browse.getImage(ctx, imageId);
            long pixelsId = img.getDefaultPixels().getId();
            Pixels pixels = this.gateway.getPixelsService(ctx).retrievePixDescription(pixelsId);
            List<Channel> l = pixels.copyChannels();
            for (int i = 0; i < l.size(); ++i) {
                result.add(new ChannelData(i, l.get(i)));
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot load channel data.");
        }
        return result;
    }

    public List<AnnotationData> getAnnotations(SecurityContext ctx, DataObject object) throws DSOutOfServiceException, DSAccessException {
        return this.getAnnotations(ctx, object, null, null);
    }

    public List<AnnotationData> getAnnotations(SecurityContext ctx, DataObject object, List<Class<? extends AnnotationData>> annotationTypes, List<Long> userIds) throws DSOutOfServiceException, DSAccessException {
        Map<DataObject, List<AnnotationData>> result = this.getAnnotations(ctx, Arrays.asList(object), annotationTypes, userIds);
        return result.get(object);
    }

    /*
     * WARNING - void declaration
     */
    public Map<DataObject, List<AnnotationData>> getAnnotations(SecurityContext ctx, List<? extends DataObject> objects, List<Class<? extends AnnotationData>> annotationTypes, List<Long> userIds) throws DSOutOfServiceException, DSAccessException {
        HashMap<DataObject, List<AnnotationData>> result = new HashMap<DataObject, List<AnnotationData>>();
        String type = null;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DataObject dataObject : objects) {
            if (type == null) {
                type = PojoMapper.getModelType(dataObject.getClass()).getName();
            } else if (!type.equals(PojoMapper.getModelType(dataObject.getClass()).getName())) {
                throw new IllegalArgumentException("All objects have to be the same type");
            }
            ids.add(dataObject.getId());
        }
        try {
            void var9_13;
            IMetadataPrx proxy = this.gateway.getMetadataService(ctx);
            Object var9_11 = null;
            if (annotationTypes != null) {
                ArrayList<String> arrayList = new ArrayList<String>(annotationTypes.size());
                for (Class<? extends AnnotationData> c : annotationTypes) {
                    arrayList.add(PojoMapper.getModelType(c).getName());
                }
            }
            Map<Long, List<IObject>> annos = proxy.loadAnnotations(type, ids, (List<String>)var9_13, userIds, null);
            for (Map.Entry<Long, List<IObject>> e : annos.entrySet()) {
                long id = e.getKey();
                DataObject dobj = null;
                for (DataObject dataObject : objects) {
                    if (dataObject.getId() != id) continue;
                    dobj = dataObject;
                    break;
                }
                ArrayList<AnnotationData> list = new ArrayList<AnnotationData>();
                for (IObject a : e.getValue()) {
                    list.add((AnnotationData)PojoMapper.asDataObject(a));
                }
                result.put(dobj, list);
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot get annotations.");
        }
        return result;
    }
}

