/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.api.IContainerPrx;
import omero.api.IQueryPrx;
import omero.api.IScriptPrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.Facility;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.WellData;
import omero.gateway.util.PojoMapper;
import omero.model.ExperimenterGroup;
import omero.model.Folder;
import omero.model.IObject;
import omero.model.Image;
import omero.model.OriginalFile;
import omero.model.Well;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;

public class BrowseFacility
extends Facility {
    private static final String LUT_MIMETYPE = "text/x-lut";

    BrowseFacility(Gateway gateway) {
        super(gateway);
    }

    public Collection<DataObject> getHierarchy(SecurityContext ctx, Class rootType, long userId) throws DSOutOfServiceException, DSAccessException {
        ParametersI param = new ParametersI();
        if (userId >= 0L) {
            param.exp(rtypes.rlong(userId));
        }
        param.orphan();
        return this.getHierarchy(ctx, rootType, null, param);
    }

    public Collection<DataObject> getHierarchy(SecurityContext ctx, Class rootType, List<Long> rootIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            return PojoMapper.convertToDataObjects(service.loadContainerHierarchy(PojoMapper.getModelType(rootType).getName(), rootIDs, options));
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load hierarchy");
            return Collections.emptySet();
        }
    }

    public Set<DataObject> loadHierarchy(SecurityContext ctx, Class rootType, long userId) throws DSOutOfServiceException {
        ParametersI param = new ParametersI();
        if (userId >= 0L) {
            param.exp(rtypes.rlong(userId));
        }
        param.orphan();
        return this.loadHierarchy(ctx, rootType, null, param);
    }

    public Set<DataObject> loadHierarchy(SecurityContext ctx, Class rootType, List<Long> rootIDs, Parameters options) throws DSOutOfServiceException {
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            return PojoMapper.asDataObjects(service.loadContainerHierarchy(PojoMapper.getModelType(rootType).getName(), rootIDs, options));
        }
        catch (Throwable t) {
            this.logError(this, "Could not load hierarchy", t);
            return Collections.emptySet();
        }
    }

    public <T extends DataObject> T findObject(SecurityContext ctx, Class<T> klass, long id) throws DSOutOfServiceException, DSAccessException {
        return this.findObject(ctx, klass, id, false);
    }

    public <T extends DataObject> T findObject(SecurityContext ctx, Class<T> klass, long id, boolean allGroups) throws DSOutOfServiceException, DSAccessException {
        String klassName = PojoMapper.getModelType(klass).getSimpleName();
        IObject obj = this.findIObject(ctx, klassName, id, allGroups);
        if (obj == null) {
            return null;
        }
        return (T)PojoMapper.asDataObject(obj);
    }

    public IObject findIObject(SecurityContext ctx, String klassName, long id) throws DSOutOfServiceException, DSAccessException {
        return this.findIObject(ctx, klassName, id, false);
    }

    public DataObject findObject(SecurityContext ctx, String pojoName, long id) throws DSOutOfServiceException, DSAccessException {
        return this.findObject(ctx, pojoName, id, false);
    }

    public IObject findIObject(SecurityContext ctx, String klassName, long id, boolean allGroups) throws DSOutOfServiceException, DSAccessException {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            if (allGroups) {
                m.put("omero.group", "-1");
            } else {
                m.put("omero.group", "" + ctx.getGroupID());
            }
            IQueryPrx service = this.gateway.getQueryService(ctx);
            return service.find(klassName, id, m);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot retrieve the requested object with object ID: " + id);
            return null;
        }
    }

    public DataObject findObject(SecurityContext ctx, String pojoName, long id, boolean allGroups) throws DSOutOfServiceException, DSAccessException {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            if (allGroups) {
                m.put("omero.group", "-1");
            } else {
                m.put("omero.group", "" + ctx.getGroupID());
            }
            Class<? extends IObject> klass = PojoMapper.getModelType(pojoName);
            IQueryPrx service = this.gateway.getQueryService(ctx);
            IObject iobj = service.find(klass.getSimpleName(), id, m);
            if (iobj == null) {
                return null;
            }
            return PojoMapper.asDataObject(iobj);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot retrieve the requested object with object ID: " + id);
            return null;
        }
    }

    public IObject findIObject(SecurityContext ctx, IObject o) throws DSOutOfServiceException, DSAccessException {
        if (o == null || o.getId() == null) {
            return null;
        }
        try {
            IQueryPrx service = this.gateway.getQueryService(ctx);
            return service.find(o.getClass().getName(), o.getId().getValue());
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot retrieve the requested object with object ID: " + o.getId());
            return null;
        }
    }

    public Set<GroupData> getAvailableGroups(SecurityContext ctx, ExperimenterData user) throws DSOutOfServiceException, DSAccessException {
        HashSet<GroupData> pojos = new HashSet<GroupData>();
        try {
            IQueryPrx service = this.gateway.getQueryService(ctx);
            ParametersI p = new ParametersI();
            p.addId(user.getId());
            List<IObject> groups = service.findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent p where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", p);
            for (ExperimenterGroup experimenterGroup : groups) {
                pojos.add((GroupData)PojoMapper.asDataObject(experimenterGroup));
            }
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot retrieve the available groups ");
            return pojos;
        }
    }

    public Collection<ProjectData> getProjects(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        return this.getProjects(ctx, -1L);
    }

    public Collection<ProjectData> getProjects(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.getProjects(ctx, -1L, ids);
    }

    public Collection<ProjectData> getProjects(SecurityContext ctx, long ownerId) throws DSOutOfServiceException, DSAccessException {
        try {
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<IObject> projects = service.loadContainerHierarchy(PojoMapper.getModelType(ProjectData.class).getName(), null, param);
            ArrayList<ProjectData> result = new ArrayList<ProjectData>(projects.size());
            for (IObject proj : projects) {
                result.add((ProjectData)PojoMapper.asDataObject(proj));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load projects");
            return Collections.emptyList();
        }
    }

    public Collection<ProjectData> getProjects(SecurityContext ctx, long ownerId, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            ArrayList<Long> idsList = new ArrayList<Long>(ids.size());
            for (long id : ids) {
                idsList.add(id);
            }
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            List<IObject> projects = service.loadContainerHierarchy(PojoMapper.getModelType(ProjectData.class).getName(), idsList, param);
            ArrayList<ProjectData> result = new ArrayList<ProjectData>(projects.size());
            for (IObject proj : projects) {
                result.add((ProjectData)PojoMapper.asDataObject(proj));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load projects");
            return Collections.emptyList();
        }
    }

    public Collection<DatasetData> getDatasets(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        return this.getDatasets(ctx, -1L);
    }

    public Collection<DatasetData> getDatasets(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.getDatasets(ctx, -1L, ids);
    }

    public Collection<DatasetData> getDatasets(SecurityContext ctx, long ownerId) throws DSOutOfServiceException, DSAccessException {
        try {
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<IObject> datasets = service.loadContainerHierarchy(PojoMapper.getModelType(DatasetData.class).getName(), null, param);
            ArrayList<DatasetData> result = new ArrayList<DatasetData>(datasets.size());
            for (IObject ds : datasets) {
                result.add((DatasetData)PojoMapper.asDataObject(ds));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load datasets");
            return Collections.emptyList();
        }
    }

    public Collection<DatasetData> getDatasets(SecurityContext ctx, long ownerId, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            ArrayList<Long> idsList = new ArrayList<Long>(ids.size());
            for (long id : ids) {
                idsList.add(id);
            }
            ParametersI param = new ParametersI();
            if (ownerId >= 0L) {
                param.exp(rtypes.rlong(ownerId));
            }
            param.leaves();
            List<IObject> datasets = service.loadContainerHierarchy(PojoMapper.getModelType(DatasetData.class).getName(), idsList, param);
            ArrayList<DatasetData> result = new ArrayList<DatasetData>(datasets.size());
            for (IObject ds : datasets) {
                result.add((DatasetData)PojoMapper.asDataObject(ds));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load datasets");
            return Collections.emptyList();
        }
    }

    public Collection<ScreenData> getScreens(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        return this.getScreens(ctx, -1L);
    }

    public Collection<ScreenData> getScreens(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.getScreens(ctx, -1L, ids);
    }

    public Collection<ScreenData> getScreens(SecurityContext ctx, long ownerId) throws DSOutOfServiceException, DSAccessException {
        try {
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<IObject> screens = service.loadContainerHierarchy(PojoMapper.getModelType(ScreenData.class).getName(), null, param);
            ArrayList<ScreenData> result = new ArrayList<ScreenData>(screens.size());
            for (IObject s : screens) {
                result.add((ScreenData)PojoMapper.asDataObject(s));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load screens");
            return Collections.emptyList();
        }
    }

    public Collection<ScreenData> getScreens(SecurityContext ctx, long ownerId, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            ArrayList<Long> idsList = new ArrayList<Long>(ids.size());
            for (long id : ids) {
                idsList.add(id);
            }
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            List<IObject> screens = service.loadContainerHierarchy(PojoMapper.getModelType(ScreenData.class).getName(), idsList, param);
            ArrayList<ScreenData> result = new ArrayList<ScreenData>(screens.size());
            for (IObject s : screens) {
                result.add((ScreenData)PojoMapper.asDataObject(s));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load screens");
            return Collections.emptyList();
        }
    }

    public Collection<PlateData> getPlates(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        return this.getPlates(ctx, -1L);
    }

    public Collection<PlateData> getPlates(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.getPlates(ctx, -1L, ids);
    }

    public Collection<PlateData> getPlates(SecurityContext ctx, long ownerId) throws DSOutOfServiceException, DSAccessException {
        try {
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<IObject> plates = service.loadContainerHierarchy(PojoMapper.getModelType(PlateData.class).getName(), null, param);
            ArrayList<PlateData> result = new ArrayList<PlateData>(plates.size());
            for (IObject p : plates) {
                result.add((PlateData)PojoMapper.asDataObject(p));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load plates");
            return Collections.emptyList();
        }
    }

    public Collection<PlateData> getPlates(SecurityContext ctx, long ownerId, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            IContainerPrx service = this.gateway.getPojosService(ctx);
            ArrayList<Long> idsList = new ArrayList<Long>(ids.size());
            for (long id : ids) {
                idsList.add(id);
            }
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            List<IObject> plates = service.loadContainerHierarchy(PojoMapper.getModelType(PlateData.class).getName(), idsList, param);
            ArrayList<PlateData> result = new ArrayList<PlateData>(plates.size());
            for (IObject p : plates) {
                result.add((PlateData)PojoMapper.asDataObject(p));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load plates");
            return Collections.emptyList();
        }
    }

    public Collection<WellData> getWells(SecurityContext ctx, Collection<Long> wellIds) throws DSOutOfServiceException, DSAccessException {
        ArrayList<WellData> result = new ArrayList<WellData>();
        if (CollectionUtils.isEmpty(wellIds)) {
            return result;
        }
        try {
            IQueryPrx proxy = this.gateway.getQueryService(ctx);
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addIds(wellIds);
            sb.append("select well from Well as well ");
            sb.append("left outer join fetch well.plate as pt ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.plateAcquisition as pa ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where well.id in (:ids)");
            List<IObject> results = proxy.findAllByQuery(sb.toString(), param);
            Iterator<IObject> i = results.iterator();
            while (i.hasNext()) {
                WellData well = new WellData((Well)i.next());
                result.add(well);
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load wells");
        }
        return result;
    }

    public Collection<WellData> getWells(SecurityContext ctx, long plateId) throws DSOutOfServiceException, DSAccessException {
        ArrayList<WellData> result = new ArrayList<WellData>();
        if (plateId < 0L) {
            return result;
        }
        try {
            IQueryPrx proxy = this.gateway.getQueryService(ctx);
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addLong("plateID", plateId);
            sb.append("select well from Well as well ");
            sb.append("left outer join fetch well.plate as pt ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.plateAcquisition as pa ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where well.plate.id = :plateID");
            List<IObject> results = proxy.findAllByQuery(sb.toString(), param);
            Iterator<IObject> i = results.iterator();
            while (i.hasNext()) {
                WellData well = new WellData((Well)i.next());
                result.add(well);
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load wells");
        }
        return result;
    }

    public Collection<ImageData> getUserImages(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        try {
            ParametersI param = new ParametersI();
            param.grp(rtypes.rlong(ctx.getGroupID()));
            if (ctx.getExperimenter() >= 0L) {
                param.exp(rtypes.rlong(ctx.getExperimenter()));
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<Image> images = service.getUserImages(param);
            ArrayList<ImageData> result = new ArrayList<ImageData>(images.size());
            for (Image img : images) {
                result.add((ImageData)PojoMapper.asDataObject(img));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not images");
            return Collections.emptyList();
        }
    }

    public ImageData getImage(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        return this.getImages(ctx, Collections.singleton(id)).iterator().next();
    }

    public ImageData getImage(SecurityContext ctx, long id, ParametersI params) throws DSOutOfServiceException, DSAccessException {
        return this.getImages(ctx, Collections.singleton(id), params).iterator().next();
    }

    public Collection<ImageData> getImages(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        return this.getImages(ctx, ids, null);
    }

    public Collection<ImageData> getImages(SecurityContext ctx, Collection<Long> ids, ParametersI params) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<Long> idsList = new ArrayList<Long>(ids.size());
            for (long id : ids) {
                idsList.add(id);
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<Image> images = service.getImages(PojoMapper.getModelType(ImageData.class).getName(), idsList, params);
            ArrayList<ImageData> result = new ArrayList<ImageData>(images.size());
            for (Image img : images) {
                result.add((ImageData)PojoMapper.asDataObject(img));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load images");
            return Collections.emptyList();
        }
    }

    public Collection<ImageData> getOrphanedImages(SecurityContext ctx, long userID) {
        try {
            IQueryPrx svc = this.gateway.getQueryService(ctx);
            StringBuilder sb = new StringBuilder();
            sb.append("select img from Image as img ");
            sb.append("left outer join fetch img.details.owner ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where not exists (select obl from DatasetImageLink as obl where obl.child = img.id)");
            sb.append(" and not exists (select ws from WellSample as ws where ws.image = img.id)");
            ParametersI param = new ParametersI();
            if (userID >= 0L) {
                sb.append(" and img.details.owner.id = :userID");
                param.addLong("userID", userID);
            }
            return PojoMapper.convertToDataObjects(svc.findAllByQuery(sb.toString(), param));
        }
        catch (Throwable t) {
            this.logError(this, "Could not load orphaned images", t);
            return Collections.emptySet();
        }
    }

    public Collection<ImageData> getImages(SecurityContext ctx, long ownerId, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ParametersI param = null;
            if (ownerId >= 0L) {
                param = new ParametersI();
                param.exp(rtypes.rlong(ownerId));
            }
            ArrayList<Long> idsList = new ArrayList<Long>(ids.size());
            for (long id : ids) {
                idsList.add(id);
            }
            IContainerPrx service = this.gateway.getPojosService(ctx);
            List<Image> images = service.getImages(PojoMapper.getModelType(ImageData.class).getName(), idsList, param);
            ArrayList<ImageData> result = new ArrayList<ImageData>(images.size());
            for (Image img : images) {
                result.add((ImageData)PojoMapper.asDataObject(img));
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load images");
            return Collections.emptyList();
        }
    }

    public Collection<ImageData> getImagesForDatasets(SecurityContext ctx, Collection<Long> datasetIds) throws DSOutOfServiceException, DSAccessException {
        if (datasetIds == null || datasetIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<ImageData> result = new ArrayList<ImageData>();
            Collection<DatasetData> datasets = this.getDatasets(ctx, datasetIds);
            for (DatasetData ds : datasets) {
                for (Object obj : ds.getImages()) {
                    if (!(obj instanceof ImageData)) continue;
                    result.add((ImageData)obj);
                }
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load images");
            return Collections.emptyList();
        }
    }

    public Collection<ImageData> getImagesForProjects(SecurityContext ctx, Collection<Long> projectIds) throws DSOutOfServiceException, DSAccessException {
        if (projectIds == null || projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Collection<ProjectData> projects = this.getProjects(ctx, projectIds);
            ArrayList<Long> dsIds = new ArrayList<Long>();
            for (ProjectData proj : projects) {
                for (DatasetData ds : proj.getDatasets()) {
                    dsIds.add(ds.getId());
                }
            }
            return this.getImagesForDatasets(ctx, dsIds);
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load images");
            return Collections.emptyList();
        }
    }

    public Collection<FolderData> loadFolders(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.addIds(ids);
            List<IObject> list = qs.findAllByQuery("select folder from Folder as folder left outer join fetch folder.parentFolder as parentFolder left outer join fetch folder.childFolders as childFolders left outer join fetch folder.roiLinks as roiLinks left outer join fetch roiLinks.child as roi left outer join fetch roi.shapes as shapes left outer join fetch folder.annotationLinks as annotationLinks left outer join fetch folder.imageLinks as imageLinks left outer join fetch folder.details.owner as owner where folder.id in (:ids)", param);
            ArrayList<FolderData> result = new ArrayList<FolderData>();
            for (IObject l : list) {
                result.add(new FolderData((Folder)l));
            }
            return result;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot load folders.");
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<FolderData> getFolders(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            List<IObject> list = qs.findAllByQuery("select folder from Folder as folder ", null);
            ArrayList<FolderData> result = new ArrayList<FolderData>(list.size());
            for (IObject obj : list) {
                result.add(new FolderData((Folder)obj));
            }
            return result;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot load folders.");
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<FolderData> getFolders(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.addIds(ids);
            List<IObject> list = qs.findAllByQuery("select folder from Folder as folder where folder.id in (:ids)", param);
            ArrayList<FolderData> result = new ArrayList<FolderData>(list.size());
            for (IObject obj : list) {
                result.add(new FolderData((Folder)obj));
            }
            return result;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot load folders.");
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<FolderData> getFolders(SecurityContext ctx, long userId) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.addLong("userId", userId);
            List<IObject> list = qs.findAllByQuery("select folder from Folder as folder where folder.details.owner.id = :userId", param);
            ArrayList<FolderData> result = new ArrayList<FolderData>(list.size());
            for (IObject obj : list) {
                result.add(new FolderData((Folder)obj));
            }
            return result;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot load folders.");
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<String> getLookupTables(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        try {
            IScriptPrx service = this.gateway.getScriptService(ctx);
            List<OriginalFile> scripts = service.getScriptsByMimetype(LUT_MIMETYPE);
            ArrayList<String> result = new ArrayList<String>(scripts.size());
            for (OriginalFile of : scripts) {
                result.add(of.getName().getValue());
            }
            return result;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load lookup tables.");
            return Collections.EMPTY_LIST;
        }
    }
}

