/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.ApiUsageException;
import omero.ServerError;
import omero.api.IAdminPrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.Facility;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.util.PojoMapper;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.Permissions;
import omero.model.PermissionsI;
import omero.rtypes;
import omero.sys.Roles;

public class AdminFacility
extends Facility {
    private Roles roles;

    AdminFacility(Gateway gateway) {
        super(gateway);
    }

    public GroupData createGroup(SecurityContext ctx, GroupData groupData, ExperimenterData owner, int permissions) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gateway.getAdminService(ctx);
            if (this.lookupGroup(ctx, groupData.getName()) != null) {
                return null;
            }
            ExperimenterGroup g = new ExperimenterGroupI();
            g.setName(rtypes.rstring(groupData.getName()));
            g.setLdap(rtypes.rbool(false));
            g.setDescription(rtypes.rstring(groupData.getDescription()));
            g.getDetails().setPermissions(this.createPermissions(permissions));
            long groupID = svc.createGroup(g);
            g = svc.getGroup(groupID);
            ArrayList<ExperimenterGroupI> list = new ArrayList<ExperimenterGroupI>();
            list.add((ExperimenterGroupI)g);
            if (owner != null) {
                svc.setGroupOwner(g, owner.asExperimenter());
            }
            return (GroupData)PojoMapper.asDataObject(g);
        }
        catch (Exception e) {
            this.handleException(this, e, "Cannot create group and owner.");
            return null;
        }
    }

    public ExperimenterData createExperimenter(SecurityContext ctx, ExperimenterData exp, String username, String password, List<GroupData> groups, boolean isAdmin, boolean isGroupOwner) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gateway.getAdminService(ctx);
            ExperimenterGroup g = null;
            ArrayList<ExperimenterGroup> l = new ArrayList<ExperimenterGroup>();
            if (groups != null && groups.size() >= 1) {
                g = groups.get(0).asGroup();
                Iterator<GroupData> j = groups.iterator();
                while (j.hasNext()) {
                    l.add(j.next().asGroup());
                }
            }
            boolean systemGroup = false;
            ExperimenterGroupI userGroup = new ExperimenterGroupI(this.getRoles((SecurityContext)ctx).userGroupId, false);
            ExperimenterGroupI system = new ExperimenterGroupI(this.getRoles((SecurityContext)ctx).systemGroupId, false);
            ExperimenterData value = this.lookupExperimenter(ctx, username);
            if (value == null) {
                if (isAdmin) {
                    l.add(userGroup);
                    l.add(system);
                } else {
                    l.add(userGroup);
                }
                if (g == null) {
                    g = (ExperimenterGroup)l.get(0);
                    systemGroup = true;
                }
                exp.asExperimenter().setOmeName(rtypes.rstring(username));
                exp.asExperimenter().setLdap(rtypes.rbool(false));
                long id = password != null && password.length() > 0 ? svc.createExperimenterWithPassword(exp.asExperimenter(), rtypes.rstring(password), g, l) : svc.createExperimenter(exp.asExperimenter(), g, l);
                exp = (ExperimenterData)PojoMapper.asDataObject(svc.getExperimenter(id));
                if (isGroupOwner && !systemGroup) {
                    svc.setGroupOwner(g, exp.asExperimenter());
                }
                return exp;
            }
        }
        catch (Exception e) {
            this.handleException(this, e, "Cannot create the experimenters.");
        }
        return null;
    }

    public GroupData lookupGroup(SecurityContext ctx, String name) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gateway.getAdminService(ctx);
            ExperimenterGroup g = svc.lookupGroup(name);
            return (GroupData)(g == null ? null : PojoMapper.asDataObject(g));
        }
        catch (Exception e) {
            if (e instanceof ApiUsageException) {
                return null;
            }
            this.handleException(this, e, "Cannot load the group.");
            return null;
        }
    }

    public ExperimenterData lookupExperimenter(SecurityContext ctx, String name) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gateway.getAdminService(ctx);
            Experimenter exp = svc.lookupExperimenter(name);
            return exp == null ? null : (ExperimenterData)PojoMapper.asDataObject(exp);
        }
        catch (Exception e) {
            if (e instanceof ApiUsageException) {
                return null;
            }
            this.handleException(this, e, "Cannot load the required group.");
            return null;
        }
    }

    private Permissions createPermissions(int level) {
        String perms = "rw----";
        switch (level) {
            case 1: {
                perms = "rwr---";
                break;
            }
            case 2: {
                perms = "rwra--";
                break;
            }
            case 3: {
                perms = "rwrw--";
                break;
            }
            case 4: {
                perms = "rwrwr-";
            }
        }
        return new PermissionsI(perms);
    }

    private Roles getRoles(SecurityContext ctx) {
        try {
            if (this.roles == null) {
                this.roles = this.gateway.getAdminService(ctx).getSecurityRoles();
            }
            return this.roles;
        }
        catch (ServerError serverError) {
        }
        catch (DSOutOfServiceException dSOutOfServiceException) {
            // empty catch block
        }
        return null;
    }
}

