/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.LegalGraphTargets;
import omero.cmd.LegalGraphTargetsResponse;
import omero.cmd.Response;
import omero.cmd.graphs.GraphRequestFactory;

public class LegalGraphTargetsI
extends LegalGraphTargets
implements IRequest {
    private final GraphRequestFactory graphRequestFactory;
    private Helper helper;

    public LegalGraphTargetsI(GraphRequestFactory graphRequestFactory) {
        this.graphRequestFactory = graphRequestFactory;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        helper.setSteps(1);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        if (step == 0) {
            try {
                return this.graphRequestFactory.getLegalTargets(this.request.getClass());
            }
            catch (Exception e) {
                throw this.helper.cancel(new ERR(), (Throwable)e, "graph-no-targets", new String[0]);
            }
        }
        IllegalArgumentException e = new IllegalArgumentException("request has no step " + step);
        throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            LegalGraphTargetsResponse response = new LegalGraphTargetsResponse();
            Collection legalTargetClasses = (Collection)object;
            response.targets = new ArrayList<String>(legalTargetClasses.size());
            for (Class legalTargetClass : legalTargetClasses) {
                response.targets.add(legalTargetClass.getName());
            }
            this.helper.setResponseIfNull(response);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }
}

