/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.internal.Details;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.graphs.ModelObjectSequencer;
import omero.cmd.GraphModify2;
import omero.cmd.graphs.ChildOption;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.hibernate.Session;

public class GraphUtil {
    static void copyFields(GraphModify2 requestFrom, GraphModify2 requestTo) {
        if (requestFrom.targetObjects == null) {
            requestTo.targetObjects = null;
        } else {
            requestTo.targetObjects = new HashMap();
            for (Map.Entry targetObjectsOneClass : requestFrom.targetObjects.entrySet()) {
                String targetClass = (String)targetObjectsOneClass.getKey();
                List targetIds = (List)targetObjectsOneClass.getValue();
                requestTo.targetObjects.put(targetClass, new ArrayList(targetIds));
            }
        }
        requestTo.childOptions = requestFrom.childOptions == null ? null : new ArrayList<ChildOption>(requestFrom.childOptions);
        requestTo.dryRun = requestFrom.dryRun;
    }

    static <X> SetMultimap<String, X> trimPackageNames(SetMultimap<String, X> entriesByFullName) {
        LinkedHashMultimap<String, X> entriesBySimpleName = LinkedHashMultimap.create();
        for (Map.Entry<String, Collection<X>> entriesForOneClass : entriesByFullName.asMap().entrySet()) {
            String fullClassName = entriesForOneClass.getKey();
            String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            Collection<X> values = entriesForOneClass.getValue();
            entriesBySimpleName.putAll(simpleClassName, values);
        }
        return entriesBySimpleName;
    }

    public static Map<String, List<Long>> copyMultimapForResponse(SetMultimap<String, Long> result) {
        HashMap<String, List<Long>> forResponse = new HashMap<String, List<Long>>();
        for (Map.Entry<String, Collection<Long>> oneClass : result.asMap().entrySet()) {
            String className = oneClass.getKey();
            Collection<Long> ids = oneClass.getValue();
            forResponse.put(className, new ArrayList<Long>(ids));
        }
        return forResponse;
    }

    static SetMultimap<String, Long> arrangeDeletionTargets(Session session, SetMultimap<String, Long> targetObjects) {
        if (targetObjects.get(OriginalFile.class.getName()).size() < 2) {
            return targetObjects;
        }
        LinkedHashMultimap<String, Long> orderedIds = LinkedHashMultimap.create();
        for (Map.Entry<String, Collection<Long>> targetObjectsByClass : targetObjects.asMap().entrySet()) {
            String className = targetObjectsByClass.getKey();
            Collection<Long> ids = targetObjectsByClass.getValue();
            if (OriginalFile.class.getName().equals(className)) {
                Collection<Collection<Long>> sortedIds = ModelObjectSequencer.sortOriginalFileIds(session, ids);
                ids = new ArrayList<Long>(ids.size());
                for (Collection<Long> idBatch : sortedIds) {
                    ids.addAll(idBatch);
                }
            }
            orderedIds.putAll(className, ids);
        }
        return orderedIds;
    }

    static GraphTraversal.Processor disableProcessor(final GraphTraversal.Processor processor) {
        return new GraphTraversal.Processor(){

            @Override
            public void nullProperties(String className, String propertyName, Collection<Long> ids) {
            }

            @Override
            public void deleteInstances(String className, Collection<Long> ids) {
            }

            @Override
            public void processInstances(String className, Collection<Long> ids) {
            }

            @Override
            public Set<GraphPolicy.Ability> getRequiredPermissions() {
                return processor.getRequiredPermissions();
            }

            @Override
            public void assertMayProcess(String className, long id, Details details) throws GraphException {
                processor.assertMayProcess(className, id, details);
            }
        };
    }

    static <X> Set<X> filterComplexValue(Function<Object, X> mapping, Object value) {
        return value == null ? Collections.emptySet() : GraphUtil.filterComplexValue(new HashSet(), mapping, value);
    }

    private static <X> Set<X> filterComplexValue(Set<X> sought, Function<Object, X> mapping, Object value) {
        X mapped;
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object element : iterable) {
                GraphUtil.filterComplexValue(sought, mapping, element);
            }
            return sought;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry element : map.entrySet()) {
                GraphUtil.filterComplexValue(sought, mapping, element.getKey());
                GraphUtil.filterComplexValue(sought, mapping, element.getValue());
            }
        } else if (value != null && (mapped = mapping.apply(value)) != null) {
            sought.add(mapped);
        }
        return sought;
    }

    static Object copyComplexValue(Function<Object, ? extends Object> mapping, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List original = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(original.size());
            for (Object element : original) {
                copy.add(GraphUtil.copyComplexValue(mapping, element));
            }
            return copy;
        }
        if (value instanceof Set) {
            Set original = (Set)value;
            HashSet<Object> copy = new HashSet<Object>();
            for (Object element : original) {
                copy.add(GraphUtil.copyComplexValue(mapping, element));
            }
            return copy;
        }
        if (value instanceof Map) {
            Map original = (Map)value;
            HashMap<Object, Object> copy = new HashMap<Object, Object>();
            for (Map.Entry element : original.entrySet()) {
                copy.put(GraphUtil.copyComplexValue(mapping, element.getKey()), GraphUtil.copyComplexValue(mapping, element.getValue()));
            }
            return copy;
        }
        Object mapped = mapping.apply(value);
        return mapped == null ? value : mapped;
    }

    public static Predicate<Class<? extends IObject>> getPredicateFromClasses(final Iterable<Class<? extends IObject>> matchTypes) {
        return new Predicate<Class<? extends IObject>>(){

            @Override
            public boolean apply(Class<? extends IObject> subjectType) {
                for (Class matchType : matchTypes) {
                    if (!matchType.isAssignableFrom(subjectType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static class ParameterReporter {
        private final List<String> parameters = new ArrayList<String>();

        ParameterReporter() {
        }

        private static void possiblySort(Collection<Object> collection) {
            if (!(collection instanceof List)) {
                return;
            }
            ArrayList<Comparable> comparableElements = new ArrayList<Comparable>(collection.size());
            for (Object element : collection) {
                if (element instanceof Comparable) {
                    comparableElements.add((Comparable)element);
                    continue;
                }
                return;
            }
            Collections.sort(comparableElements);
            collection.clear();
            for (Comparable comparableElement : comparableElements) {
                collection.add(comparableElement);
            }
        }

        void addParameter(String name, Collection<Object> values) {
            if (CollectionUtils.isEmpty(values)) {
                return;
            }
            ParameterReporter.possiblySort(values);
            ArrayList<String> elements = new ArrayList<String>();
            for (Object element : values) {
                if (element instanceof ChildOption) {
                    ChildOption childOption = (ChildOption)element;
                    StringBuilder sb = new StringBuilder();
                    sb.append('<');
                    ParameterReporter arguments = new ParameterReporter();
                    arguments.addParameter("includeType", childOption.includeType);
                    arguments.addParameter("excludeType", childOption.excludeType);
                    arguments.addParameter("includeNs", childOption.includeNs);
                    arguments.addParameter("excludeNs", childOption.excludeNs);
                    sb.append(arguments);
                    sb.append('>');
                    element = sb;
                }
                elements.add(element.toString());
            }
            this.parameters.add(name + " = [" + Joiner.on(',').join(elements) + "]");
        }

        void addParameter(String name, Map<String, List<Long>> values) {
            if (MapUtils.isEmpty(values)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append(" = ");
            sb.append('{');
            boolean needComma = false;
            if (!(values instanceof SortedMap)) {
                values = new TreeMap<String, List<Long>>(values);
            }
            for (Map.Entry<String, List<Long>> oneClass : values.entrySet()) {
                if (needComma) {
                    sb.append(',');
                } else {
                    needComma = true;
                }
                sb.append(oneClass.getKey());
                sb.append(':');
                List<Long> ids = oneClass.getValue();
                Collections.sort(ids);
                sb.append('[');
                sb.append(Joiner.on(',').join(ids));
                sb.append(']');
            }
            sb.append('}');
            this.parameters.add(sb.toString());
        }

        void addParameter(String name, Object value) {
            if (value instanceof Collection) {
                this.addParameter(name, (Collection)value);
            } else if (value instanceof Map) {
                this.addParameter(name, (Map)value);
            } else if (value != null) {
                this.parameters.add(name + " = " + value);
            }
        }

        public String toString() {
            return Joiner.on(", ").join(this.parameters);
        }
    }
}

