/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.security.ACLVoter;
import ome.security.SystemTypes;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRule;
import ome.system.Roles;
import omero.cmd.GraphModify2;
import omero.cmd.GraphQuery;
import omero.cmd.Request;
import omero.cmd.SkipHead;
import omero.cmd.graphs.ChildOption;
import omero.cmd.graphs.ChildOptionI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GraphRequestFactory
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphRequestFactory.class);
    private final ACLVoter aclVoter;
    private final Roles securityRoles;
    private final SystemTypes systemTypes;
    private final GraphPathBean graphPathBean;
    private final Deletion deletionInstance;
    private final ImmutableSetMultimap<Class<? extends Request>, Class<? extends IObject>> allTargets;
    private final ImmutableMap<Class<? extends Request>, GraphPolicy> graphPolicies;
    private final ImmutableSetMultimap<String, String> unnullable;
    private final ImmutableSet<String> defaultExcludeNs;
    private ApplicationContext applicationContext = null;

    public GraphRequestFactory(ACLVoter aclVoter, Roles securityRoles, SystemTypes systemTypes, GraphPathBean graphPathBean, Deletion deletionInstance, Map<Class<? extends Request>, List<String>> allTargets, Map<Class<? extends Request>, List<GraphPolicyRule>> allRules, List<String> unnullable, Set<String> defaultExcludeNs) throws GraphException {
        this.aclVoter = aclVoter;
        this.securityRoles = securityRoles;
        this.systemTypes = systemTypes;
        this.graphPathBean = graphPathBean;
        this.deletionInstance = deletionInstance;
        ImmutableSetMultimap.Builder allTargetsBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<Class<? extends Request>, List<String>> entry : allTargets.entrySet()) {
            Class<? extends Request> clazz = entry.getKey();
            for (String targetClassName : entry.getValue()) {
                allTargetsBuilder.put(clazz, graphPathBean.getClassForSimpleName(targetClassName));
            }
        }
        this.allTargets = allTargetsBuilder.build();
        ImmutableMap.Builder<Class<? extends Request>, GraphPolicy> graphPoliciesBuilder = ImmutableMap.builder();
        for (Map.Entry<Class<? extends Request>, List<GraphPolicyRule>> entry : allRules.entrySet()) {
            graphPoliciesBuilder.put(entry.getKey(), GraphPolicyRule.parseRules(graphPathBean, (Collection<GraphPolicyRule>)entry.getValue()));
        }
        this.graphPolicies = graphPoliciesBuilder.build();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (String classProperty : unnullable) {
            int period = classProperty.indexOf(46);
            String classNameSimple = classProperty.substring(0, period);
            String property = classProperty.substring(period + 1);
            String classNameFull = graphPathBean.getClassForSimpleName(classNameSimple).getName();
            builder.put(classNameFull, property);
        }
        this.unnullable = builder.build();
        this.defaultExcludeNs = ImmutableSet.copyOf(defaultExcludeNs);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public GraphPathBean getGraphPathBean() {
        return this.graphPathBean;
    }

    public <R extends GraphQuery> Set<Class<? extends IObject>> getLegalTargets(Class<R> requestClass) {
        ImmutableCollection targetClasses = this.allTargets.get(requestClass);
        if (targetClasses.isEmpty()) {
            throw new IllegalArgumentException("no legal target classes defined for request class " + requestClass);
        }
        return targetClasses;
    }

    public <R extends GraphQuery> R getRequest(Class<R> requestClass) {
        GraphQuery request;
        try {
            if (SkipHead.class.isAssignableFrom(requestClass)) {
                Constructor<R> constructor = requestClass.getConstructor(GraphPathBean.class, GraphRequestFactory.class);
                request = (GraphQuery)constructor.newInstance(this.graphPathBean, this);
            } else {
                Set<Class<IObject>> targetClasses = this.getLegalTargets(requestClass);
                GraphPolicy graphPolicy = this.graphPolicies.get(requestClass);
                if (graphPolicy == null) {
                    throw new IllegalArgumentException("no graph traversal policy rules defined for request class " + requestClass);
                }
                graphPolicy = graphPolicy.getCleanInstance();
                if (GraphModify2.class.isAssignableFrom(requestClass)) {
                    Constructor<R> constructor = requestClass.getConstructor(ACLVoter.class, Roles.class, SystemTypes.class, GraphPathBean.class, Deletion.class, Set.class, GraphPolicy.class, SetMultimap.class, ApplicationContext.class);
                    request = (GraphQuery)constructor.newInstance(this.aclVoter, this.securityRoles, this.systemTypes, this.graphPathBean, this.deletionInstance, targetClasses, graphPolicy, this.unnullable, this.applicationContext);
                } else {
                    Constructor<R> constructor = requestClass.getConstructor(ACLVoter.class, Roles.class, SystemTypes.class, GraphPathBean.class, Set.class, GraphPolicy.class);
                    request = (GraphQuery)constructor.newInstance(this.aclVoter, this.securityRoles, this.systemTypes, this.graphPathBean, targetClasses, graphPolicy);
                }
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalArgumentException("cannot instantiate " + requestClass, e);
        }
        return (R)request;
    }

    public ChildOption createChildOption() {
        return new ChildOptionI(this.graphPathBean, this.defaultExcludeNs);
    }
}

