/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.security.ACLVoter;
import ome.security.SystemTypes;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.graphs.PermissionsPredicate;
import ome.system.Roles;
import omero.cmd.Duplicate;
import omero.cmd.DuplicateResponse;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.BaseGraphTraversalProcessor;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.SkipTailPolicy;
import omero.cmd.graphs.SpecificityClassifier;
import omero.cmd.graphs.WrappableRequest;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DuplicateI
extends Duplicate
implements IRequest,
WrappableRequest<Duplicate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateI.class);
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of();
    private static final int BATCH_SIZE = 256;
    private final ACLVoter aclVoter;
    private final SystemTypes systemTypes;
    private final GraphPathBean graphPathBean;
    private final Set<Class<? extends IObject>> targetClasses;
    private GraphPolicy graphPolicy;
    private final SetMultimap<String, String> unnullable;
    private SpecificityClassifier<Class<? extends IObject>, Inclusion> classifier;
    private List<Function<GraphPolicy, GraphPolicy>> graphPolicyAdjusters = new ArrayList<Function<GraphPolicy, GraphPolicy>>();
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private GraphTraversal.PlanExecutor processor;
    private int targetObjectCount = 0;
    private int duplicatedObjectCount = 0;
    private final Map<IObject, IObject> originalsToDuplicates = new HashMap<IObject, IObject>();
    private final Map<Map.Entry<String, Long>, IObject> originalClassIdToDuplicates = new HashMap<Map.Entry<String, Long>, IObject>();
    private final Multimap<IObject, PropertyUpdate> propertiesToUpdate = ArrayListMultimap.create();
    private final SetMultimap<IObject, IObject> blockedBy = HashMultimap.create();

    public DuplicateI(ACLVoter aclVoter, Roles securityRoles, SystemTypes systemTypes, GraphPathBean graphPathBean, Deletion deletionInstance, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy, SetMultimap<String, String> unnullable, ApplicationContext applicationContext) {
        this.aclVoter = aclVoter;
        this.systemTypes = systemTypes;
        this.graphPathBean = graphPathBean;
        this.targetClasses = targetClasses;
        this.graphPolicy = graphPolicy;
        this.unnullable = unnullable;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("typesToDuplicate", (Object)this.typesToDuplicate);
            arguments.addParameter("typesToReference", (Object)this.typesToReference);
            arguments.addParameter("typesToIgnore", (Object)this.typesToIgnore);
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("childOptions", (Object)this.childOptions);
            arguments.addParameter("dryRun", this.dryRun);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(this.dryRun ? 3 : 8);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        this.classifier = new SpecificityClassifier(new SpecificityClassifier.ContainmentTester<Class<? extends IObject>>(){

            @Override
            public boolean isProperSupersetOf(Class<? extends IObject> parent, Class<? extends IObject> child) {
                return parent != child && parent.isAssignableFrom(child);
            }
        });
        try {
            this.classifier.addClass(Inclusion.DUPLICATE, this.graphHelper.getClassesFromNames(this.typesToDuplicate));
            this.classifier.addClass(Inclusion.REFERENCE, this.graphHelper.getClassesFromNames(this.typesToReference));
            this.classifier.addClass(Inclusion.IGNORE, this.graphHelper.getClassesFromNames(this.typesToIgnore));
        }
        catch (IllegalArgumentException e) {
            throw helper.cancel(new ERR(), (Throwable)e, "bad-class", new String[0]);
        }
        this.graphPolicyAdjusters.add(0, new Function<GraphPolicy, GraphPolicy>(){

            @Override
            public GraphPolicy apply(GraphPolicy graphPolicy) {
                return SkipTailPolicy.getSkipTailPolicy(graphPolicy, new Predicate<Class<? extends IObject>>(){

                    @Override
                    public boolean apply(Class<? extends IObject> modelObject) {
                        Inclusion classification = (Inclusion)((Object)DuplicateI.this.classifier.getClass(modelObject));
                        return classification == Inclusion.REFERENCE || classification == Inclusion.IGNORE;
                    }
                });
            }
        });
        this.graphPolicy.registerPredicate(new PermissionsPredicate());
        this.graphTraversal = this.graphHelper.prepareGraphTraversal(this.childOptions, REQUIRED_ABILITIES, this.graphPolicy, this.graphPolicyAdjusters, this.aclVoter, this.systemTypes, this.graphPathBean, this.unnullable, new InternalProcessor(), this.dryRun);
        this.graphPolicyAdjusters = null;
    }

    private void copySimpleProperties() throws ome.services.graphs.GraphException {
        for (Map.Entry<IObject, IObject> originalAndDuplicate : this.originalsToDuplicates.entrySet()) {
            IObject original = originalAndDuplicate.getKey();
            IObject duplicate = originalAndDuplicate.getValue();
            String originalClass = Hibernate.getClass((Object)original).getName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("copying properties from " + originalClass + ":" + original.getId());
            }
            try {
                for (String superclassName : this.graphPathBean.getSuperclassesOfReflexive(originalClass)) {
                    for (String property : this.graphPathBean.getSimpleProperties(superclassName)) {
                        if (!this.graphPathBean.isPropertyAccessible(superclassName, property)) continue;
                        Object value = PropertyUtils.getProperty((Object)original, (String)property);
                        Object duplicateValue = GraphUtil.copyComplexValue(Functions.constant(null), value);
                        PropertyUtils.setProperty((Object)duplicate, (String)property, (Object)duplicateValue);
                    }
                }
            }
            catch (ReflectiveOperationException | NestedNullException e) {
                throw new ome.services.graphs.GraphException("failed to duplicate " + originalClass + ':' + original.getId());
            }
        }
    }

    private void noteNewPropertyValuesForDuplicates() throws ome.services.graphs.GraphException {
        Function<Object, IObject> duplicateLookup = new Function<Object, IObject>(){

            @Override
            public IObject apply(Object original) {
                if (original instanceof IObject) {
                    String originalClass = original instanceof HibernateProxy ? Hibernate.getClass((Object)original).getName() : original.getClass().getName();
                    Long originalId = ((IObject)original).getId();
                    return (IObject)DuplicateI.this.originalClassIdToDuplicates.get(Maps.immutableEntry(originalClass, originalId));
                }
                return null;
            }
        };
        for (Map.Entry<IObject, IObject> originalAndDuplicate : this.originalsToDuplicates.entrySet()) {
            IObject original = originalAndDuplicate.getKey();
            IObject duplicate = originalAndDuplicate.getValue();
            String originalClass = Hibernate.getClass((Object)original).getName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("noting how to copy properties from " + originalClass + ":" + original.getId());
            }
            try {
                for (String superclassName : this.graphPathBean.getSuperclassesOfReflexive(originalClass)) {
                    for (Map.Entry<String, String> forwardLink : this.graphPathBean.getLinkedTo(superclassName)) {
                        Object value;
                        String linkedClassName = forwardLink.getKey();
                        String property = forwardLink.getValue();
                        if (property.startsWith("details.")) continue;
                        HashSet<Long> linkedToIdsToIgnore = new HashSet<Long>();
                        for (Map.Entry<String, Collection<Long>> linkedToClassIds : this.graphTraversal.getLinkeds(superclassName, property, original.getId()).asMap().entrySet()) {
                            String linkedToClass = linkedToClassIds.getKey();
                            Collection<Long> linkedToIds = linkedToClassIds.getValue();
                            if (this.classifier.getClass(Class.forName(linkedToClass).asSubclass(IObject.class)) != Inclusion.IGNORE) continue;
                            linkedToIdsToIgnore.addAll(linkedToIds);
                        }
                        if (this.graphPathBean.isPropertyAccessible(superclassName, property)) {
                            try {
                                value = PropertyUtils.getNestedProperty((Object)original, (String)property);
                            }
                            catch (NestedNullException e) {
                                continue;
                            }
                            if (value instanceof Collection) {
                                AbstractCollection valueToCopy;
                                Collection valueCollection = (Collection)value;
                                if (value instanceof List) {
                                    valueToCopy = new ArrayList();
                                } else if (value instanceof Set) {
                                    valueToCopy = new HashSet();
                                } else {
                                    throw new ome.services.graphs.GraphException("unexpected collection type: " + value.getClass());
                                }
                                for (IObject linkedTo : valueCollection) {
                                    if (linkedToIdsToIgnore.contains(linkedTo.getId())) continue;
                                    valueToCopy.add(linkedTo);
                                }
                                value = valueToCopy;
                            } else if (value instanceof IObject && linkedToIdsToIgnore.contains(((IObject)value).getId())) {
                                value = null;
                            }
                            if (value != null) {
                                this.propertiesToUpdate.put(duplicate, new PropertyUpdateAccessible(duplicate, property, value));
                            }
                        } else {
                            boolean isOrdered;
                            Method writer;
                            Method reader;
                            Class<IObject> linkerClass = Class.forName(superclassName).asSubclass(IObject.class);
                            Class<IObject> linkedClass = Class.forName(linkedClassName).asSubclass(IObject.class);
                            try {
                                reader = linkerClass.getMethod("iterate" + StringUtils.capitalize(property), new Class[0]);
                                writer = linkerClass.getMethod("add" + linkedClass.getSimpleName(), linkedClass);
                            }
                            catch (NoSuchMethodException | SecurityException e) {
                                continue;
                            }
                            try {
                                linkerClass.getMethod("getPrimary" + linkedClass.getSimpleName(), new Class[0]);
                                isOrdered = true;
                            }
                            catch (NoSuchMethodException | SecurityException e) {
                                isOrdered = false;
                            }
                            value = reader.invoke((Object)original, new Object[0]);
                            this.propertiesToUpdate.put(duplicate, new PropertyUpdateInaccessible(original, duplicate, property, reader, writer, isOrdered));
                            if (isOrdered) {
                                IObject previousDuplicate = null;
                                Iterator valueIterator = (Iterator)reader.invoke((Object)original, new Object[0]);
                                while (valueIterator.hasNext()) {
                                    IObject nextDuplicate = this.originalsToDuplicates.get(valueIterator.next());
                                    if (nextDuplicate == null) continue;
                                    if (previousDuplicate != null) {
                                        this.blockedBy.put(nextDuplicate, previousDuplicate);
                                    }
                                    previousDuplicate = nextDuplicate;
                                }
                            }
                        }
                        Set<IObject> duplicatesInValue = GraphUtil.filterComplexValue(duplicateLookup, value);
                        this.blockedBy.putAll(duplicate, duplicatesInValue);
                    }
                }
            }
            catch (ReflectiveOperationException | NestedNullException e) {
                throw new ome.services.graphs.GraphException("failed to duplicate " + originalClass + ':' + original.getId());
            }
        }
    }

    private void persistDuplicatesWithNewPropertyValues() throws ome.services.graphs.GraphException {
        Session session = this.helper.getSession();
        final ArrayListMultimap propertyUpdateTriggers = ArrayListMultimap.create();
        final HashSet<IObject> persisted = new HashSet<IObject>();
        HashSet<IObject> remainingTransient = new HashSet<IObject>(this.originalsToDuplicates.values());
        while (!remainingTransient.isEmpty()) {
            boolean isProgress = false;
            Iterator remainingTransientIterator = remainingTransient.iterator();
            while (remainingTransientIterator.hasNext()) {
                IObject duplicate = (IObject)remainingTransientIterator.next();
                Set<IObject> blockers = this.blockedBy.get(duplicate);
                blockers.retainAll(remainingTransient);
                if (!blockers.isEmpty()) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("duplicating an instance of " + duplicate.getClass().getName());
                }
                for (final PropertyUpdate propertyUpdate : this.propertiesToUpdate.get(duplicate)) {
                    Function<Object, IObject> duplicateProxyLookup = new Function<Object, IObject>(){

                        @Override
                        public IObject apply(Object original) {
                            if (original instanceof IObject) {
                                String originalClass = original instanceof HibernateProxy ? Hibernate.getClass((Object)original).getName() : original.getClass().getName();
                                Long originalId = ((IObject)original).getId();
                                IObject duplicate = (IObject)DuplicateI.this.originalClassIdToDuplicates.get(Maps.immutableEntry(originalClass, originalId));
                                if (duplicate == null) {
                                    return null;
                                }
                                if (persisted.contains(duplicate)) {
                                    return duplicate;
                                }
                                propertyUpdateTriggers.put(duplicate, propertyUpdate.duplicate);
                            }
                            return null;
                        }
                    };
                    propertyUpdate.execute(duplicateProxyLookup);
                }
                persisted.add(duplicate);
                Function<Object, IObject> duplicateProxyLookup = new Function<Object, IObject>(){

                    @Override
                    public IObject apply(Object original) {
                        if (original instanceof IObject) {
                            String originalClass = original instanceof HibernateProxy ? Hibernate.getClass((Object)original).getName() : original.getClass().getName();
                            Long originalId = ((IObject)original).getId();
                            IObject duplicate = (IObject)DuplicateI.this.originalClassIdToDuplicates.get(Maps.immutableEntry(originalClass, originalId));
                            if (duplicate == null) {
                                return null;
                            }
                            if (persisted.contains(duplicate)) {
                                return duplicate;
                            }
                        }
                        return null;
                    }
                };
                for (IObject objectToUpdate : propertyUpdateTriggers.get(duplicate)) {
                    for (PropertyUpdate update3 : this.propertiesToUpdate.get(objectToUpdate)) {
                        update3.execute(duplicateProxyLookup);
                    }
                }
                propertyUpdateTriggers.removeAll(duplicate);
                ArrayList<PropertyUpdate> arrayList = new ArrayList<PropertyUpdate>(this.propertiesToUpdate.get(duplicate));
                this.propertiesToUpdate.removeAll(duplicate);
                persisted.remove(duplicate);
                session.persist((Object)duplicate);
                this.propertiesToUpdate.putAll(duplicate, arrayList);
                persisted.add(duplicate);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("persisted " + duplicate.getClass().getName() + ":" + duplicate.getId());
                }
                remainingTransientIterator.remove();
                isProgress = true;
            }
            if (isProgress) continue;
            throw new ome.services.graphs.GraphException("internal duplication error: cyclic model graph");
        }
    }

    private void linkToNewDuplicates() throws ome.services.graphs.GraphException {
        Session session = this.helper.getSession();
        for (IObject original : this.originalsToDuplicates.keySet()) {
            String originalClass = Hibernate.getClass((Object)original).getName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("adjusting properties of " + originalClass + ":" + original.getId());
            }
            try {
                for (String superclassName : this.graphPathBean.getSuperclassesOfReflexive(originalClass)) {
                    for (Map.Entry<String, String> backwardLink : this.graphPathBean.getLinkedBy(superclassName)) {
                        String property;
                        String linkingClass = backwardLink.getKey();
                        if (!this.graphPathBean.isPropertyAccessible(linkingClass, property = backwardLink.getValue())) continue;
                        for (Map.Entry<String, Collection<Long>> linkedFromClassIds : this.graphTraversal.getLinkers(linkingClass, property, original.getId()).asMap().entrySet()) {
                            String linkedFromClass = linkedFromClassIds.getKey();
                            Collection<Long> linkedFromIds = linkedFromClassIds.getValue();
                            if (this.classifier.getClass(Class.forName(linkedFromClass).asSubclass(IObject.class)) == Inclusion.IGNORE) continue;
                            String rootQuery = "FROM " + linkedFromClass + " WHERE id IN (:ids)";
                            for (List<Long> idsBatch : Iterables.partition(linkedFromIds, 256)) {
                                List linkers = session.createQuery(rootQuery).setParameterList("ids", idsBatch).list();
                                for (IObject linker : linkers) {
                                    Object value;
                                    if (this.originalsToDuplicates.containsKey(linker)) continue;
                                    try {
                                        value = PropertyUtils.getNestedProperty((Object)linker, (String)property);
                                    }
                                    catch (NestedNullException e) {
                                        continue;
                                    }
                                    if (!(value instanceof Collection)) continue;
                                    Collection valueCollection = (Collection)value;
                                    ArrayList<IObject> newDuplicates = new ArrayList<IObject>();
                                    for (IObject originalLinker : valueCollection) {
                                        IObject duplicateOfValue = this.originalsToDuplicates.get(originalLinker);
                                        if (duplicateOfValue == null) continue;
                                        newDuplicates.add(duplicateOfValue);
                                    }
                                    valueCollection.addAll(newDuplicates);
                                }
                            }
                        }
                    }
                }
            }
            catch (ReflectiveOperationException | NestedNullException e) {
                throw new ome.services.graphs.GraphException("failed to adjust " + originalClass + ':' + original.getId());
            }
        }
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    SetMultimap<String, Long> targetMultimap = this.graphHelper.getTargetMultimap(this.targetClasses, this.targetObjects);
                    this.targetObjectCount += targetMultimap.size();
                    Map.Entry<SetMultimap<String, Long>, SetMultimap<String, Long>> plan = this.graphTraversal.planOperation(this.helper.getSession(), targetMultimap, true, true);
                    if (!plan.getValue().isEmpty()) {
                        IllegalArgumentException e = new IllegalArgumentException("duplication plan unexpectedly includes deletion");
                        throw this.helper.cancel(new ERR(), (Throwable)e, "bad-plan", new String[0]);
                    }
                    this.graphTraversal.assertNoUnlinking();
                    return plan.getKey();
                }
                case 1: {
                    this.graphTraversal.assertNoPolicyViolations();
                    return null;
                }
                case 2: {
                    this.processor = this.graphTraversal.processTargets();
                    return null;
                }
                case 3: {
                    this.processor.execute();
                    return null;
                }
                case 4: {
                    this.copySimpleProperties();
                    return null;
                }
                case 5: {
                    this.noteNewPropertyValuesForDuplicates();
                    return null;
                }
                case 6: {
                    this.persistDuplicatesWithNewPropertyValues();
                    return null;
                }
                case 7: {
                    this.linkToNewDuplicates();
                    return null;
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.dryRun && step == 0) {
            SetMultimap result = (SetMultimap)object;
            Map<String, List<Long>> duplicatedObjects = GraphUtil.copyMultimapForResponse(result);
            this.duplicatedObjectCount += result.size();
            DuplicateResponse response = new DuplicateResponse(duplicatedObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in mock duplication of " + this.targetObjectCount + ", duplicated " + this.duplicatedObjectCount + " in total", new Object[0]);
        } else if (!this.dryRun && step == 6) {
            HashMap<String, List<Long>> duplicatedObjects = new HashMap<String, List<Long>>();
            for (IObject duplicate : this.originalsToDuplicates.values()) {
                String className = duplicate.getClass().getName();
                ArrayList<Long> ids = (ArrayList<Long>)duplicatedObjects.get(className);
                if (ids == null) {
                    ids = new ArrayList<Long>();
                    duplicatedObjects.put(className, ids);
                }
                ids.add(duplicate.getId());
                ++this.duplicatedObjectCount;
            }
            DuplicateResponse response = new DuplicateResponse(duplicatedObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in duplication of " + this.targetObjectCount + ", duplicated " + this.duplicatedObjectCount + " in total", new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
                arguments.addParameter("duplicates", response.duplicates);
                LOGGER.debug("response: " + arguments);
            }
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    @Override
    public void copyFieldsTo(Duplicate request) {
        GraphUtil.copyFields(this, request);
        request.typesToDuplicate = new ArrayList<String>(this.typesToDuplicate);
        request.typesToReference = new ArrayList<String>(this.typesToReference);
        request.typesToIgnore = new ArrayList<String>(this.typesToIgnore);
    }

    @Override
    public void adjustGraphPolicy(Function<GraphPolicy, GraphPolicy> adjuster) {
        if (this.graphPolicyAdjusters == null) {
            throw new IllegalStateException("request is already initialized");
        }
        this.graphPolicyAdjusters.add(adjuster);
    }

    @Override
    public int getStepProvidingCompleteResponse() {
        return this.dryRun ? 0 : 6;
    }

    @Override
    public GraphPolicy.Action getActionForStarting() {
        return GraphPolicy.Action.INCLUDE;
    }

    @Override
    public Map<String, List<Long>> getStartFrom(Response response) {
        return ((DuplicateResponse)response).duplicates;
    }

    private final class InternalProcessor
    extends BaseGraphTraversalProcessor {
        public InternalProcessor() {
            super(DuplicateI.this.helper.getSession());
        }

        @Override
        public void processInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            String rootQuery = "FROM " + className + " WHERE id IN (:ids)";
            for (List<Long> idsBatch : Iterables.partition(ids, 256)) {
                List originals = this.session.createQuery(rootQuery).setParameterList("ids", idsBatch).list();
                for (IObject original : originals) {
                    IObject duplicate;
                    try {
                        duplicate = (IObject)Hibernate.getClass((Object)original).newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new ome.services.graphs.GraphException("cannot create a duplicate of " + original);
                    }
                    String originalClass = Hibernate.getClass((Object)original).getName();
                    Long originalId = original.getId();
                    DuplicateI.this.originalClassIdToDuplicates.put(Maps.immutableEntry(originalClass, originalId), duplicate);
                    DuplicateI.this.originalsToDuplicates.put(original, duplicate);
                }
            }
        }

        @Override
        public Set<GraphPolicy.Ability> getRequiredPermissions() {
            return REQUIRED_ABILITIES;
        }
    }

    private static class PropertyUpdateInaccessible
    extends PropertyUpdate {
        protected final IObject original;
        protected final Method reader;
        protected final Method writer;
        protected final boolean isOrdered;
        private Set<IObject> written = new HashSet<IObject>();

        PropertyUpdateInaccessible(IObject original, IObject duplicate, String property, Method reader, Method writer, boolean isOrdered) {
            super(duplicate, property);
            this.original = original;
            this.reader = reader;
            this.writer = writer;
            this.isOrdered = isOrdered;
        }

        @Override
        void execute(Function<Object, IObject> mapping) throws ome.services.graphs.GraphException {
            try {
                Iterator linkedTos = (Iterator)this.reader.invoke((Object)this.original, new Object[0]);
                boolean stillWriting = true;
                while (linkedTos.hasNext()) {
                    IObject linkedTo = (IObject)linkedTos.next();
                    IObject duplicateOfLinkedTo = mapping.apply(linkedTo);
                    if (stillWriting && duplicateOfLinkedTo != null) {
                        if (!this.written.add(duplicateOfLinkedTo)) continue;
                        this.writer.invoke((Object)this.duplicate, duplicateOfLinkedTo);
                        continue;
                    }
                    if (!this.isOrdered) continue;
                    stillWriting = false;
                }
            }
            catch (ReflectiveOperationException | NestedNullException e) {
                throw new ome.services.graphs.GraphException("cannot set property " + this.property + " on duplicate " + this.duplicate.getClass().getName());
            }
        }
    }

    private static class PropertyUpdateAccessible
    extends PropertyUpdate {
        protected final Object value;

        PropertyUpdateAccessible(IObject duplicate, String property, Object value) {
            super(duplicate, property);
            this.value = value;
        }

        @Override
        void execute(Function<Object, IObject> mapping) throws ome.services.graphs.GraphException {
            Object duplicateValue = GraphUtil.copyComplexValue(mapping, this.value);
            if (duplicateValue != null) {
                try {
                    PropertyUtils.setNestedProperty((Object)this.duplicate, (String)this.property, (Object)duplicateValue);
                }
                catch (ReflectiveOperationException | NestedNullException e) {
                    throw new ome.services.graphs.GraphException("cannot set property " + this.property + " on duplicate " + this.duplicate.getClass().getName());
                }
            }
        }
    }

    private static abstract class PropertyUpdate {
        protected final IObject duplicate;
        protected final String property;

        PropertyUpdate(IObject duplicate, String property) {
            this.duplicate = duplicate;
            this.property = property;
        }

        abstract void execute(Function<Object, IObject> var1) throws ome.services.graphs.GraphException;
    }

    private static enum Inclusion {
        DUPLICATE,
        REFERENCE,
        IGNORE;

    }
}

