/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ome.api.IQuery;
import ome.io.nio.PixelsService;
import ome.io.nio.ThumbnailService;
import ome.model.IObject;
import ome.parameters.Parameters;
import ome.services.graphs.GraphPathBean;
import omero.api.LongPair;
import omero.cmd.DiskUsage;
import omero.cmd.DiskUsageResponse;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.model.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DiskUsageI
extends DiskUsage
implements IRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUsageI.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of("omero.group", "-1");
    private static final ImmutableMultimap<String, Map.Entry<String, String>> TRAVERSAL_QUERIES;
    private static final ImmutableSet<String> OWNED_OBJECTS;
    private static final ImmutableSet<String> ANNOTATABLE_OBJECTS;
    private static final Map<String, String> classIdProperties;
    private final PixelsService pixelsService;
    private final ThumbnailService thumbnailService;
    private final GraphPathBean graphPathBean;
    private Helper helper;

    public DiskUsageI(PixelsService pixelsService, ThumbnailService thumbnailService, GraphPathBean graphPathBean) {
        this.pixelsService = pixelsService;
        this.thumbnailService = thumbnailService;
        this.graphPathBean = graphPathBean;
    }

    public ImmutableMap<String, String> getCallContext() {
        return ALL_GROUPS_CONTEXT;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        helper.setSteps(1);
    }

    @Override
    public DiskUsageResponse step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        if (step != 0) {
            throw this.helper.cancel(new ERR(), (Throwable)new IllegalArgumentException(), "disk usage operation has no step " + step, new String[0]);
        }
        try {
            return this.getDiskUsage();
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "disk usage operation failed", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            this.helper.setResponseIfNull((DiskUsageResponse)object);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private static long getFileSize(String path) {
        File file2 = new File(path);
        return file2.exists() ? file2.length() : 0L;
    }

    private String getIdPropertyFor(String className) throws HandleI.Cancel {
        String idProperty = classIdProperties.get(className);
        if (idProperty == null) {
            Class<? extends IObject> actualClass = this.graphPathBean.getClassForSimpleName(className);
            if (actualClass == null) {
                IllegalArgumentException e = new IllegalArgumentException("class " + className + " is unknown");
                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-class", new String[0]);
            }
            idProperty = this.graphPathBean.getIdentifierProperty(actualClass.getName());
            if (idProperty == null) {
                IllegalArgumentException e = new IllegalArgumentException("no identifier property is known for class " + className);
                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-class", new String[0]);
            }
            classIdProperties.put(className, idProperty);
        }
        return idProperty;
    }

    /*
     * WARNING - void declaration
     */
    private DiskUsageResponse getDiskUsage() {
        IQuery queryService = this.helper.getServiceFactory().getQueryService();
        int batchSize = 256;
        HashMultimap<String, Long> objectsToProcess = HashMultimap.create();
        HashMultimap objectsProcessed = HashMultimap.create();
        Usage usage = new Usage();
        HashMultimap<Long, void> typesWithFiles = HashMultimap.create();
        HashMap<Iterator<Object[]>, OwnershipAndSize> fileSizes = new HashMap<Iterator<Object[]>, OwnershipAndSize>();
        for (String string : this.classes) {
            String hql = "SELECT " + this.getIdPropertyFor(string) + " FROM " + string;
            for (Object[] resultRow : queryService.projection(hql, null)) {
                if (resultRow == null) continue;
                Long objectId = (Long)resultRow[0];
                objectsToProcess.put(string, objectId);
            }
        }
        for (Map.Entry entry : this.objects.entrySet()) {
            objectsToProcess.putAll((String)entry.getKey(), (Iterable<Long>)((Iterable)entry.getValue()));
            if (!LOGGER.isDebugEnabled()) continue;
            ArrayList ids = Lists.newArrayList(objectsToProcess.get((String)entry.getKey()));
            Collections.sort(ids);
            LOGGER.debug("size calculator to process " + (String)entry.getKey() + " " + Joiner.on(", ").join(ids));
        }
        for (String string : objectsToProcess.keySet()) {
            this.getIdPropertyFor(string);
        }
        while (!objectsToProcess.isEmpty()) {
            String hql;
            Object hql2;
            Long groupId;
            Long ownerId;
            void var9_18;
            Map.Entry nextClass = objectsToProcess.asMap().entrySet().iterator().next();
            String string = (String)nextClass.getKey();
            int lastDot = string.lastIndexOf(46);
            if (lastDot >= 0) {
                String string2 = string.substring(lastDot + 1);
            } else if (string.charAt(0) == '/') {
                String string3 = string.substring(1);
            }
            Collection ids = nextClass.getValue();
            ids.removeAll(objectsProcessed.get(var9_18));
            if (ids.isEmpty()) continue;
            ArrayList idsToQuery = Lists.newArrayList(Iterables.limit(ids, 256));
            ids.removeAll(idsToQuery);
            objectsProcessed.putAll(var9_18, idsToQuery);
            Parameters parameters = new Parameters().addIds(idsToQuery);
            if ("Pixels".equals(var9_18)) {
                String hql22 = "SELECT id, details.owner.id, details.group.id FROM Pixels WHERE id IN (:ids)";
                for (Object[] resultRow : queryService.projection("SELECT id, details.owner.id, details.group.id FROM Pixels WHERE id IN (:ids)", parameters)) {
                    if (resultRow == null) continue;
                    Long pixelsId = (Long)resultRow[0];
                    ownerId = (Long)resultRow[1];
                    groupId = (Long)resultRow[2];
                    String pixelsPath = this.pixelsService.getPixelsPath(pixelsId);
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(pixelsPath));
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(pixelsPath + "_pyramid"));
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(pixelsPath + "_pyramid" + ".pyr_lock"));
                }
            } else if ("Thumbnail".equals(var9_18)) {
                hql2 = "SELECT id, details.owner.id, details.group.id FROM Thumbnail WHERE id IN (:ids)";
                for (Object[] resultRow : queryService.projection("SELECT id, details.owner.id, details.group.id FROM Thumbnail WHERE id IN (:ids)", parameters)) {
                    if (resultRow == null) continue;
                    Long thumbnailId = (Long)resultRow[0];
                    ownerId = (Long)resultRow[1];
                    groupId = (Long)resultRow[2];
                    String thumbnailPath = this.thumbnailService.getThumbnailPath(thumbnailId);
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(thumbnailPath));
                }
            } else if ("OriginalFile".equals(var9_18)) {
                hql2 = "SELECT id, details.owner.id, details.group.id, size FROM OriginalFile WHERE id IN (:ids)";
                for (Object[] resultRow : queryService.projection("SELECT id, details.owner.id, details.group.id, size FROM OriginalFile WHERE id IN (:ids)", parameters)) {
                    if (resultRow == null || !(resultRow[3] instanceof Long)) continue;
                    Iterator<Object[]> fileId = (Long)resultRow[0];
                    ownerId = (Long)resultRow[1];
                    groupId = (Long)resultRow[2];
                    Long fileSize = (Long)resultRow[3];
                    fileSizes.put(fileId, new OwnershipAndSize(ownerId, groupId, fileSize));
                }
            } else if ("Experimenter".equals(var9_18)) {
                for (String resultClassName : OWNED_OBJECTS) {
                    hql = "SELECT " + this.getIdPropertyFor(resultClassName) + " FROM " + resultClassName + " WHERE details.owner.id IN (:ids)";
                    for (Object[] resultRow : queryService.projection(hql, parameters)) {
                        objectsToProcess.put(resultClassName, (Long)resultRow[0]);
                    }
                }
            } else if ("ExperimenterGroup".equals(var9_18)) {
                for (String resultClassName : OWNED_OBJECTS) {
                    hql = "SELECT " + this.getIdPropertyFor(resultClassName) + " FROM " + resultClassName + " WHERE details.group.id IN (:ids)";
                    for (Object[] resultRow : queryService.projection(hql, parameters)) {
                        objectsToProcess.put(resultClassName, (Long)resultRow[0]);
                    }
                }
            }
            for (Map.Entry query : TRAVERSAL_QUERIES.get(var9_18)) {
                String resultClassName = (String)query.getKey();
                String hql3 = (String)query.getValue();
                for (Object[] resultRow : queryService.projection(hql3, parameters)) {
                    if (resultRow == null || !(resultRow[0] instanceof Long)) continue;
                    Long resultId = (Long)resultRow[0];
                    objectsToProcess.put(resultClassName, resultId);
                    if (!"OriginalFile".equals(resultClassName)) continue;
                    typesWithFiles.put(resultId, var9_18);
                }
            }
            if (ANNOTATABLE_OBJECTS.contains(var9_18)) {
                hql2 = "SELECT child.id FROM " + (String)var9_18 + "AnnotationLink WHERE parent.id IN (:ids)";
                for (Object[] resultRow : queryService.projection((String)hql2, parameters)) {
                    objectsToProcess.put("Annotation", (Long)resultRow[0]);
                }
            }
            if (!LOGGER.isDebugEnabled()) continue;
            Collections.sort(idsToQuery);
            LOGGER.debug("usage is " + usage + " after processing " + (String)var9_18 + " " + Joiner.on(", ").join(idsToQuery));
        }
        for (Map.Entry entry : fileSizes.entrySet()) {
            Long fileId = (Long)entry.getKey();
            OwnershipAndSize fileSize = (OwnershipAndSize)entry.getValue();
            Set types = typesWithFiles.get(fileId);
            if (types.isEmpty()) {
                types = ImmutableSet.of("OriginalFile");
            }
            usage.bumpTotals();
            for (String type : types) {
                usage.add(fileSize.owner, fileSize.group, type, fileSize.size);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("usage is " + usage + " after including " + OriginalFile.class.getSimpleName() + " sizes");
        }
        return usage.getDiskUsageResponse();
    }

    static {
        classIdProperties = Collections.synchronizedMap(new HashMap());
        ImmutableSet.Builder builder = ImmutableMultimap.builder();
        ((ImmutableMultimap.Builder)((Object)builder)).put("Project", Maps.immutableEntry("Dataset", "SELECT child.id FROM ProjectDatasetLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Dataset", Maps.immutableEntry("Image", "SELECT child.id FROM DatasetImageLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Folder", Maps.immutableEntry("Image", "SELECT child.id FROM FolderImageLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Folder", Maps.immutableEntry("Roi", "SELECT child.id FROM FolderRoiLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Folder", Maps.immutableEntry("Folder", "SELECT id FROM Folder WHERE parentFolder.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Screen", Maps.immutableEntry("Plate", "SELECT child.id FROM ScreenPlateLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Plate", Maps.immutableEntry("Well", "SELECT id FROM Well WHERE plate.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Plate", Maps.immutableEntry("PlateAcquisition", "SELECT id FROM PlateAcquisition WHERE plate.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("PlateAcquisition", Maps.immutableEntry("WellSample", "SELECT id FROM WellSample WHERE plateAcquisition.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Well", Maps.immutableEntry("WellSample", "SELECT id FROM WellSample WHERE well.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Well", Maps.immutableEntry("Reagent", "SELECT child.id FROM WellReagentLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("WellSample", Maps.immutableEntry("Image", "SELECT image.id FROM WellSample WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Image", Maps.immutableEntry("Pixels", "SELECT id FROM Pixels WHERE image.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Pixels", Maps.immutableEntry("Thumbnail", "SELECT id FROM Thumbnail WHERE pixels.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Pixels", Maps.immutableEntry("OriginalFile", "SELECT parent.id FROM PixelsOriginalFileMap WHERE child.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Pixels", Maps.immutableEntry("Channel", "SELECT id FROM Channel WHERE pixels.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Pixels", Maps.immutableEntry("PlaneInfo", "SELECT id FROM PlaneInfo WHERE pixels.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Channel", Maps.immutableEntry("LogicalChannel", "SELECT logicalChannel.id FROM Channel WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Image", Maps.immutableEntry("Fileset", "SELECT fileset.id FROM Image WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Fileset", Maps.immutableEntry("Job", "SELECT child.id FROM FilesetJobLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Job", Maps.immutableEntry("OriginalFile", "SELECT child.id FROM JobOriginalFileLink WHERE parent.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Fileset", Maps.immutableEntry("Image", "SELECT id FROM Image WHERE fileset.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Fileset", Maps.immutableEntry("FilesetEntry", "SELECT id FROM FilesetEntry WHERE fileset.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("FilesetEntry", Maps.immutableEntry("OriginalFile", "SELECT originalFile.id FROM FilesetEntry WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Annotation", Maps.immutableEntry("OriginalFile", "SELECT file.id FROM FileAnnotation WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Image", Maps.immutableEntry("Roi", "SELECT id FROM Roi WHERE image.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Roi", Maps.immutableEntry("Shape", "SELECT id FROM Shape WHERE roi.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Roi", Maps.immutableEntry("OriginalFile", "SELECT source.id FROM Roi WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Image", Maps.immutableEntry("Instrument", "SELECT instrument.id FROM Image WHERE id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Instrument", Maps.immutableEntry("Detector", "SELECT id FROM Detector WHERE instrument.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Instrument", Maps.immutableEntry("Dichroic", "SELECT id FROM Dichroic WHERE instrument.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Instrument", Maps.immutableEntry("Filter", "SELECT id FROM Filter WHERE instrument.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Instrument", Maps.immutableEntry("LightSource", "SELECT id FROM LightSource WHERE instrument.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Instrument", Maps.immutableEntry("Objective", "SELECT id FROM Objective WHERE instrument.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("Dichroic", Maps.immutableEntry("LightPath", "SELECT id FROM LightPath WHERE dichroic.id IN (:ids)"));
        ((ImmutableMultimap.Builder)((Object)builder)).put("LogicalChannel", Maps.immutableEntry("LightPath", "SELECT lightPath.id FROM LogicalChannel WHERE id IN (:ids)"));
        TRAVERSAL_QUERIES = ((ImmutableMultimap.Builder)((Object)builder)).build();
        builder = ImmutableSet.builder();
        builder.add("Annotation");
        builder.add("Channel");
        builder.add("Dataset");
        builder.add("Detector");
        builder.add("Dichroic");
        builder.add("Fileset");
        builder.add("Filter");
        builder.add("Folder");
        builder.add("Image");
        builder.add("LogicalChannel");
        builder.add("Instrument");
        builder.add("LightPath");
        builder.add("LightSource");
        builder.add("Objective");
        builder.add("OriginalFile");
        builder.add("Pixels");
        builder.add("PlaneInfo");
        builder.add("PlateAcquisition");
        builder.add("Plate");
        builder.add("Project");
        builder.add("Reagent");
        builder.add("Roi");
        builder.add("Screen");
        builder.add("Shape");
        builder.add("Well");
        builder.add("WellSample");
        OWNED_OBJECTS = builder.build();
        builder = ImmutableSet.builder();
        builder.add("Annotation");
        builder.add("Channel");
        builder.add("Dataset");
        builder.add("Detector");
        builder.add("Dichroic");
        builder.add("Experimenter");
        builder.add("ExperimenterGroup");
        builder.add("Fileset");
        builder.add("Filter");
        builder.add("Folder");
        builder.add("Image");
        builder.add("Instrument");
        builder.add("LightPath");
        builder.add("LightSource");
        builder.add("Objective");
        builder.add("OriginalFile");
        builder.add("PlaneInfo");
        builder.add("PlateAcquisition");
        builder.add("Plate");
        builder.add("Project");
        builder.add("Reagent");
        builder.add("Roi");
        builder.add("Screen");
        builder.add("Shape");
        builder.add("Well");
        ANNOTATABLE_OBJECTS = builder.build();
    }

    private static class OwnershipAndSize {
        public final long owner;
        public final long group;
        public final long size;

        OwnershipAndSize(long owner, long group, long size) {
            this.owner = owner;
            this.group = group;
            this.size = size;
        }
    }

    private static class Usage {
        private final Map<LongPair, Map<String, Integer>> countByTypeByWho = new HashMap<LongPair, Map<String, Integer>>();
        private final Map<LongPair, Map<String, Long>> sizeByTypeByWho = new HashMap<LongPair, Map<String, Long>>();
        private final Map<LongPair, Integer> totalCountByWho = new HashMap<LongPair, Integer>();
        private final Map<LongPair, Long> totalSizeByWho = new HashMap<LongPair, Long>();
        private boolean bumpTotals = false;

        private Usage() {
        }

        Usage bumpTotals() {
            this.bumpTotals = true;
            return this;
        }

        void add(long owner, long group, String type, Long size) {
            Map<Object, Object> sizeByType;
            Map<Object, Object> countByType;
            if (size <= 0L) {
                this.bumpTotals = false;
                return;
            }
            LongPair ownership = new LongPair(owner, group);
            if (this.countByTypeByWho.containsKey(ownership)) {
                countByType = this.countByTypeByWho.get(ownership);
                sizeByType = this.sizeByTypeByWho.get(ownership);
            } else {
                countByType = new HashMap();
                sizeByType = new HashMap();
                this.countByTypeByWho.put(ownership, countByType);
                this.sizeByTypeByWho.put(ownership, sizeByType);
            }
            Long sizeThisType = (Long)sizeByType.get(type);
            if (sizeThisType == null) {
                countByType.put(type, 1);
                sizeByType.put(type, size);
            } else {
                countByType.put(type, (Integer)countByType.get(type) + 1);
                sizeByType.put(type, sizeThisType + size);
            }
            if (this.bumpTotals) {
                Integer totalCount = this.totalCountByWho.get(ownership);
                Long totalSize = this.totalSizeByWho.get(ownership);
                if (totalCount == null) {
                    totalCount = 0;
                }
                if (totalSize == null) {
                    totalSize = 0L;
                }
                Integer n = totalCount;
                Integer n2 = totalCount = Integer.valueOf(totalCount + 1);
                totalSize = totalSize + size;
                this.totalCountByWho.put(ownership, totalCount);
                this.totalSizeByWho.put(ownership, totalSize);
                this.bumpTotals = false;
            }
        }

        public DiskUsageResponse getDiskUsageResponse() {
            return new DiskUsageResponse(this.countByTypeByWho, this.sizeByTypeByWho, this.totalCountByWho, this.totalSizeByWho);
        }

        private String toString(Map<LongPair, ?> byWho) {
            ArrayList<String> asStrings = new ArrayList<String>(byWho.size());
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<LongPair, ?> entry : byWho.entrySet()) {
                sb.setLength(0);
                sb.append(entry.getKey().first);
                sb.append('/');
                sb.append(entry.getKey().second);
                sb.append('=');
                sb.append(entry.getValue());
                asStrings.add(sb.toString());
            }
            return Joiner.on(", ").join(asStrings);
        }

        public String toString() {
            return "files = [" + this.toString(this.totalCountByWho) + "], bytes = [" + this.toString(this.totalSizeByWho) + "]";
        }
    }
}

