/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.fs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import ome.io.nio.PixelsService;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.util.SqlAction;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.UsedFilesRequest;
import omero.cmd.UsedFilesResponse;
import omero.cmd.UsedFilesResponsePreFs;
import org.hibernate.Query;
import org.hibernate.Session;

public class UsedFilesRequestI
extends UsedFilesRequest
implements IRequest {
    private static final long serialVersionUID = -1572148877023558009L;
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of("omero.group", "-1");
    private final PixelsService pixelsService;
    private final Map<String, File> repositoryRoots = new HashMap<String, File>();
    private Helper helper;
    private Session session;
    private Long filesetId;
    private Long pixelsId;
    private IFormatReader reader;

    public UsedFilesRequestI(PixelsService pixelsService) {
        this.pixelsService = pixelsService;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>(ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        this.session = helper.getSession();
        helper.setSteps(1);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    return this.determineResponse();
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("used files request has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "used-files-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw this.helper.cancel(new ERR(), (Throwable)e, "used-files-fail", new String[0]);
            }
            finally {
                this.reader = null;
            }
        }
    }

    protected void finalize() {
        this.finish();
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            this.helper.setResponseIfNull((Response)object);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private Response determineResponse() throws HandleI.Cancel {
        String hql = "SELECT fileset.id FROM Image WHERE id = :id";
        Query query = this.session.createQuery("SELECT fileset.id FROM Image WHERE id = :id").setParameter("id", (Object)this.imageId);
        List results = query.list();
        if (results.isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException("cannot read image " + this.imageId);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-image", new String[0]);
        }
        this.filesetId = (Long)results.get(0);
        try {
            this.findPixels();
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "used-files-fail", new String[0]);
        }
        return this.filesetId == null ? this.determineResponsePreFs() : this.determineResponseFs();
    }

    private void findPixels() throws HandleI.Cancel, FormatException, IOException {
        String hql = "FROM Image WHERE id = :id";
        Query query = this.session.createQuery("FROM Image WHERE id = :id").setParameter("id", (Object)this.imageId);
        Image image = (Image)query.uniqueResult();
        if (image.sizeOfPixels() < 1) {
            IllegalArgumentException e = new IllegalArgumentException("no pixels for image " + this.imageId);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-image", new String[0]);
        }
        Pixels pixels = image.getPrimaryPixels();
        this.pixelsId = pixels.getId();
        if (this.filesetId != null) {
            this.reader = this.pixelsService.getBfReader(pixels);
        }
    }

    private File getRepositoryRoot(String repo) {
        File root = this.repositoryRoots.get(repo);
        if (root == null) {
            String hql = "SELECT path || name FROM OriginalFile WHERE mimetype = 'Repository' AND hash = :repo";
            Query query = this.session.createQuery("SELECT path || name FROM OriginalFile WHERE mimetype = 'Repository' AND hash = :repo").setParameter("repo", (Object)repo);
            String repositoryRootDirectory = (String)query.uniqueResult();
            root = new File(repositoryRootDirectory);
            this.repositoryRoots.put(repo, root);
        }
        return root;
    }

    private File getUnderlyingFile(String repo, String file2) {
        File repoRoot = this.getRepositoryRoot(repo);
        if ('/' != File.separatorChar) {
            file2 = file2.replace('/', File.separatorChar);
        }
        return new File(repoRoot, file2);
    }

    private Map<File, Long> getFileIdsOfFileset() {
        SqlAction jdbc = this.helper.getSql();
        HashMap<File, Long> fileIds = new HashMap<File, Long>();
        String hql = "SELECT originalFile.id, originalFile.path || originalFile.name FROM FilesetEntry WHERE fileset.id = :id";
        Query query = this.session.createQuery("SELECT originalFile.id, originalFile.path || originalFile.name FROM FilesetEntry WHERE fileset.id = :id").setParameter("id", (Object)this.filesetId);
        List results = query.list();
        for (Object[] result : results) {
            Long fileId = (Long)result[0];
            String fileName = (String)result[1];
            String repo = jdbc.fileRepo(fileId);
            File realFile = this.getUnderlyingFile(repo, fileName);
            fileIds.put(realFile, fileId);
        }
        return fileIds;
    }

    private UsedFilesResponse determineResponseFs() {
        Map<File, Long> fileIds = this.getFileIdsOfFileset();
        Set<File> allFileNamesAllSeries = UsedFilesRequestI.namesToFiles(this.reader.getUsedFiles(false));
        Set<File> companionFileNamesAllSeries = UsedFilesRequestI.namesToFiles(this.reader.getUsedFiles(true));
        Sets.SetView<File> binaryFileNamesAllSeries = Sets.difference(allFileNamesAllSeries, companionFileNamesAllSeries);
        Set<File> allFileNamesThisSeries = UsedFilesRequestI.namesToFiles(this.reader.getSeriesUsedFiles(false));
        Set<File> companionFileNamesThisSeries = UsedFilesRequestI.namesToFiles(this.reader.getSeriesUsedFiles(true));
        Sets.SetView<File> binaryFileNamesThisSeries = Sets.difference(allFileNamesThisSeries, companionFileNamesThisSeries);
        Sets.SetView<File> companionFileNamesOtherSeries = Sets.difference(companionFileNamesAllSeries, companionFileNamesThisSeries);
        Sets.SetView<File> binaryFileNamesOtherSeries = Sets.difference(binaryFileNamesAllSeries, binaryFileNamesThisSeries);
        List<Long> binaryFileIdsThisSeries = UsedFilesRequestI.mapList(fileIds, binaryFileNamesThisSeries);
        List<Long> binaryFileIdsOtherSeries = UsedFilesRequestI.mapList(fileIds, binaryFileNamesOtherSeries);
        List<Long> companionFileIdsThisSeries = UsedFilesRequestI.mapList(fileIds, companionFileNamesThisSeries);
        List<Long> companionFileIdsOtherSeries = UsedFilesRequestI.mapList(fileIds, companionFileNamesOtherSeries);
        return new UsedFilesResponse(binaryFileIdsThisSeries, binaryFileIdsOtherSeries, companionFileIdsThisSeries, companionFileIdsOtherSeries);
    }

    private List<Long> getArchivedFilesPreFs() {
        String hql = "SELECT DISTINCT parent.id FROM PixelsOriginalFileMap WHERE child.id = :id";
        Query query = this.session.createQuery("SELECT DISTINCT parent.id FROM PixelsOriginalFileMap WHERE child.id = :id").setParameter("id", (Object)this.pixelsId);
        return UsedFilesRequestI.objectsToLongs(query.list());
    }

    private void getCompanionFilesPreFs(Map<Long, String> fileNames, String type, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        String hql = "SELECT DISTINCT fa.file.id, fa.file.name FROM " + type + "AnnotationLink al, FileAnnotation fa WHERE al.parent.id IN (:ids) AND al.child = fa AND fa.ns = :ns";
        Query query = this.session.createQuery(hql).setParameterList("ids", ids).setParameter("ns", (Object)"openmicroscopy.org/omero/import/companionFile");
        List results = query.list();
        for (Object[] result : results) {
            Long fileId = (Long)result[0];
            String fileName = (String)result[1];
            fileNames.put(fileId, fileName);
        }
    }

    private Set<Long> queryMapping(String hql, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> found = new HashSet<Long>();
        Query query = this.session.createQuery(hql).setParameterList("ids", ids);
        List results = query.list();
        for (Object result : results) {
            if (result == null) continue;
            found.add((Long)result);
        }
        return found;
    }

    private Map<Long, String> getCompanionFilesPreFs() {
        HashMap<Long, String> fileNames = new HashMap<Long, String>();
        Set<Long> images = Collections.singleton(this.imageId);
        Set<Long> wellSamples = this.queryMapping("SELECT DISTINCT id FROM WellSample WHERE image.id IN (:ids)", images);
        Set<Long> wells = this.queryMapping("SELECT DISTINCT well.id FROM WellSample WHERE id IN (:ids)", wellSamples);
        Set<Long> runs = this.queryMapping("SELECT DISTINCT plateAcquisition.id FROM WellSample WHERE id IN (:ids)", wellSamples);
        Set<Long> plates = this.queryMapping("SELECT DISTINCT plate.id FROM Well WHERE id IN (:ids)", wells);
        this.getCompanionFilesPreFs(fileNames, "Image", images);
        this.getCompanionFilesPreFs(fileNames, "Well", wells);
        this.getCompanionFilesPreFs(fileNames, "PlateAcquisition", runs);
        this.getCompanionFilesPreFs(fileNames, "Plate", plates);
        return fileNames;
    }

    private UsedFilesResponsePreFs determineResponsePreFs() {
        List<Long> archivedFiles = this.getArchivedFilesPreFs();
        ArrayList<Long> realCompanionFiles = new ArrayList<Long>();
        ArrayList<Long> originalMetadataFiles = new ArrayList<Long>();
        for (Map.Entry<Long, String> companionFile : this.getCompanionFilesPreFs().entrySet()) {
            Long id = companionFile.getKey();
            String name = companionFile.getValue();
            ("original_metadata.txt".equals(name) ? originalMetadataFiles : realCompanionFiles).add(id);
        }
        return new UsedFilesResponsePreFs(archivedFiles, realCompanionFiles, originalMetadataFiles);
    }

    private static List<Long> objectsToLongs(Collection<?> objects) {
        ArrayList<Long> longs = new ArrayList<Long>(objects.size());
        for (Object object : objects) {
            longs.add((Long)object);
        }
        return longs;
    }

    private static Set<File> namesToFiles(String ... names) {
        HashSet<File> files = new HashSet<File>();
        if (names != null) {
            for (String name : names) {
                files.add(new File(name));
            }
        }
        return files;
    }

    private static <X, Y> List<Y> mapList(Map<X, Y> mapping, Collection<X> input) {
        ArrayList<Y> output = new ArrayList<Y>(input.size());
        for (X item : input) {
            output.add(mapping.get(item));
        }
        return output;
    }
}

