/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.fs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import ome.api.IQuery;
import ome.io.nio.PixelsService;
import ome.model.annotations.FileAnnotation;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.parameters.Parameters;
import omero.RLong;
import omero.RType;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.OriginalMetadataRequest;
import omero.cmd.OriginalMetadataResponse;
import omero.cmd.Response;
import omero.rtypes;
import omero.util.IceMapper;

public class OriginalMetadataRequestI
extends OriginalMetadataRequest
implements IRequest {
    private static final long serialVersionUID = -1L;
    private final OriginalMetadataResponse rsp = new OriginalMetadataResponse();
    private final PixelsService pixelsService;
    private Helper helper;

    public OriginalMetadataRequestI(PixelsService pixelsService) {
        this.pixelsService = pixelsService;
    }

    @Override
    public Map<String, String> getCallContext() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.put("omero.group", "-1");
        return all;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        this.helper.setSteps(1);
    }

    @Override
    public Object step(int step) {
        this.helper.assertStep(step);
        this.loadFileset();
        if (this.rsp.filesetId == null) {
            this.loadFileAnnotation();
        }
        return null;
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.helper.isLast(step)) {
            this.helper.setResponseIfNull(this.rsp);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    protected void loadFileset() {
        this.rsp.filesetId = this.firstIdOrNull("select i.fileset.id from Image i where i.id = :id");
        if (this.rsp.filesetId != null) {
            Image image = this.helper.getServiceFactory().getQueryService().get(Image.class, this.imageId);
            Pixels pixels = image.getPrimaryPixels();
            try {
                IFormatReader reader = this.pixelsService.getBfReader(pixels);
                Hashtable<String, Object> global = reader.getGlobalMetadata();
                Hashtable<String, Object> series = reader.getSeriesMetadata();
                this.rsp.globalMetadata = this.wrap(global);
                this.rsp.seriesMetadata = this.wrap(series);
            }
            catch (Throwable t) {
                this.helper.cancel(new ERR(), t, "bf-reader-failure", "pixels", "" + pixels.getId());
            }
        }
    }

    protected void loadFileAnnotation() {
        this.rsp.fileAnnotationId = this.firstIdOrNull("select a.id from Image i join i.annotationLinks l join l.child a where i.id = :id and a.file.name = 'original_metadata.txt' and a.ns = 'openmicroscopy.org/omero/import/companionFile'");
        if (this.rsp.fileAnnotationId != null) {
            IQuery iQuery = this.helper.getServiceFactory().getQueryService();
            FileAnnotation fileAnnotation = iQuery.get(FileAnnotation.class, this.rsp.fileAnnotationId.getValue());
            String filePath = this.pixelsService.getFilesPath(fileAnnotation.getFile().getId());
            this.parseOriginalMetadataTxt(new File(filePath));
        }
    }

    protected RLong firstIdOrNull(String query) {
        Object[] id;
        List<Object[]> ids = this.helper.getServiceFactory().getQueryService().projection(query, new Parameters().addId(this.imageId).page(0, 1));
        if (ids != null && ids.size() > 0 && (id = ids.get(0)) != null && id.length > 0) {
            return rtypes.rlong((Long)id[0]);
        }
        return null;
    }

    protected Map<String, RType> wrap(Hashtable<String, Object> table) {
        HashMap<String, RType> rv = new HashMap<String, RType>();
        if (table == null || table.size() == 0) {
            return rv;
        }
        IceMapper mapper = new IceMapper();
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            try {
                if (val instanceof Short) {
                    rv.put(key, mapper.toRType(((Short)val).intValue()));
                    continue;
                }
                rv.put(key, mapper.toRType(val));
            }
            catch (Exception e) {
                String msg = String.format("Could not convert to rtype: key=%s, value=%s, type=%s ", key, val, val == null ? "null" : val.getClass());
                if (this.helper == null) {
                    System.err.println(msg);
                    continue;
                }
                this.helper.warn(msg, new Object[0]);
            }
        }
        return rv;
    }

    private static Map.Entry<String, String> splitOnEquals(String keyValue) {
        Integer equalsIndex = null;
        Integer equalsSmallestDepth = null;
        int currentDepth = 0;
        block5: for (int currentIndex = 0; currentIndex < keyValue.length(); ++currentIndex) {
            switch (keyValue.charAt(currentIndex)) {
                case '(': 
                case '[': 
                case '{': {
                    ++currentDepth;
                    continue block5;
                }
                case ')': 
                case ']': 
                case '}': {
                    --currentDepth;
                    continue block5;
                }
                case '=': {
                    if (equalsSmallestDepth != null && currentDepth > equalsSmallestDepth) continue block5;
                    equalsIndex = currentIndex;
                    equalsSmallestDepth = currentDepth;
                }
            }
        }
        if (equalsIndex == null) {
            return null;
        }
        return Maps.immutableEntry(keyValue.substring(0, equalsIndex).trim(), keyValue.substring(equalsIndex + 1).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseOriginalMetadataTxt(File file2) {
        Pattern section = Pattern.compile("\\s*\\[\\s*(.+?)\\s*\\]\\s*");
        this.rsp.globalMetadata = new TreeMap<String, RType>();
        this.rsp.seriesMetadata = new TreeMap<String, RType>();
        ImmutableMap<String, Map<String, RType>> sections = ImmutableMap.of("GlobalMetadata", this.rsp.globalMetadata, "SeriesMetadata", this.rsp.seriesMetadata);
        Map<String, RType> currentSection = null;
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
            while ((line = in.readLine()) != null) {
                Map.Entry<String, String> keyValue;
                Matcher matcher = section.matcher(line);
                if (matcher.matches()) {
                    currentSection = sections.get(matcher.group(1));
                    continue;
                }
                if (currentSection == null || (keyValue = OriginalMetadataRequestI.splitOnEquals(line)) == null) continue;
                currentSection.put(keyValue.getKey(), rtypes.rstring(keyValue.getValue()));
            }
        }
        catch (IOException e) {
            if (this.helper != null) {
                this.helper.cancel(new ERR(), (Throwable)e, "reader-failure", "original-metadata", file2.getPath());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        OriginalMetadataRequestI omr = new OriginalMetadataRequestI(null);
        ImageReader reader = new ImageReader();
        for (String file2 : args) {
            reader.setId(file2);
            Hashtable<String, Object> bfglobal = reader.getGlobalMetadata();
            Hashtable<String, Object> bfseries = reader.getSeriesMetadata();
            Map<String, RType> global = omr.wrap(bfglobal);
            Map<String, RType> series = omr.wrap(bfseries);
            OriginalMetadataRequestI.printMap("[GlobalMetadata]", global);
            OriginalMetadataRequestI.printMap("[SeriesMetadata]", series);
        }
        reader.close();
    }

    private static void printMap(String title, Map<String, RType> map) {
        System.out.println(title);
        for (Map.Entry<String, RType> entry : map.entrySet()) {
            System.out.print(entry.getKey());
            System.out.print("=");
            System.out.print(entry.getValue());
            System.out.print("\n");
        }
    }
}

