/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.api.IQuery;
import ome.conditions.RootException;
import ome.io.nio.PixelsService;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.display.Thumbnail;
import ome.model.fs.Fileset;
import ome.parameters.Parameters;
import ome.security.ACLVoter;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.ManageImageBinaries;
import omero.cmd.ManageImageBinariesResponse;
import omero.cmd.Response;
import omero.rtypes;

public class ManageImageBinariesI
extends ManageImageBinaries
implements IRequest {
    private static final long serialVersionUID = -1L;
    private final ManageImageBinariesResponse rsp = new ManageImageBinariesResponse();
    private final PixelsService pixelsService;
    private final ACLVoter voter;
    private Helper helper;
    private PixelFiles files;
    private List<File> thumbnailFiles = new ArrayList<File>();

    public ManageImageBinariesI(PixelsService pixelsService, ACLVoter voter) {
        this.pixelsService = pixelsService;
        this.voter = voter;
    }

    @Override
    public Map<String, String> getCallContext() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.put("omero.group", "-1");
        return all;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        this.helper.setSteps(6);
    }

    @Override
    public Object step(int step) {
        this.helper.assertStep(step);
        switch (step) {
            case 0: {
                this.findImage();
                break;
            }
            case 1: {
                this.findAttached();
                break;
            }
            case 2: {
                this.findBinary();
                break;
            }
            case 3: {
                this.findFileset();
                break;
            }
            case 4: {
                this.togglePixels();
                break;
            }
            case 5: {
                this.deletePyramid();
                break;
            }
            default: {
                throw this.helper.cancel(new ERR(), null, "unknown-step", "step", "" + step);
            }
        }
        return null;
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.helper.isLast(step)) {
            this.helper.setResponseIfNull(this.rsp);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private void findImage() {
        try {
            IQuery query = this.helper.getServiceFactory().getQueryService();
            query.get(Image.class, this.imageId);
        }
        catch (RootException re) {
            throw this.helper.cancel(new ERR(), (Throwable)re, "no-image", "image-id", "" + this.imageId);
        }
    }

    private void findAttached() {
        IQuery query = this.helper.getServiceFactory().getQueryService();
        List rv = query.findAllByQuery("select o from Image i join i.pixels p join p.pixelsFileMaps m join m.parent o where i.id = :id", new Parameters().addId(this.imageId));
        this.rsp.archivedFiles = new ArrayList<Long>();
        for (IObject obj : rv) {
            long id = obj.getId();
            this.rsp.archivedFiles.add(id);
            File f = new File(this.pixelsService.getFilesPath(id));
            if (!f.exists()) continue;
            this.rsp.archivedSize += f.length();
        }
    }

    private void findBinary() {
        IQuery query = this.helper.getServiceFactory().getQueryService();
        Pixels pixels = query.get(Image.class, this.imageId).getPrimaryPixels();
        List thumbs = query.findAllByQuery("select tb from Thumbnail tb where tb.pixels.id = :id", new Parameters().addId(pixels.getId()));
        String path = this.pixelsService.getPixelsPath(pixels.getId());
        this.files = new PixelFiles(path);
        this.files.update(this.rsp);
        for (Thumbnail tb : thumbs) {
            path = this.pixelsService.getThumbnailPath(tb.getId());
            File thumbnailFile = new File(path);
            this.thumbnailFiles.add(thumbnailFile);
            this.rsp.thumbnailSize += thumbnailFile.length();
        }
    }

    private void findFileset() {
        try {
            IQuery query = this.helper.getServiceFactory().getQueryService();
            Fileset fs = (Fileset)query.findByQuery("select fs from Image i join i.fileset fs where i.id = :id", new Parameters().addId(this.imageId));
            if (fs != null) {
                this.rsp.filesetId = rtypes.rlong(fs.getId());
            }
        }
        catch (RootException re) {
            throw this.helper.cancel(new ERR(), (Throwable)re, "fileset-load-err", "image-id", "" + this.imageId);
        }
    }

    private void togglePixels() {
        if (this.togglePixels) {
            this.requireFileset("pixels");
            this.processFile("pixels-move", this.files.pixels, this.files.backup);
            this.files.update(this.rsp);
        }
    }

    private void deletePyramid() {
        if (this.deletePyramid) {
            this.requireFileset("pyramid");
            this.processFile("pyramid", this.files.pyramid, null);
            this.files.update(this.rsp);
        }
    }

    private void requireFileset(String which) {
        if (this.rsp.filesetId == null) {
            throw this.helper.cancel(new ERR(), null, which + "-requires-fileset", new String[0]);
        }
    }

    private void processFile(String which, File file2, File dest) {
        if (!file2.exists()) {
            return;
        }
        IQuery query = this.helper.getServiceFactory().getQueryService();
        Image image = query.get(Image.class, this.imageId);
        if (!this.voter.allowDelete(image, image.getDetails())) {
            throw this.helper.cancel(new ERR(), null, which + "-delete-disallowed", new String[0]);
        }
        if (dest != null ? !file2.renameTo(dest) : !file2.delete()) {
            throw this.helper.cancel(new ERR(), null, which + "-delete-false", new String[0]);
        }
    }

    static class PixelFiles {
        final File pixels;
        final File backup;
        final File pyramid;

        PixelFiles(String path) {
            this.pixels = new File(path);
            this.backup = new File(path + "_bak");
            this.pyramid = new File(path + "_pyramid");
        }

        public void update(ManageImageBinariesResponse rsp) {
            if (this.pixels.exists()) {
                rsp.pixelsPresent = true;
                rsp.pixelSize = this.pixels.length();
            } else {
                rsp.pixelsPresent = false;
                if (this.backup.exists()) {
                    rsp.pixelSize = this.backup.length();
                }
            }
            rsp.pyramidPresent = false;
            if (this.pyramid.exists()) {
                rsp.pyramidPresent = true;
                rsp.pyramidSize = this.pyramid.length();
            }
        }
    }
}

