/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.admin;

import Ice.Communicator;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.security.basic.CurrentDetails;
import ome.services.sessions.SessionManager;
import ome.system.EventContext;
import ome.system.SimpleEventContext;
import omero.ClientError;
import omero.RType;
import omero.cmd.CurrentSessionsRequest;
import omero.cmd.CurrentSessionsResponse;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.rtypes;
import omero.util.IceMapper;
import omero.util.ObjectFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentSessionsRequestI
extends CurrentSessionsRequest
implements IRequest {
    private final Logger log = LoggerFactory.getLogger(CurrentSessionsRequestI.class);
    protected Helper helper;
    protected final CurrentDetails current;
    protected final SessionManager manager;
    protected Map<String, Map<String, Object>> contexts;

    public CurrentSessionsRequestI(CurrentDetails current, SessionManager manager) {
        this.current = current;
        this.manager = manager;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        this.helper.setSteps(1);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        this.contexts = this.manager.getSessionData();
        if (this.contexts.isEmpty()) {
            return Collections.emptyList();
        }
        return this.helper.getServiceFactory().getQueryService().findAllByQuery("select s from Session s where s.uuid in (:uuid)", new Parameters().addList("uuid", new ArrayList<String>(this.contexts.keySet())));
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        List rv = (List)object;
        HashMap<String, omero.model.Session> objects = new HashMap<String, omero.model.Session>();
        IceMapper mapper = new IceMapper();
        for (Session obj : rv) {
            objects.put(obj.getUuid(), (omero.model.Session)((Object)mapper.map(obj)));
        }
        if (this.helper.isLast(step)) {
            int size = this.contexts.size();
            CurrentSessionsResponse rsp = new CurrentSessionsResponse();
            rsp.sessions = new ArrayList<omero.model.Session>(size);
            rsp.contexts = new ArrayList<omero.sys.EventContext>(size);
            rsp.data = new Map[size];
            int count = 0;
            for (Map.Entry<String, Map<String, Object>> entry : this.contexts.entrySet()) {
                String uuid = entry.getKey();
                Map<String, Object> data = entry.getValue();
                SimpleEventContext orig = new SimpleEventContext((EventContext)data.get("sessionContext"));
                omero.model.Session s = (omero.model.Session)objects.get(uuid);
                rsp.sessions.add(s);
                if (s == null) {
                    omero.sys.EventContext ec = new omero.sys.EventContext();
                    rsp.contexts.add(ec);
                    ec.userId = orig.getCurrentUserId();
                    ec.userName = orig.getCurrentUserName();
                    ec.groupId = orig.getCurrentGroupId();
                    ec.groupName = orig.getCurrentGroupName();
                    ec.isAdmin = orig.isCurrentUserAdmin();
                    rsp.data[count++] = new HashMap<String, RType>();
                    continue;
                }
                rsp.contexts.add(IceMapper.convert(orig));
                rsp.data[count++] = this.parseData(rsp, data);
            }
            this.helper.setResponseIfNull(rsp);
        }
    }

    private Map<String, RType> parseData(CurrentSessionsResponse rsp, Map<String, Object> data) {
        HashMap<String, RType> parsed = new HashMap<String, RType>();
        for (Map.Entry<String, Object> entry2 : data.entrySet()) {
            String key2 = entry2.getKey();
            Object obj2 = entry2.getValue();
            if ("class".equals(key2) || "sessionContext".equals(key2)) continue;
            RType wrapped = null;
            try {
                wrapped = key2.endsWith("Time") ? rtypes.rtime((Long)obj2) : rtypes.wrap(obj2);
            }
            catch (ClientError ce) {
                this.log.warn("Failed to convert {}", obj2, (Object)ce);
                wrapped = rtypes.rstring(obj2.toString());
            }
            parsed.put(key2, wrapped);
        }
        return parsed;
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    public static class Factory
    extends ObjectFactoryRegistry {
        private final ObjectFactoryRegistry.ObjectFactory factory;

        public Factory(final CurrentDetails current, final SessionManager sessionManager) {
            this.factory = new ObjectFactoryRegistry.ObjectFactory(CurrentSessionsRequest.ice_staticId()){

                @Override
                public Ice.Object create(String name) {
                    return new CurrentSessionsRequestI(current, sessionManager);
                }
            };
        }

        @Override
        public Map<String, ObjectFactoryRegistry.ObjectFactory> createFactories(Communicator ic) {
            return new ImmutableMap.Builder<String, ObjectFactoryRegistry.ObjectFactory>().put(CurrentSessionsRequest.ice_staticId(), this.factory).build();
        }
    }
}

