/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd;

import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import omero.ClientError;
import omero.LockTimeout;
import omero.ServerError;
import omero.client;
import omero.cmd.CmdCallbackPrx;
import omero.cmd.CmdCallbackPrxHelper;
import omero.cmd.HandlePrx;
import omero.cmd.Response;
import omero.cmd.Status;
import omero.cmd._CmdCallbackDisp;

public class CmdCallbackI
extends _CmdCallbackDisp {
    private static final long serialVersionUID = 1L;
    private final ObjectAdapter adapter;
    private final Identity id;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final CountDownLatch isInitialized = new CountDownLatch(1);
    private final CountDownLatch isOnFinishedDone = new CountDownLatch(1);
    private final AtomicReference<State> state = new AtomicReference<State>(new State(null, null));
    protected final HandlePrx handle;

    public CmdCallbackI(client client2, HandlePrx handle) throws ServerError {
        this(client2.getAdapter(), client2.getCategory(), handle);
    }

    public CmdCallbackI(CmdCallbackI ccb) throws ServerError {
        this(ccb.adapter, ccb.id.category, ccb.handle);
    }

    public CmdCallbackI(ObjectAdapter adapter, String category, HandlePrx handle) throws ServerError {
        this.adapter = adapter;
        this.handle = handle;
        this.id = new Identity();
        this.id.name = UUID.randomUUID().toString();
        this.id.category = category;
        ObjectPrx prx = adapter.add(this, this.id);
        CmdCallbackPrx cb = CmdCallbackPrxHelper.uncheckedCast(prx);
        handle.addCallback(cb);
        this.initialPoll();
    }

    protected void initialPoll() {
        new Thread(){

            @Override
            public void run() {
                try {
                    CmdCallbackI.this.poll();
                }
                catch (Exception e) {
                    CmdCallbackI.this.onFinished(null, null, null);
                }
            }
        }.start();
    }

    protected void initializationDone() {
        this.isInitialized.countDown();
    }

    protected void waitOnInitialization() {
        try {
            this.isInitialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void onFinishedDone() {
        this.isOnFinishedDone.countDown();
    }

    protected void waitOnFinishedDone() {
        try {
            this.isOnFinishedDone.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Response getResponse() {
        return this.state.get().rsp;
    }

    public Status getStatus() {
        return this.state.get().status;
    }

    protected Status getStatusOrThrow() {
        Status s = this.getStatus();
        if (s == null) {
            throw new ClientError("Status not present!");
        }
        return s;
    }

    public boolean isCancelled() {
        Status s = this.getStatusOrThrow();
        return s.flags.contains(omero.cmd.State.CANCELLED);
    }

    public boolean isFailure() {
        Status s = this.getStatusOrThrow();
        return s.flags.contains(omero.cmd.State.FAILURE);
    }

    public Response loop(int loops, long ms) throws InterruptedException, LockTimeout {
        boolean found = false;
        for (int count = 0; count < loops; ++count) {
            found = this.block(ms);
            if (!found) continue;
        }
        if (found) {
            return this.getResponse();
        }
        double waited = (double)ms / 1000.0 * (double)loops;
        throw new LockTimeout(null, null, String.format("Command unfinished after %s seconds", waited), 10000L, (int)waited);
    }

    public boolean block(long ms) throws InterruptedException {
        return this.latch.await(ms, TimeUnit.MILLISECONDS);
    }

    public void poll() {
        Response rsp = this.handle.getResponse();
        if (rsp != null) {
            Status s = this.handle.getStatus();
            this.finished(rsp, s, null);
        }
    }

    @Override
    public void step(int complete, int total, Current __current) {
    }

    @Override
    public final void finished(Response rsp, Status status, Current __current) {
        this.state.set(new State(rsp, status));
        this.latch.countDown();
        this.onFinished(rsp, status, __current);
    }

    public void onFinished(Response rsp, Status status, Current __current) {
    }

    public void close(boolean closeHandle) {
        this.adapter.remove(this.id);
        if (closeHandle) {
            this.handle.close();
        }
    }

    private static class State {
        final Response rsp;
        final Status status;

        State(Response rsp, Status status) {
            this.rsp = rsp;
            this.status = status;
        }
    }
}

