/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd;

import Ice.Current;
import java.util.Map;
import ome.security.basic.CurrentDetails;
import ome.system.OmeroContext;
import omero.SecurityViolation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CallContext
implements MethodInterceptor {
    private static Logger log = LoggerFactory.getLogger(CallContext.class);
    private final CurrentDetails cd;
    private final String token;

    public CallContext(OmeroContext ctx, String token) {
        this.cd = (CurrentDetails)ctx.getBean(CurrentDetails.class);
        this.token = token;
    }

    public CallContext(CurrentDetails cd, String token) {
        this.cd = cd;
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation arg0) throws Throwable {
        Object last;
        Object[] args;
        if (arg0 != null && (args = arg0.getArguments()) != null && args.length > 0 && Current.class.isAssignableFrom((last = args[args.length - 1]).getClass())) {
            Current current = (Current)last;
            Map<String, String> ctx = current.ctx;
            if (ctx != null && ctx.size() > 0) {
                this.cd.setContext(ctx);
                if (ctx.containsKey("omero.logfilename")) {
                    if (ctx.containsKey("omero.logfilename.token") && this.token.equals(ctx.get("omero.logfilename.token"))) {
                        MDC.put("fileset", ctx.get("omero.logfilename"));
                    } else {
                        throw new SecurityViolation(null, null, "Setting the omero.logfilename value is not permitted without a secure server token!");
                    }
                }
            }
        }
        try {
            Object object = arg0.proceed();
            return object;
        }
        finally {
            MDC.clear();
        }
    }
}

