/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.quantum;

import ome.model.core.Pixels;
import ome.model.display.QuantumDef;
import omeis.providers.re.quantum.PolynomialMap;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumStrategy;

public class Quantization_8_16_bit
extends QuantumStrategy {
    private byte[] LUT;
    private int min;
    private int max;
    private int lutMin;
    private int lutMax;
    private double ysNormalized;
    private double yeNormalized;
    private double aNormalized;
    private double Q1;
    private double Q9;
    private double aDecile;
    private double bDecile;
    private int cdStart;
    private int cdEnd;

    private void initLUT(int s, int e) {
        int range;
        this.min = (int)this.getGlobalMin();
        this.max = (int)this.getGlobalMax();
        this.lutMin = (int)this.getPixelsTypeMin();
        this.lutMax = (int)this.getPixelsTypeMax();
        if (this.lutMax == 0) {
            this.lutMin = s < this.min ? s : this.min;
            this.lutMax = e > this.max ? e : this.max;
        }
        if ((double)(range = this.lutMax - this.lutMin) > 65536.0) {
            throw new IllegalArgumentException(String.format("Lookup table of size %d greater than supported size %f", range, 65536.0));
        }
        this.LUT = new byte[this.lutMax - this.lutMin + 1];
    }

    private void resetLUT(int s, int e) {
        int pMax = (int)this.getPixelsTypeMax();
        if (pMax != 0) {
            return;
        }
        if (s < this.lutMin && e > this.lutMax) {
            this.lutMin = s;
            this.lutMax = e;
            this.LUT = new byte[this.lutMax - this.lutMin + 1];
        } else if (s < this.lutMin && e <= this.lutMax) {
            this.lutMin = s;
            this.LUT = new byte[this.lutMax - this.lutMin + 1];
        } else if (s >= this.lutMin && e > this.lutMax) {
            this.lutMax = e;
            this.LUT = new byte[this.lutMax - this.lutMin + 1];
        }
    }

    private void initNormalizedMap(double k) {
        this.ysNormalized = this.valueMapper.transform(0, k);
        this.yeNormalized = this.valueMapper.transform(255, k);
        this.aNormalized = (double)this.qDef.getBitResolution().intValue() / (this.yeNormalized - this.ysNormalized);
    }

    private double initDecileMap(double dStart, double dEnd) {
        this.cdStart = this.qDef.getCdStart();
        this.cdEnd = this.qDef.getCdEnd();
        double denum = dEnd - dStart;
        double num = 255.0;
        double v = 0.0;
        double b = dStart;
        int e = 0;
        double startMin = this.min;
        double startMax = this.max;
        this.Q1 = this.min;
        this.Q9 = this.max;
        if (dStart <= startMin) {
            this.Q1 = dStart;
        }
        if (dEnd >= startMax) {
            this.Q9 = dEnd;
        }
        if (startMin == startMax) {
            v = 1.0;
        }
        double decile = (startMax - startMin) / 10.0;
        if (this.getNoiseReduction()) {
            this.Q1 += decile;
            this.Q9 -= decile;
            denum = this.Q9 - this.Q1;
            v = 10.0;
            e = 10;
            num = 235.0;
            b = this.Q1;
            if (dStart >= this.Q1 && dEnd > this.Q9) {
                denum = this.Q9 - dStart;
                b = dStart;
            } else if (dStart >= this.Q1 && dEnd <= this.Q9) {
                denum = dEnd - dStart;
                b = dStart;
            } else if (dStart < this.Q1 && dEnd <= this.Q9) {
                denum = dEnd - this.Q1;
            }
            if (this.cdStart < 10) {
                this.cdStart = 10;
            }
            if (this.cdEnd > 245) {
                this.cdEnd = 245;
            }
        }
        this.aDecile = num / denum;
        this.bDecile = this.aDecile * b - (double)e;
        return v;
    }

    private void buildLUT() {
        double dStart = this.getWindowStart();
        double dEnd = this.getWindowEnd();
        if (this.LUT == null) {
            this.initLUT((int)dStart, (int)dEnd);
        } else {
            this.resetLUT((int)dStart, (int)dEnd);
        }
        double k = this.getCurveCoefficient();
        double a1 = (double)(this.qDef.getCdEnd() - this.qDef.getCdStart()) / this.qDef.getBitResolution().doubleValue();
        this.initNormalizedMap(k);
        double v = this.initDecileMap(dStart, dEnd);
        PolynomialMap normalize = new PolynomialMap();
        int x = this.lutMin;
        while ((double)x < dStart) {
            this.LUT[x - this.lutMin] = (byte)this.cdStart;
            ++x;
        }
        while ((double)x < dEnd) {
            v = (double)x > this.Q1 ? ((double)x <= this.Q9 ? this.aDecile * normalize.transform(x, 1.0) - this.bDecile : (double)this.cdEnd) : (double)this.cdStart;
            v = this.aNormalized * (this.valueMapper.transform(v, k) - this.ysNormalized);
            v = Math.round(v);
            v = Math.round(a1 * v + (double)this.cdStart);
            this.LUT[x - this.lutMin] = (byte)v;
            ++x;
        }
        while (x <= this.lutMax) {
            this.LUT[x - this.lutMin] = (byte)this.cdEnd;
            ++x;
        }
    }

    @Override
    protected void onWindowChange() {
        this.buildLUT();
    }

    public Quantization_8_16_bit(QuantumDef qd, Pixels pixels) {
        super(qd, pixels);
    }

    @Override
    public int quantize(double value) throws QuantizationException {
        double f;
        double r;
        int x = (int)value;
        if (x < this.lutMin) {
            r = this.getOriginalGlobalMax() - this.getOriginalGlobalMin();
            if (r != 0.0) {
                f = (double)(this.lutMax - this.lutMin) / r;
                if ((x = (int)(f * (double)(x - this.lutMin))) < this.lutMin) {
                    x = this.lutMin;
                }
            } else {
                x = this.lutMin;
            }
        }
        if (x > this.lutMax) {
            r = this.getOriginalGlobalMax() - this.getOriginalGlobalMin();
            if (r != 0.0) {
                f = (double)(this.lutMax - this.lutMin) / r;
                if ((x = (int)(f * (double)(x - this.lutMin))) > this.lutMax) {
                    x = this.lutMax;
                }
            } else {
                x = this.lutMax;
            }
        }
        byte i = this.LUT[x - this.lutMin];
        return i & 0xFF;
    }
}

