/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.metadata;

import loci.formats.FormatTools;
import ome.io.nio.PixelBuffer;
import ome.model.core.Channel;
import ome.model.core.Pixels;
import ome.model.enums.PixelsType;
import ome.model.stats.StatsInfo;
import omeis.providers.re.data.Plane2D;
import omeis.providers.re.data.PlaneDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsFactory {
    private static Logger log = LoggerFactory.getLogger(StatsFactory.class);
    private static final int RANGE_RGB = 255;
    private static final int NB_BIN = 20;
    private static final int BIN = 2;
    private static final int EPSILON = 4;
    private static final double THRESHOLD = 0.99;
    private static final double NR_THRESHOLD = 0.95;
    private double[] locationStats;
    private boolean noiseReduction;
    private double inputStart;
    private double inputEnd;
    private double sizeBin;
    private double epsilon;

    private void computeBins(Plane2D p2D, double gMin, int sizeX2, int sizeX1) {
        BasicSegment segment;
        int i;
        int[] totals = new int[20];
        BasicSegment[] segments = new BasicSegment[20];
        for (int i2 = 0; i2 < 20; ++i2) {
            segments[i2] = new BasicSegment(gMin + (double)i2 * this.sizeBin, gMin + (double)(i2 + 1) * this.sizeBin);
        }
        if (p2D.isXYPlanar()) {
            int size = sizeX1 * sizeX2;
            block1: for (int j = 0; j < size; ++j) {
                double v = p2D.getPixelValue(j);
                for (i = 0; i < segments.length; ++i) {
                    segment = segments[i];
                    if (!(v >= segment.x1) || !(v < segment.x2)) continue;
                    int n = i;
                    totals[n] = totals[n] + 1;
                    continue block1;
                }
            }
        } else {
            for (int x2 = 0; x2 < sizeX2; ++x2) {
                block4: for (int x1 = 0; x1 < sizeX1; ++x1) {
                    double v = p2D.getPixelValue(x1, x2);
                    for (i = 0; i < segments.length; ++i) {
                        segment = segments[i];
                        if (!(v >= segment.x1) || !(v < segment.x2)) continue;
                        int n = i;
                        totals[n] = totals[n] + 1;
                        continue block4;
                    }
                }
            }
        }
        double total = sizeX2 * sizeX1;
        for (i = 0; i < totals.length; ++i) {
            int n = i;
            this.locationStats[n] = this.locationStats[n] + (double)totals[i] / total;
        }
        double s = segments[0].x2;
        double end = segments[19].x2;
        total = total - (double)totals[0] - (double)totals[19];
        if (totals[0] >= totals[19]) {
            end = this.accumulateCloseToMin(totals, segments, total, this.epsilon);
        } else {
            s = this.accumulateCloseToMax(totals, segments, total, this.epsilon);
        }
        if (s < this.inputStart) {
            this.inputStart = s;
        }
        if (end > this.inputEnd) {
            this.inputEnd = end;
        }
        this.noiseReduction = this.noiseReduction();
    }

    private boolean noiseReduction() {
        double sumMin = 0.0;
        double sumMax = 0.0;
        for (int i = 0; i < this.locationStats.length; ++i) {
            if (i < 2) {
                sumMin += this.locationStats[i];
            }
            if (i < this.locationStats.length - 2) continue;
            sumMax += this.locationStats[i];
        }
        return !(sumMin >= 0.95) && !(sumMax >= 0.95);
    }

    private double accumulateCloseToMin(int[] totals, BasicSegment[] segments, double total, double epsilon) {
        double e = segments[19].x2;
        double sum = 0.0;
        for (int i = 1; i < totals.length - 1; ++i) {
            if (!((sum += (double)totals[i]) / total > 0.99)) continue;
            e = segments[i].x1 + epsilon;
            break;
        }
        return e;
    }

    private double accumulateCloseToMax(int[] totals, BasicSegment[] segments, double total, double epsilon) {
        double s = segments[0].x2;
        double sum = 0.0;
        for (int i = totals.length - 2; i > 0; --i) {
            if (!((sum += (double)totals[i]) / total > 0.99)) continue;
            s = segments[i].x2 - epsilon;
            break;
        }
        return s;
    }

    public double[] initPixelsRange(Pixels metadata) {
        PixelsType type = metadata.getPixelsType();
        double[] minmax = new double[]{0.0, 1.0};
        if (type == null) {
            return minmax;
        }
        String typeAsString = type.getValue();
        int bfPixelsType = FormatTools.pixelTypeFromString(typeAsString);
        if (FormatTools.isFloatingPoint(bfPixelsType)) {
            long[] values = FormatTools.defaultMinMax(bfPixelsType);
            minmax[0] = values[0];
            minmax[1] = values[1];
            return minmax;
        }
        Integer significantBits = metadata.getSignificantBits();
        if (significantBits == null) {
            significantBits = type.getBitSize();
        }
        significantBits = Math.min(significantBits, type.getBitSize());
        if (FormatTools.isSigned(bfPixelsType)) {
            minmax[0] = -Math.pow(2.0, significantBits - 1);
            minmax[1] = Math.pow(2.0, significantBits - 1) - 1.0;
        } else {
            minmax[0] = 0.0;
            minmax[1] = Math.pow(2.0, significantBits.intValue()) - 1.0;
        }
        return minmax;
    }

    public void computeLocationStats(Pixels metadata, PixelBuffer pixelsData, PlaneDef pd, int index) {
        log.debug("Computing location stats for Pixels:" + metadata.getId());
        Channel channel = metadata.getChannel(index);
        StatsInfo stats = channel.getStatsInfo();
        this.inputStart = 0.0;
        this.inputEnd = 1.0;
        if (stats == null) {
            double[] values = this.initPixelsRange(metadata);
            this.inputStart = values[0];
            this.inputEnd = values[1];
        } else {
            this.inputStart = stats.getGlobalMin();
            this.inputEnd = stats.getGlobalMax();
        }
    }

    public double[] getLocationStats() {
        return this.locationStats;
    }

    public boolean isNoiseReduction() {
        return this.noiseReduction;
    }

    public double getInputStart() {
        return this.inputStart;
    }

    public double getInputEnd() {
        return this.inputEnd;
    }

    class BasicSegment {
        double x1;
        double x2;

        BasicSegment(double x1, double x2) {
            if (x2 < x1) {
                throw new IllegalArgumentException("Segment not valid.");
            }
            this.x2 = x2;
            this.x1 = x1;
        }
    }
}

