/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.lut;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import omeis.providers.re.lut.LutReader;

class BinaryLutReader
extends LutReader {
    private void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / new Double(256.0);
        int v = 255;
        for (int i = 0; i < 256; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & v) + fraction * (double)(r[i2] & v));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & v) + fraction * (double)(g[i2] & v));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & v) + fraction * (double)(b[i2] & v));
        }
    }

    BinaryLutReader(File file2) {
        super(file2);
    }

    BinaryLutReader(File file2, boolean raw) {
        super(file2);
        this.raw = raw;
    }

    @Override
    int read() throws Exception {
        FileInputStream is = new FileInputStream(this.file.getAbsolutePath());
        DataInputStream f = new DataInputStream(is);
        int nColors = 256;
        if (!this.raw) {
            int id = f.readInt();
            if (id != 1229147980) {
                f.close();
                return 0;
            }
            f.readShort();
            nColors = f.readShort();
            f.readShort();
            f.readShort();
            f.readLong();
            f.readLong();
            f.readInt();
        }
        f.read(this.reds, 0, nColors);
        f.read(this.greens, 0, nColors);
        f.read(this.blues, 0, nColors);
        if (nColors < 256) {
            this.interpolate(this.reds, this.greens, this.blues, nColors);
        }
        f.close();
        return 256;
    }
}

