/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.util.Iterator;
import java.util.List;
import ome.model.core.Channel;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.QuantumDef;
import ome.model.stats.StatsInfo;
import omeis.providers.re.metadata.StatsFactory;
import omeis.providers.re.quantum.QuantumFactory;
import omeis.providers.re.quantum.QuantumStrategy;

class QuantumManager {
    private final Pixels metadata;
    private final QuantumStrategy[] wavesStg;
    private final QuantumFactory factory;

    QuantumManager(Pixels metadata, QuantumFactory factory) {
        this.factory = factory;
        this.metadata = metadata;
        this.wavesStg = new QuantumStrategy[metadata.getSizeC().intValue()];
    }

    void initStrategies(QuantumDef qd, List<ChannelBinding> waves) {
        ChannelBinding[] cb = waves.toArray(new ChannelBinding[waves.size()]);
        this.initStrategies(qd, cb);
    }

    void initStrategies(QuantumDef qd, ChannelBinding[] waves) {
        int w = 0;
        StatsFactory sf = new StatsFactory();
        Iterator<Channel> i = this.metadata.iterateChannels();
        while (i.hasNext()) {
            double gMax;
            double gMin;
            Channel channel = i.next();
            QuantumStrategy stg = this.factory.getStrategy(qd, this.metadata);
            StatsInfo statsInfo = channel.getStatsInfo();
            if (statsInfo == null) {
                double[] minmax = sf.initPixelsRange(this.metadata);
                gMin = minmax[0];
                gMax = minmax[1];
            } else {
                gMin = statsInfo.getGlobalMin();
                gMax = statsInfo.getGlobalMax();
            }
            stg.setExtent(gMin, gMax);
            stg.setMapping(waves[w].getFamily(), waves[w].getCoefficient(), waves[w].getNoiseReduction());
            stg.setWindow(waves[w].getInputStart(), waves[w].getInputEnd());
            this.wavesStg[w] = stg;
            ++w;
        }
    }

    QuantumStrategy getStrategyFor(int w) {
        return this.wavesStg[w];
    }
}

