/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.io.IOException;
import ome.conditions.ResourceError;
import ome.io.nio.PixelBuffer;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import omeis.providers.re.RGBAIntBuffer;
import omeis.providers.re.RGBBuffer;
import omeis.providers.re.RGBIntBuffer;
import omeis.providers.re.Renderer;
import omeis.providers.re.RenderingStats;
import omeis.providers.re.RenderingStrategy;
import omeis.providers.re.codomain.CodomainChain;
import omeis.providers.re.data.Plane2D;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.PlaneFactory;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GreyScaleStrategy
extends RenderingStrategy {
    private static Logger log = LoggerFactory.getLogger(GreyScaleStrategy.class);
    private int channel;
    private ChannelBinding channelBinding;

    GreyScaleStrategy() {
    }

    @Override
    RGBBuffer render(Renderer ctx, PlaneDef planeDef) throws IOException, QuantizationException {
        this.renderer = ctx;
        Pixels metadata = this.renderer.getMetadata();
        this.initAxesSize(planeDef, metadata);
        if (!this.findFirstActiveChannelBinding()) {
            return this.getRgbBuffer();
        }
        PixelBuffer pixels = this.renderer.getPixels();
        RenderingStats performanceStats = this.renderer.getStats();
        QuantumStrategy qs = this.renderer.getQuantumManager().getStrategyFor(this.channel);
        CodomainChain cc = this.renderer.getCodomainChain(this.channel);
        performanceStats.startIO(this.channel);
        Plane2D plane = PlaneFactory.createPlane(planeDef, this.channel, metadata, pixels);
        performanceStats.endIO(this.channel);
        RGBBuffer buf = this.getRgbBuffer();
        float alpha = this.channelBinding.getAlpha().floatValue() / 255.0f;
        byte[] r = buf.getRedBand();
        byte[] g = buf.getBlueBand();
        byte[] b = buf.getGreenBand();
        boolean hasMapContext = cc.hasMapContext();
        if (plane.isXYPlanar()) {
            int planeSize = this.sizeX1 * this.sizeX2;
            for (int i = 0; i < planeSize; ++i) {
                for (int x1 = 0; x1 < this.sizeX1; ++x1) {
                    byte value;
                    int discreteValue = qs.quantize(plane.getPixelValue(i));
                    if (hasMapContext) {
                        discreteValue = cc.transform(discreteValue);
                    }
                    r[i] = value = (byte)((float)discreteValue * alpha);
                    g[i] = value;
                    b[i] = value;
                }
            }
        } else {
            for (int x2 = 0; x2 < this.sizeX2; ++x2) {
                for (int x1 = 0; x1 < this.sizeX1; ++x1) {
                    byte value;
                    int pixelIndex = this.sizeX1 * x2 + x1;
                    int discreteValue = qs.quantize(plane.getPixelValue(x1, x2));
                    if (hasMapContext) {
                        discreteValue = cc.transform(discreteValue);
                    }
                    r[pixelIndex] = value = (byte)((float)discreteValue * alpha);
                    g[pixelIndex] = value;
                    b[pixelIndex] = value;
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RGBIntBuffer renderAsPackedInt(Renderer ctx, PlaneDef planeDef) throws IOException, QuantizationException {
        Plane2D plane;
        this.renderer = ctx;
        Pixels metadata = this.renderer.getMetadata();
        this.initAxesSize(planeDef, metadata);
        if (!this.findFirstActiveChannelBinding()) {
            return this.getIntBuffer();
        }
        PixelBuffer pixels = this.renderer.getPixels();
        RenderingStats performanceStats = this.renderer.getStats();
        QuantumStrategy qs = this.renderer.getQuantumManager().getStrategyFor(this.channel);
        CodomainChain cc = this.renderer.getCodomainChain(this.channel);
        try {
            performanceStats.startIO(this.channel);
            plane = PlaneFactory.createPlane(planeDef, this.channel, metadata, pixels);
            performanceStats.endIO(this.channel);
        }
        finally {
            try {
                pixels.close();
            }
            catch (IOException e) {
                log.error("Pixels could not be closed successfully.", e);
                throw new ResourceError(e.getMessage() + " Please check server log.");
            }
        }
        RGBIntBuffer dataBuf = this.getIntBuffer();
        int alpha = this.channelBinding.getAlpha();
        int[] buf = dataBuf.getDataBuffer();
        boolean hasMapContext = cc.hasMapContext();
        if (plane.isXYPlanar()) {
            int planeSize = this.sizeX1 * this.sizeX2;
            for (int i = 0; i < planeSize; ++i) {
                int discreteValue = qs.quantize(plane.getPixelValue(i));
                if (hasMapContext) {
                    discreteValue = cc.transform(discreteValue);
                }
                buf[i] = alpha << 24 | discreteValue << 16 | discreteValue << 8 | discreteValue;
            }
        } else {
            for (int x2 = 0; x2 < this.sizeX2; ++x2) {
                int pixelIndex = this.sizeX1 * x2;
                for (int x1 = 0; x1 < this.sizeX1; ++x1) {
                    int discreteValue = qs.quantize(plane.getPixelValue(x1, x2));
                    if (hasMapContext) {
                        discreteValue = cc.transform(discreteValue);
                    }
                    buf[pixelIndex + x1] = alpha << 24 | discreteValue << 16 | discreteValue << 8 | discreteValue;
                }
            }
        }
        return dataBuf;
    }

    @Override
    RGBAIntBuffer renderAsPackedIntAsRGBA(Renderer ctx, PlaneDef planeDef) throws IOException, QuantizationException {
        this.renderer = ctx;
        Pixels metadata = this.renderer.getMetadata();
        this.initAxesSize(planeDef, metadata);
        if (!this.findFirstActiveChannelBinding()) {
            return this.getRGBAIntBuffer();
        }
        PixelBuffer pixels = this.renderer.getPixels();
        RenderingStats performanceStats = this.renderer.getStats();
        QuantumStrategy qs = this.renderer.getQuantumManager().getStrategyFor(this.channel);
        CodomainChain cc = this.renderer.getCodomainChain(this.channel);
        performanceStats.startIO(this.channel);
        Plane2D plane = PlaneFactory.createPlane(planeDef, this.channel, metadata, pixels);
        performanceStats.endIO(this.channel);
        RGBAIntBuffer dataBuf = this.getRGBAIntBuffer();
        int alpha = this.channelBinding.getAlpha();
        int[] buf = dataBuf.getDataBuffer();
        boolean hasMapContext = cc.hasMapContext();
        if (plane.isXYPlanar()) {
            int planeSize = this.sizeX1 * this.sizeX2;
            for (int i = 0; i < planeSize; ++i) {
                int discreteValue = qs.quantize(plane.getPixelValue(i));
                if (hasMapContext) {
                    discreteValue = cc.transform(discreteValue);
                }
                buf[i] = alpha | discreteValue << 24 | discreteValue << 16 | discreteValue << 8;
            }
        } else {
            for (int x2 = 0; x2 < this.sizeX2; ++x2) {
                int pixelIndex = this.sizeX1 * x2;
                for (int x1 = 0; x1 < this.sizeX1; ++x1) {
                    int discreteValue = qs.quantize(plane.getPixelValue(x1, x2));
                    discreteValue = cc.transform(discreteValue);
                    buf[pixelIndex + x1] = alpha | discreteValue << 24 | discreteValue << 16 | discreteValue << 8;
                }
            }
        }
        return dataBuf;
    }

    private boolean findFirstActiveChannelBinding() {
        ChannelBinding[] channelBindings = this.renderer.getChannelBindings();
        for (int i = 0; i < channelBindings.length; ++i) {
            if (!channelBindings[i].getActive().booleanValue()) continue;
            this.channel = i;
            this.channelBinding = channelBindings[i];
            return true;
        }
        return false;
    }

    @Override
    int getImageSize(PlaneDef pd, Pixels pixels) {
        this.initAxesSize(pd, pixels);
        return this.sizeX1 * this.sizeX2 * 3;
    }

    @Override
    String getPlaneDimsAsString(PlaneDef pd, Pixels pixels) {
        this.initAxesSize(pd, pixels);
        return this.sizeX1 + "x" + this.sizeX2;
    }
}

