/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import ome.model.acquisition.Filter;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.Laser;
import ome.model.acquisition.LightPath;
import ome.model.acquisition.LightSource;
import ome.model.acquisition.TransmittanceRange;
import ome.model.core.Channel;
import ome.model.core.LogicalChannel;
import ome.model.units.Length;

public class ColorsFactory {
    public static final int RED_INDEX = 0;
    public static final int GREEN_INDEX = 1;
    public static final int BLUE_INDEX = 2;
    public static final int ALPHA_INDEX = 3;
    static final int DEFAULT_ALPHA = 255;
    private static final int BLUE_MIN = 400;
    private static final int BLUE_TO_GREEN_MIN = 500;
    private static final int GREEN_TO_RED_MIN = 560;
    private static final int RED_MAX = 700;
    private static final int RANGE = 15;

    private static boolean rangeBlue(double wavelength) {
        return wavelength < 500.0;
    }

    private static boolean rangeGreen(double wavelength) {
        return wavelength >= 500.0 && wavelength < 560.0;
    }

    private static boolean rangeRed(double wavelength) {
        return wavelength >= 560.0;
    }

    private static boolean hasEmissionExcitationData(LogicalChannel lc, boolean full) {
        Laser laser;
        LightSource src;
        Iterator<Filter> j;
        ArrayList<Filter> filters;
        if (lc == null) {
            return false;
        }
        if (lc.getEmissionWave() != null) {
            return true;
        }
        FilterSet f = null;
        LightPath lp = null;
        if (lc.getLightPath() != null && (lp = lc.getLightPath()).sizeOfEmissionFilterLink() > 0) {
            filters = new ArrayList<Filter>();
            j = lp.linkedEmissionFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            j = filters.iterator();
            while (j.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(j.next())) continue;
                return true;
            }
        }
        if (lc.getFilterSet() != null && (f = lc.getFilterSet()).sizeOfEmissionFilterLink() > 0) {
            filters = new ArrayList();
            j = f.linkedEmissionFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            j = filters.iterator();
            while (j.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(j.next())) continue;
                return true;
            }
        }
        if (!full) {
            return false;
        }
        if (lc.getLightSourceSettings() != null && (src = lc.getLightSourceSettings().getLightSource()) instanceof Laser && (laser = (Laser)src).getWavelength() != null) {
            return true;
        }
        if (lc.getExcitationWave() != null) {
            return true;
        }
        if (lp != null && lp.sizeOfExcitationFilterLink() > 0) {
            filters = new ArrayList();
            j = lp.linkedExcitationFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            j = filters.iterator();
            while (j.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(j.next())) continue;
                return true;
            }
        }
        if (f != null && f.sizeOfExcitationFilterLink() > 0) {
            filters = new ArrayList();
            j = f.linkedExcitationFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            j = filters.iterator();
            while (j.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(j.next())) continue;
                return true;
            }
        }
        return false;
    }

    private static int[] getColor(Channel channel, LogicalChannel lc) {
        LightSource ls;
        Iterator<Filter> j;
        ArrayList<Filter> filters;
        if (lc == null) {
            return null;
        }
        if (!ColorsFactory.hasEmissionExcitationData(lc, true)) {
            Integer red = channel.getRed();
            Integer green = channel.getGreen();
            Integer blue = channel.getBlue();
            Integer alpha = channel.getAlpha();
            if (red != null && green != null && blue != null && alpha != null) {
                return new int[]{red, green, blue, alpha};
            }
            return null;
        }
        Length valueWavelength = lc.getEmissionWave();
        if (valueWavelength != null) {
            return ColorsFactory.determineColor(valueWavelength);
        }
        Length valueFilter = null;
        FilterSet f = null;
        LightPath lp = null;
        if (valueFilter == null && lc.getLightPath() != null) {
            filters = new ArrayList<Filter>();
            lp = lc.getLightPath();
            j = lp.linkedEmissionFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            while (valueFilter == null && j.hasNext()) {
                valueFilter = ColorsFactory.getValueFromFilter(j.next(), true);
            }
        }
        if (valueFilter == null && lc.getFilterSet() != null) {
            filters = new ArrayList();
            f = lc.getFilterSet();
            j = f.linkedEmissionFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            while (valueFilter == null && j.hasNext()) {
                valueFilter = ColorsFactory.getValueFromFilter(j.next(), true);
            }
        }
        if (valueFilter == null && lc.getLightSourceSettings() != null && (ls = lc.getLightSourceSettings().getLightSource()) instanceof Laser) {
            valueWavelength = ((Laser)ls).getWavelength();
        }
        if (valueWavelength != null) {
            return ColorsFactory.determineColor(valueWavelength);
        }
        valueWavelength = lc.getExcitationWave();
        if (valueWavelength != null) {
            return ColorsFactory.determineColor(valueWavelength);
        }
        if (valueFilter == null && lp != null) {
            filters = new ArrayList();
            j = lp.linkedExcitationFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            while (valueFilter == null && j.hasNext()) {
                valueFilter = ColorsFactory.getValueFromFilter(j.next(), false);
            }
        }
        if (valueFilter == null && f != null) {
            filters = new ArrayList();
            j = f.linkedExcitationFilterIterator();
            while (j.hasNext()) {
                filters.add(j.next());
            }
            ColorsFactory.sortFilters(filters);
            while (valueFilter == null && j.hasNext()) {
                valueFilter = ColorsFactory.getValueFromFilter(j.next(), false);
            }
        }
        return ColorsFactory.determineColor(valueFilter != null ? valueFilter : null);
    }

    private static int[] determineColor(Length value) {
        if (value == null) {
            return null;
        }
        if (ColorsFactory.rangeBlue(value.getValue())) {
            return ColorsFactory.newBlueColor();
        }
        if (ColorsFactory.rangeGreen(value.getValue())) {
            return ColorsFactory.newGreenColor();
        }
        if (ColorsFactory.rangeRed(value.getValue())) {
            return ColorsFactory.newRedColor();
        }
        return null;
    }

    private static Length getValueFromFilter(Filter filter, boolean emission) {
        Length v;
        if (filter == null) {
            return null;
        }
        TransmittanceRange transmittance = filter.getTransmittanceRange();
        if (transmittance == null) {
            return null;
        }
        Length cutIn = transmittance.getCutIn();
        if (emission) {
            if (cutIn == null) {
                return null;
            }
            return new Length(cutIn.getValue() + 15.0, cutIn.getUnit());
        }
        Length cutOut = transmittance.getCutOut();
        if (cutOut == null) {
            return null;
        }
        if (cutIn == null || cutIn.getValue() == 0.0) {
            cutIn = new Length(cutOut.getValue() - 30.0, cutOut.getUnit());
        }
        if ((v = new Length(cutIn.getValue() + cutOut.getValue() / 2.0, cutOut.getUnit())).getValue() < 0.0) {
            return new Length(0.0, cutOut.getUnit());
        }
        return v;
    }

    private static boolean isFilterHasEmissionData(Filter f) {
        if (f == null) {
            return false;
        }
        TransmittanceRange transmittance = f.getTransmittanceRange();
        if (transmittance == null) {
            return false;
        }
        return transmittance.getCutIn() != null;
    }

    private static void sortFilters(List<Filter> filters) {
        if (filters == null || filters.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long id1 = ((Filter)o1).getId();
                long id2 = ((Filter)o2).getId();
                int v = 0;
                if (id1 < id2) {
                    v = -1;
                } else if (id1 > id2) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(filters, c);
    }

    public static int[] getColor(int index, Channel channel) {
        return ColorsFactory.getColor(index, channel, channel.getLogicalChannel());
    }

    public static int[] getColor(int index, Channel channel, LogicalChannel lc) {
        int[] c;
        if (lc == null) {
            lc = channel.getLogicalChannel();
        }
        if ((c = ColorsFactory.getColor(channel, lc)) != null) {
            return c;
        }
        switch (index % 3) {
            case 0: {
                return ColorsFactory.newRedColor();
            }
            case 1: {
                return ColorsFactory.newGreenColor();
            }
        }
        return ColorsFactory.newBlueColor();
    }

    public static boolean hasEmissionData(LogicalChannel lc) {
        return ColorsFactory.hasEmissionExcitationData(lc, false);
    }

    public static int[] newRedColor() {
        return new int[]{255, 0, 0, 255};
    }

    public static int[] newGreenColor() {
        return new int[]{0, 255, 0, 255};
    }

    public static int[] newBlueColor() {
        return new int[]{0, 0, 255, 255};
    }

    public static int[] newGreyColor() {
        return new int[]{128, 128, 128, 255};
    }

    public static int[] newWhiteColor() {
        return new int[]{255, 255, 255, 255};
    }
}

