/*
 * Decompiled with CFR 0.152.
 */
package ome.util.checksum;

import com.google.common.base.Optional;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import ome.util.checksum.ChecksumProvider;

public class AbstractChecksumProvider
implements ChecksumProvider {
    private final HashFunction hashFunction;
    private Hasher hasher;
    private Optional<HashCode> hashCode = Optional.absent();
    private Optional<byte[]> hashBytes = Optional.absent();
    private Optional<String> hashString = Optional.absent();

    protected AbstractChecksumProvider(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
        this.hasher = this.hashFunction.newHasher();
    }

    @Override
    public ChecksumProvider putBytes(byte[] byteArray) {
        return this.putBytes(byteArray, 0, byteArray.length);
    }

    @Override
    public ChecksumProvider putBytes(byte[] byteArray, int offset, int length) {
        this.verifyState(this.hashBytes, this.hashString);
        this.hasher.putBytes(byteArray, offset, length);
        return this;
    }

    @Override
    public ChecksumProvider putBytes(ByteBuffer byteBuffer) {
        this.verifyState(this.hashBytes, this.hashString);
        if (byteBuffer.hasArray()) {
            this.hasher.putBytes(byteBuffer.array(), 0, byteBuffer.limit());
            return this;
        }
        throw new IllegalArgumentException("Supplied ByteBuffer has inaccessible array.");
    }

    @Override
    public ChecksumProvider putFile(String filePath) {
        this.verifyState(this.hashBytes, this.hashString);
        try {
            this.hashCode = Optional.of(Files.hash(new File(filePath), this.hashFunction));
            return this;
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    @Override
    public byte[] checksumAsBytes() {
        this.hashBytes = Optional.of(this.pickChecksum().asBytes());
        return this.hashBytes.get();
    }

    @Override
    public String checksumAsString() {
        this.hashString = Optional.of(this.pickChecksum().toString());
        return this.hashString.get();
    }

    private HashCode pickChecksum() {
        return this.hashCode.isPresent() ? this.hashCode.get() : this.hasher.hash();
    }

    private void verifyState(Optional ... optionalObjects) {
        for (Optional optionalObject : optionalObjects) {
            if (!optionalObject.isPresent()) continue;
            throw new IllegalStateException("Checksum state already set. Mutation illegal.");
        }
    }
}

