/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ome.conditions.InternalException;
import ome.model.core.Channel;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.ExperimenterGroup;
import ome.model.stats.StatsInfo;
import ome.util.Utils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;

public interface SqlAction {
    public void prepareSession(long var1, long var3, long var5);

    public String rewriteHql(String var1, String var2, Object var3);

    public String createIdsTempTable(Collection<Long> var1);

    public void createInsertTrigger(String var1, String var2, String var3);

    public boolean activeSession(String var1);

    public long getGroupPermissions(long var1);

    public ExperimenterGroup groupInfoFor(String var1, long var2);

    public String fileRepo(long var1);

    public String scriptRepo(long var1, Set<String> var3);

    public int synchronizeJobs(List<Long> var1);

    public Long findRepoFile(String var1, String var2, String var3);

    public Long findRepoFile(String var1, String var2, String var3, String var4);

    public Long findRepoFile(String var1, String var2, String var3, Set<String> var4);

    public Map<String, Long> findRepoFiles(String var1, String var2, List<String> var3, Set<String> var4);

    public List<Long> findRepoFiles(String var1, String var2);

    public List<DeleteLog> findRepoDeleteLogs(DeleteLog var1);

    public int deleteRepoDeleteLogs(DeleteLog var1);

    public String findRepoRootPath(String var1);

    public String findRepoFilePath(String var1, long var2);

    public List<Long> findRepoPixels(String var1, String var2, String var3);

    public Long findRepoImageFromPixels(long var1);

    public int repoScriptCount(String var1, Set<String> var2);

    public Long nextSessionId();

    public List<Long> fileIdsInDb(String var1, Set<String> var2);

    public List<Long> filterFileIdsByRepo(String var1, List<Long> var2);

    public Map<String, Object> repoFile(long var1);

    public List<long[]> nextPixelsDataLogForRepo(String var1, long var2, int var4);

    public long countFormat(String var1);

    @Deprecated
    public int insertFormat(String var1);

    public int closeSessions(String var1);

    public int closeNodeSessions(String var1);

    public int closeNode(String var1);

    public long nodeId(String var1);

    public int insertSession(Map<String, Object> var1);

    public Long sessionId(String var1);

    public int isFileInRepo(String var1, long var2, Set<String> var4);

    public int removePassword(Long var1);

    public Date now();

    public int updateConfiguration(String var1, String var2);

    public String dbVersion();

    public String configValue(String var1);

    public int delConfigValue(String var1);

    public int updateOrInsertConfigValue(String var1, String var2);

    public String dbUuid();

    public long selectCurrentEventLog(String var1);

    public float getEventLogPercent(String var1);

    public List<Object[]> getEventLogPartitions(Collection<String> var1, Collection<String> var2, long var3, long var5);

    public void setCurrentEventLog(long var1, String var3);

    public void delCurrentEventLog(String var1);

    public void refreshEventLogFromUpdatedAnnotations();

    public long nextValue(String var1, int var2);

    public long currValue(String var1);

    public void insertLogs(List<Object[]> var1);

    public List<Map<String, Object>> roiByImage(long var1);

    public List<Long> getShapeIds(long var1);

    public boolean setUserPassword(Long var1, String var2);

    public String getPasswordHash(Long var1);

    public Long getUserId(String var1);

    public String getUsername(long var1);

    public Collection<String> getUserEmailsByGroup(long var1);

    public List<Long> getLdapExperimenters();

    public boolean isLdapExperimenter(Long var1);

    public Map<String, Long> getGroupIds(Collection<String> var1);

    public List<String> getUserGroups(String var1);

    public void setFileRepo(Collection<Long> var1, String var2);

    public void setPixelsNamePathRepo(long var1, String var3, String var4, String var5);

    public long setStatsInfo(Channel var1, StatsInfo var2);

    public List<Long> getDeletedIds(String var1);

    public void createSavepoint(String var1);

    public void releaseSavepoint(String var1);

    public void rollbackSavepoint(String var1);

    public void deferConstraints();

    public Map<Long, byte[]> getShareData(List<Long> var1);

    public List<String> getPixelsNamePathRepo(long var1) throws InternalException;

    public Set<String> currentUserNames();

    public int changeGroupPermissions(Long var1, Long var2);

    public int changeTablePermissionsForGroup(String var1, Long var2, Long var3);

    public boolean hasUnicodeUnits();

    public void addMessageWithinDbPatchStart(String var1, int var2, String var3);

    public void addMessageWithinDbPatchEnd(String var1, int var2, String var3);

    public boolean setPermissionsBit(String var1, long var2, int var4);

    public boolean clearPermissionsBit(String var1, long var2, int var4);

    public static abstract class Impl
    implements SqlAction {
        protected static final int MAX_IN_SIZE = 1000;
        protected final Logger log = LoggerFactory.getLogger(this.getClass());

        protected abstract SimpleJdbcOperations _jdbc();

        protected abstract String _lookup(String var1);

        protected String printThrowable(Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }

        @Override
        public void createInsertTrigger(String name, String table, String procedure) {
            this._jdbc().update(String.format("DROP TRIGGER IF EXISTS %s ON %s", name, table), new Object[0]);
            this._jdbc().update(String.format("CREATE TRIGGER %s AFTER INSERT ON %s FOR EACH ROW EXECUTE PROCEDURE %s", name, table, procedure), new Object[0]);
        }

        @Override
        public String rewriteHql(String query, String key, Object value) {
            Collection l;
            if (value instanceof Collection && (l = (Collection)value).size() > 1000) {
                for (Object o : l) {
                    if (o instanceof Long) continue;
                    this.log.debug("Not replacing query; non-long");
                    return query;
                }
                if (query.contains("(:ids)")) {
                    String temp = this.createIdsTempTable(l);
                    String repl = "temp_ids_cursor('" + temp + "')";
                    query = query.replace("(:ids)", "(" + repl + ")");
                }
            }
            return query;
        }

        @Override
        public String createIdsTempTable(Collection<Long> ids) {
            String name = UUID.randomUUID().toString().replaceAll("-", "");
            ArrayList<Object[]> batch = new ArrayList<Object[]>();
            for (Long id : ids) {
                batch.add(new Object[]{name, id});
            }
            this._jdbc().batchUpdate("insert into temp_ids (key, id) values (?, ?)", batch);
            return name;
        }

        @Override
        public int closeNodeSessions(String uuid) {
            return this._jdbc().update(this._lookup("update_node_sessions"), new Object[]{uuid});
        }

        @Override
        public int closeNode(String uuid) {
            return this._jdbc().update(this._lookup("update_node"), new Object[]{uuid});
        }

        @Override
        public boolean setUserPassword(Long experimenterID, String password) {
            int results = this._jdbc().update(this._lookup("update_password"), new Object[]{password, experimenterID});
            if (results < 1) {
                results = this._jdbc().update(this._lookup("insert_password"), new Object[]{experimenterID, password});
            }
            return results >= 1;
        }

        @Override
        public int changeGroupPermissions(Long id, Long internal) {
            return this._jdbc().update(this._lookup("update_permissions_for_group"), new Object[]{internal, id});
        }

        @Override
        public int changeTablePermissionsForGroup(String table, Long id, Long internal) {
            String sql = this._lookup("update_permissions_for_table");
            sql = String.format(sql, table);
            return this._jdbc().update(sql, new Object[]{internal, id});
        }

        @Override
        public boolean setPermissionsBit(String table, long id, int bit) {
            String sql = this._lookup("set_permissions_bit");
            sql = String.format(sql, table);
            return this._jdbc().update(sql, new Object[]{bit, id}) > 0;
        }

        @Override
        public boolean clearPermissionsBit(String table, long id, int bit) {
            String sql = this._lookup("clear_permissions_bit");
            sql = String.format(sql, table);
            return this._jdbc().update(sql, new Object[]{bit, id}) > 0;
        }

        protected String addMimetypes(Collection<String> mimetypes, Map<String, Object> params) {
            if (mimetypes != null) {
                params.put("mimetypes", mimetypes);
                return this._lookup("and_mimetype");
            }
            return "";
        }

        @Override
        public Long findRepoFile(String uuid, String dirname, String basename) {
            return this.findRepoFile(uuid, dirname, basename, (Set<String>)null);
        }

        @Override
        public Long findRepoFile(String uuid, String dirname, String basename, String mimetype) {
            return this.findRepoFile(uuid, dirname, basename, mimetype == null ? null : Collections.singleton(mimetype));
        }

        @Override
        public Long findRepoFile(String uuid, String dirname, String basename, Set<String> mimetypes) {
            Map<String, Long> rv = this.findRepoFiles(uuid, dirname, Arrays.asList(basename), mimetypes);
            if (rv == null) {
                return null;
            }
            return rv.get(basename);
        }

        @Override
        public Map<String, Long> findRepoFiles(String uuid, String dirname, List<String> basenames, Set<String> mimetypes) {
            if (basenames == null || basenames.size() == 0) {
                return null;
            }
            List<List<String>> batches = Lists.partition(basenames, 1000);
            HashMap<String, Object> params = new HashMap<String, Object>();
            String findRepoFileSql = this._lookup("find_repo_files_by_name");
            params.put("repo", uuid);
            params.put("path", dirname);
            findRepoFileSql = findRepoFileSql + this.addMimetypes(mimetypes, params);
            HashMap rv = null;
            for (List<String> batch : batches) {
                params.put("names", batch);
                try {
                    final HashMap tmp = new HashMap();
                    this._jdbc().query(findRepoFileSql, (RowMapper)new RowMapper<Object>(){

                        public Object mapRow(ResultSet arg0, int arg1) throws SQLException {
                            tmp.put(arg0.getString(1), arg0.getLong(2));
                            return null;
                        }
                    }, params);
                    if (rv == null) {
                        rv = tmp;
                        continue;
                    }
                    rv.putAll(tmp);
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {}
            }
            return rv;
        }

        @Override
        public int repoScriptCount(String uuid, Set<String> mimetypes) {
            String query = this._lookup("repo_script_count");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("repo", uuid);
            query = query + this.addMimetypes(mimetypes, params);
            return this._jdbc().queryForInt(query, params);
        }

        @Override
        public int isFileInRepo(String uuid, long id, Set<String> mimetypes) {
            String query = this._lookup("is_file_in_repo");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("repo", uuid);
            params.put("file", id);
            query = query + this.addMimetypes(mimetypes, params);
            return this._jdbc().queryForInt(query, params);
        }

        @Override
        public List<Long> fileIdsInDb(String uuid, Set<String> mimetypes) {
            String query = this._lookup("file_id_in_db");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("repo", uuid);
            query = query + this.addMimetypes(mimetypes, params);
            return this._jdbc().query(query, (RowMapper)new IdRowMapper(), params);
        }

        @Override
        public List<Long> filterFileIdsByRepo(String uuid, List<Long> fileIds) {
            ImmutableMap<String, List<Long>> arguments = ImmutableMap.of("repo", uuid, "ids", fileIds);
            try {
                return this._jdbc().query(this._lookup("find_files_in_repo"), (RowMapper)new IdRowMapper(), arguments);
            }
            catch (EmptyResultDataAccessException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public List<Long> findRepoFiles(String uuid, String dirname) {
            try {
                return this._jdbc().query(this._lookup("find_repo_files"), (RowMapper)new IdRowMapper(), new Object[]{uuid, dirname});
            }
            catch (EmptyResultDataAccessException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public List<DeleteLog> findRepoDeleteLogs(DeleteLog template) {
            try {
                return this._jdbc().query(this._lookup("find_repo_delete_logs"), (RowMapper)template, template.args());
            }
            catch (EmptyResultDataAccessException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public int deleteRepoDeleteLogs(DeleteLog template) {
            return this._jdbc().update(this._lookup("delete_repo_delete_logs"), template.args());
        }

        @Override
        public String findRepoRootPath(String uuid) {
            try {
                return (String)this._jdbc().queryForObject(this._lookup("find_repo_root_path"), String.class, new Object[]{uuid});
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public String findRepoFilePath(String uuid, long id) {
            try {
                return (String)this._jdbc().queryForObject(this._lookup("find_repo_file_path"), String.class, new Object[]{id, uuid});
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public List<long[]> nextPixelsDataLogForRepo(String repo, long lastEventId, int rows) {
            RowMapper<long[]> rm = new RowMapper<long[]>(){

                public long[] mapRow(ResultSet arg0, int arg1) throws SQLException {
                    long[] rv = new long[]{arg0.getLong(1), arg0.getLong(2), arg0.getLong(3), arg0.getLong(4)};
                    return rv;
                }
            };
            try {
                if (repo == null) {
                    return this._jdbc().query(this._lookup("find_next_pixels_data_per_user_for_null_repo"), (RowMapper)rm, new Object[]{lastEventId, rows});
                }
                return this._jdbc().query(this._lookup("find_next_pixels_data_per_user_for_repo"), (RowMapper)rm, new Object[]{lastEventId, repo, rows});
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public long getGroupPermissions(long groupId) {
            return (Long)this._jdbc().queryForObject(this._lookup("get_group_permissions"), Long.class, new Object[]{groupId});
        }

        @Override
        public Map<String, Long> getGroupIds(Collection<String> names) {
            final HashMap<String, Long> rv = new HashMap<String, Long>();
            if (names == null || names.size() == 0) {
                return rv;
            }
            HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
            params.put("names", names);
            RowMapper<Object> mapper = new RowMapper<Object>(){

                public Object mapRow(ResultSet arg0, int arg1) throws SQLException {
                    Long id = arg0.getLong(1);
                    String name = arg0.getString(2);
                    rv.put(name, id);
                    return null;
                }
            };
            this._jdbc().query(this._lookup("get_group_ids"), (RowMapper)mapper, params);
            return rv;
        }

        @Override
        public String getPasswordHash(Long experimenterID) {
            String stored;
            try {
                stored = (String)this._jdbc().queryForObject(this._lookup("password_hash"), String.class, new Object[]{experimenterID});
            }
            catch (EmptyResultDataAccessException e) {
                stored = null;
            }
            return stored;
        }

        @Override
        public Long getUserId(String userName) {
            Long id;
            try {
                id = (Long)this._jdbc().queryForObject(this._lookup("user_id"), Long.class, new Object[]{userName});
            }
            catch (EmptyResultDataAccessException e) {
                id = null;
            }
            return id;
        }

        @Override
        public Collection<String> getUserEmailsByGroup(long groupId) {
            try {
                return this._jdbc().query(this._lookup("user_emails_by_group"), (RowMapper)new StringRowMapper(), new Object[]{groupId});
            }
            catch (EmptyResultDataAccessException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public String getUsername(long userId) {
            String name;
            try {
                name = (String)this._jdbc().queryForObject(this._lookup("user_name"), String.class, new Object[]{userId});
            }
            catch (EmptyResultDataAccessException e) {
                name = null;
            }
            return name;
        }

        @Override
        public List<Long> getLdapExperimenters() {
            return this._jdbc().query(this._lookup("get_ldap_experimenters"), (RowMapper)new IdRowMapper(), new Object[0]);
        }

        @Override
        public boolean isLdapExperimenter(Long id) {
            String query = this._lookup("is_ldap_experimenter");
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("id", id);
            return (Boolean)this._jdbc().queryForObject(query, Boolean.class, params);
        }

        @Override
        public List<String> getUserGroups(String userName) {
            List roles;
            try {
                roles = this._jdbc().query(this._lookup("user_groups"), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return rs.getString(1);
                    }
                }, new Object[]{userName});
            }
            catch (EmptyResultDataAccessException e) {
                roles = null;
            }
            return roles == null ? new ArrayList() : roles;
        }

        @Override
        public ExperimenterGroup groupInfoFor(String table, long id) {
            try {
                return (ExperimenterGroup)this._jdbc().queryForObject(String.format(this._lookup("get_group_info"), table), (RowMapper)new RowMapper<ExperimenterGroup>(){

                    public ExperimenterGroup mapRow(ResultSet arg0, int arg1) throws SQLException {
                        ExperimenterGroup group = new ExperimenterGroup();
                        group.setId(arg0.getLong(1));
                        group.setName(arg0.getString(2));
                        Permissions p = Utils.toPermissions(arg0.getLong(3));
                        group.getDetails().setPermissions(p);
                        return group;
                    }
                }, new Object[]{id});
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public String fileRepo(long fileId) {
            return (String)this._jdbc().queryForObject(this._lookup("file_repo"), String.class, new Object[]{fileId});
        }

        @Override
        public String scriptRepo(long fileId, Set<String> mimetypes) {
            String query = this._lookup("file_repo_of_script");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("file", fileId);
            query = query + this.addMimetypes(mimetypes, params);
            try {
                return (String)this._jdbc().queryForObject(query, String.class, params);
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public long setStatsInfo(Channel ch, StatsInfo si) {
            Details d = ch.getDetails();
            long id = this.nextValue("seq_statsinfo", 1);
            this._jdbc().update(this._lookup("stats_info_creation"), new Object[]{id, Utils.internalForm(d.getPermissions()), si.getGlobalMax(), si.getGlobalMin(), d.getCreationEvent().getId(), d.getGroup().getId(), d.getOwner().getId(), d.getUpdateEvent().getId()});
            this._jdbc().update(this._lookup("stats_info_set_on_channel"), new Object[]{id, ch.getId()});
            return id;
        }

        @Override
        public String configValue(String key) {
            try {
                return (String)this._jdbc().queryForObject(this._lookup("config_value_select"), String.class, new Object[]{key});
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public int delConfigValue(String key) {
            return this._jdbc().update(this._lookup("config_value_delete"), new Object[]{key});
        }

        @Override
        public int updateOrInsertConfigValue(String name, String value) {
            int count = this._jdbc().update(this._lookup("config_value_update"), new Object[]{value, name});
            if (count == 0) {
                count = this._jdbc().update(this._lookup("config_value_insert"), new Object[]{name, value});
            }
            return count;
        }

        @Override
        public long selectCurrentEventLog(String key) {
            String value = (String)this._jdbc().queryForObject(this._lookup("log_loader_query"), String.class, new Object[]{key});
            return Long.valueOf(value);
        }

        @Override
        public float getEventLogPercent(String key) {
            Float value = (Float)this._jdbc().queryForObject(this._lookup("log_loader_percent"), Float.class, new Object[]{key});
            return value.floatValue();
        }

        @Override
        public List<Object[]> getEventLogPartitions(Collection<String> types, Collection<String> actions2, long offset, long limit) {
            String query = this._lookup("log_loader_partition");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("types", types);
            params.put("actions", actions2);
            params.put("currentid", offset);
            params.put("max", limit);
            return this._jdbc().query(query, (RowMapper)new RowMapper<Object[]>(){

                public Object[] mapRow(ResultSet arg0, int arg1) throws SQLException {
                    return new Object[]{arg0.getLong(1), arg0.getString(2), arg0.getLong(3), arg0.getString(4), arg0.getInt(5)};
                }
            }, params);
        }

        @Override
        public void setCurrentEventLog(long id, String key) {
            int count = this._jdbc().update(this._lookup("log_loader_update"), new Object[]{Long.toString(id), key});
            if (count == 0) {
                this._jdbc().update(this._lookup("log_loader_insert"), new Object[]{key, Long.toString(id)});
            }
        }

        @Override
        public void delCurrentEventLog(String key) {
            this._jdbc().update(this._lookup("log_loader_delete"), new Object[]{key});
        }

        @Override
        public void refreshEventLogFromUpdatedAnnotations() {
            this._jdbc().query(this._lookup("event_log.refresh"), (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet arg0, int arg1) {
                    return null;
                }
            }, new Object[0]);
        }

        @Override
        public boolean hasUnicodeUnits() {
            try {
                this._jdbc().query(this._lookup("check_units"), (RowMapper)new RowMapper<Object>(){

                    public Object mapRow(ResultSet rs, int rowNum) {
                        return null;
                    }
                }, new Object[0]);
            }
            catch (DataAccessException dae) {
                return false;
            }
            return true;
        }

        @Override
        public void addMessageWithinDbPatchStart(String version, int patch, String message) {
            ImmutableMap<String, String> parameters = ImmutableMap.of("version", version, "patch", patch, "message", message);
            this._jdbc().update(this._lookup("adjust_within_patch.start"), parameters);
        }

        @Override
        public void addMessageWithinDbPatchEnd(String version, int patch, String message) {
            ImmutableMap<String, String> parameters = ImmutableMap.of("version", version, "patch", patch, "message", message);
            this._jdbc().update(this._lookup("adjust_within_patch.end"), parameters);
        }

        @Override
        public Map<Long, byte[]> getShareData(List<Long> ids) {
            final HashMap<Long, byte[]> rv = new HashMap<Long, byte[]>();
            if (ids == null || ids.isEmpty()) {
                return rv;
            }
            HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
            params.put("ids", ids);
            RowMapper<Object> mapper = new RowMapper<Object>(){

                public Object mapRow(ResultSet arg0, int arg1) throws SQLException {
                    Long id = arg0.getLong(1);
                    byte[] data = arg0.getBytes(2);
                    rv.put(id, data);
                    return null;
                }
            };
            this._jdbc().query(this._lookup("share_data"), (RowMapper)mapper, params);
            return rv;
        }
    }

    public static class DeleteLog
    implements RowMapper<DeleteLog> {
        public Long eventId;
        public Long fileId;
        public Long ownerId;
        public Long groupId;
        public String path;
        public String name;
        public String repo;

        public DeleteLog mapRow(ResultSet rs, int arg1) throws SQLException {
            DeleteLog dl = new DeleteLog();
            dl.eventId = rs.getLong("event_id");
            dl.fileId = rs.getLong("file_id");
            dl.ownerId = rs.getLong("owner_id");
            dl.groupId = rs.getLong("group_id");
            dl.path = rs.getString("path");
            dl.name = rs.getString("name");
            dl.repo = rs.getString("repo");
            return dl;
        }

        public SqlParameterSource args() {
            MapSqlParameterSource source = new MapSqlParameterSource();
            source.addValue("eid", (Object)this.eventId, -5);
            source.addValue("eid", (Object)this.eventId, -5);
            source.addValue("fid", (Object)this.fileId, -5);
            source.addValue("oid", (Object)this.ownerId, -5);
            source.addValue("gid", (Object)this.groupId, -5);
            source.addValue("p", (Object)this.path, 12);
            source.addValue("n", (Object)this.name, 12);
            source.addValue("r", (Object)this.repo, 12);
            return source;
        }

        public String toString() {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            sb.append("DeleteLog<");
            this.append(sb, first, "event", this.eventId);
            this.append(sb, first, "file", this.fileId);
            this.append(sb, first, "owner", this.ownerId);
            this.append(sb, first, "group", this.groupId);
            this.append(sb, first, "path", this.path);
            this.append(sb, first, "name", this.name);
            this.append(sb, first, "repo", this.repo);
            sb.append(">");
            return sb.toString();
        }

        private boolean append(StringBuilder sb, boolean first, String name, Object o) {
            if (o != null) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(name);
                sb.append("=");
                sb.append(o.toString());
                return false;
            }
            return first;
        }
    }

    public static class LoggingSqlAction
    implements MethodInterceptor {
        private static final Logger log = LoggerFactory.getLogger(SqlAction.class);

        public Object invoke(MethodInvocation arg0) throws Throwable {
            if (log.isDebugEnabled()) {
                log.debug(String.format("%s.%s(%s)", arg0.getThis(), arg0.getMethod().getName(), Arrays.deepToString(arg0.getArguments())));
            }
            return arg0.proceed();
        }
    }

    public static class StringRowMapper
    implements RowMapper<String> {
        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString(1);
        }
    }

    public static class IdRowMapper
    implements RowMapper<Long> {
        public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getLong(1);
        }
    }
}

