/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.formats.FormatTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelData {
    public static final String CONFIG_KEY = "omero.pixeldata.dispose";
    private static final Logger LOG = LoggerFactory.getLogger(PixelData.class);
    private static final Method DIRECT_BUFFER_CLEANER;
    private static final Method DIRECT_BUFFER_CLEANER_CLEAN;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int BIT = 6;
    protected String pixelsType;
    protected ByteBuffer data;
    protected boolean isSigned;
    protected boolean isFloat;
    protected int javaType;
    protected int bytesPerPixel;
    protected double minimum;
    protected double maximum;

    public PixelData(String pixelsType, ByteBuffer data) {
        this.data = data;
        this.pixelsType = pixelsType;
        this.bytesPerPixel = this.bytesPerPixel();
        int type = FormatTools.pixelTypeFromString(pixelsType);
        long[] values = FormatTools.defaultMinMax(type);
        this.isSigned = FormatTools.isSigned(type);
        this.isFloat = FormatTools.isFloatingPoint(type);
        this.minimum = values[0];
        this.maximum = values[1];
        switch (type) {
            case 0: 
            case 1: {
                this.javaType = 0;
                break;
            }
            case 2: 
            case 3: {
                this.javaType = 1;
                break;
            }
            case 4: 
            case 5: {
                this.javaType = 2;
                break;
            }
            case 6: {
                this.javaType = 4;
                break;
            }
            case 7: {
                this.javaType = 5;
                break;
            }
            case 8: {
                this.javaType = 6;
            }
        }
    }

    public boolean in(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!this.pixelsType.equals(strings[i])) continue;
            return true;
        }
        return false;
    }

    public int bytesPerPixel() {
        int type = FormatTools.pixelTypeFromString(this.pixelsType);
        return FormatTools.getBytesPerPixel(type);
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public int javaType() {
        return this.javaType;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setPixelValue(int offset, double value) {
        this.setPixelValueDirect(offset * this.bytesPerPixel, value);
    }

    public void setPixelValueDirect(int offset, double value) {
        switch (this.javaType) {
            case 6: {
                int byteOffset = offset / 8;
                byte x = this.data.get(byteOffset);
                if (value == 0.0) {
                    this.data.put(byteOffset, (byte)(x & ~(1 << 7 - offset % 8)));
                    break;
                }
                this.data.put(byteOffset, (byte)(x | 1 << 7 - offset % 8));
                break;
            }
            case 0: {
                this.data.put(offset, (byte)value);
                break;
            }
            case 1: {
                this.data.putShort(offset, (short)value);
                break;
            }
            case 2: {
                this.data.putInt(offset, (int)value);
                break;
            }
            case 4: {
                this.data.putFloat(offset, (float)value);
                break;
            }
            case 5: {
                this.data.putDouble(offset, value);
            }
        }
    }

    public double getPixelValue(int offset) {
        return this.getPixelValueDirect(offset * this.bytesPerPixel);
    }

    public double getPixelValueDirect(int offset) {
        if (this.isSigned()) {
            switch (this.javaType) {
                case 0: {
                    return this.data.get(offset);
                }
                case 1: {
                    return this.data.getShort(offset);
                }
                case 2: {
                    return this.data.getInt(offset);
                }
                case 4: {
                    return this.data.getFloat(offset);
                }
                case 5: {
                    return this.data.getDouble(offset);
                }
            }
        } else {
            switch (this.javaType) {
                case 6: {
                    return this.data.get(offset / 8) >> 7 - offset % 8 & 1;
                }
                case 0: {
                    return (short)(this.data.get(offset) & 0xFF);
                }
                case 1: {
                    return this.data.getShort(offset) & 0xFFFF;
                }
                case 2: {
                    return (long)this.data.getInt(offset) & 0xFFFFFFFFL;
                }
                case 4: {
                    return this.data.getFloat(offset);
                }
                case 5: {
                    return this.data.getDouble(offset);
                }
            }
        }
        throw new RuntimeException("Unknown pixel type.");
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public ByteOrder getOrder() {
        return this.data.order();
    }

    public void setOrder(ByteOrder order) {
        this.data.order(order);
    }

    public int size() {
        return this.data.capacity() / this.bytesPerPixel;
    }

    public static int getBitDepth(String type) {
        int value = FormatTools.pixelTypeFromString(type);
        switch (value) {
            case 0: 
            case 1: {
                return 8;
            }
            case 2: 
            case 3: {
                return 16;
            }
            case 4: 
            case 5: 
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 1;
            }
        }
        throw new RuntimeException("Pixels type '" + type + "' unsupported by nio.");
    }

    public void dispose() {
        if (DIRECT_BUFFER_CLEANER != null && this.data != null && DIRECT_BUFFER_CLEANER.getDeclaringClass().isAssignableFrom(this.data.getClass())) {
            block4: {
                try {
                    Object cleaner = DIRECT_BUFFER_CLEANER.invoke((Object)this.data, new Object[0]);
                    if (cleaner != null) {
                        DIRECT_BUFFER_CLEANER_CLEAN.invoke(cleaner, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("DirectBuffer disposal failed", e);
                }
            }
            this.data = null;
        }
    }

    static {
        String configValue = System.getProperties().getProperty(CONFIG_KEY);
        Boolean dispose = "true".equalsIgnoreCase(configValue) ? Boolean.TRUE : ("false".equalsIgnoreCase(configValue) ? Boolean.FALSE : null);
        if (dispose == null) {
            LOG.warn("{} cannot be set to invalid value {}, must be true or false", (Object)CONFIG_KEY, (Object)configValue);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{} set to {}", (Object)CONFIG_KEY, (Object)dispose.toString());
        }
        if (Boolean.TRUE.equals(dispose)) {
            Method cleaner;
            Method cleanerGetter;
            block11: {
                cleanerGetter = null;
                cleaner = null;
                try {
                    Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                    for (Method directBufferMethod : directBufferClass.getMethods()) {
                        if (directBufferMethod.isBridge() || directBufferMethod.isSynthetic() || !"cleaner".equals(directBufferMethod.getName()) || directBufferMethod.getParameterTypes().length != 0) continue;
                        Class<?> cleanerClass = directBufferMethod.getReturnType();
                        for (Method cleanerMethod : cleanerClass.getMethods()) {
                            if (cleanerMethod.isBridge() || cleanerMethod.isSynthetic() || !"clean".equals(cleanerMethod.getName()) || cleanerMethod.getReturnType() != Void.TYPE || cleanerMethod.getParameterTypes().length != 0) continue;
                            cleanerGetter = directBufferMethod;
                            cleaner = cleanerMethod;
                            break block11;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cleanerGetter == null) {
                LOG.warn("{} set to true, but cannot be actioned in the JVM", (Object)CONFIG_KEY);
                DIRECT_BUFFER_CLEANER = null;
                DIRECT_BUFFER_CLEANER_CLEAN = null;
            } else {
                DIRECT_BUFFER_CLEANER = cleanerGetter;
                DIRECT_BUFFER_CLEANER_CLEAN = cleaner;
            }
        } else {
            DIRECT_BUFFER_CLEANER = null;
            DIRECT_BUFFER_CLEANER_CLEAN = null;
        }
    }
}

