/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;

public class ShutdownSafeEhcacheManagerFactoryBean
extends EhCacheManagerFactoryBean {
    private static final Logger log = LoggerFactory.getLogger(ShutdownSafeEhcacheManagerFactoryBean.class);

    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("Shutdown in progress")) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring \"Shutdown in progress\" error.");
                }
            }
            throw e;
        }
    }
}

