/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.parameters.Filter;
import ome.parameters.Parameters;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;

public class QueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryBuilder.class);
    private int count = 0;
    private final StringBuilder select = new StringBuilder();
    private final StringBuilder from = new StringBuilder();
    private final StringBuilder join = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final StringBuilder order = new StringBuilder();
    private final StringBuilder group = new StringBuilder();
    private final Set<String> random = new HashSet<String>();
    private final Map<Integer, Object> seqParams = new HashMap<Integer, Object>();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final Map<String, Collection> listParams = new HashMap<String, Collection>();
    private StringBuilder current;
    private int whereCount = 0;
    private String self;
    private Filter filter;
    private String filterTarget;
    private boolean sqlQuery = false;

    public QueryBuilder() {
    }

    public QueryBuilder(boolean sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public QueryBuilder(int size) {
        this();
    }

    public String unique_alias(String prefix) {
        StringBuilder sb = new StringBuilder(prefix.length() + 8);
        sb.append(prefix.trim());
        while (this.random.contains(sb.toString())) {
            sb.append(this.count++);
        }
        String alias = sb.toString();
        this.random.add(alias);
        return alias;
    }

    public QueryBuilder append(String string) {
        this.current.append(string);
        return this;
    }

    public QueryBuilder select(String ... selects) {
        this._type("select");
        if (selects == null || selects.length == 0) {
            throw new ApiUsageException("Empty select");
        }
        for (int i = 0; i < selects.length; ++i) {
            if (i != 0) {
                this.select.append(", ");
            }
            this.select.append(selects[i]);
            this.appendSpace();
        }
        return this;
    }

    void _type(String type) {
        this.current = this.select;
        if (this.select.length() == 0) {
            this.select.append(type);
            this.appendSpace();
        }
    }

    public QueryBuilder from(String type, String alias) {
        this.current = this.from;
        if (this.from.length() == 0) {
            this.from.append("from ");
        } else {
            this.from.append(", ");
        }
        this.self = alias;
        this.from.append(type);
        this.appendSpace();
        this.from.append("as ");
        this.from.append(alias);
        this.appendSpace();
        return this;
    }

    public QueryBuilder join(String path, String alias, boolean outer, boolean fetch) {
        this.current = this.join;
        if (outer) {
            this.join.append("left outer ");
        }
        this.join.append("join ");
        if (fetch) {
            this.join.append("fetch ");
        }
        this.join.append(path);
        this.appendSpace();
        this.join.append("as ");
        this.join.append(alias);
        this.appendSpace();
        return this;
    }

    public QueryBuilder where() {
        this.current = this.where;
        if (this.where.length() == 0) {
            this.where.append("where ");
        }
        return this;
    }

    public QueryBuilder and(String str) {
        return this._where("and ", str);
    }

    public QueryBuilder or(String str) {
        return this._where("or ", str);
    }

    private QueryBuilder _where(String bool, String str) {
        this.where();
        ++this.whereCount;
        if (this.whereCount != 1) {
            this.where.append(bool);
        }
        this.where.append(str);
        this.appendSpace();
        return this;
    }

    public QueryBuilder subselect(QueryBuilder subselect) {
        if ("".equals(subselect.queryString().trim())) {
            return this;
        }
        this.current.append("(");
        this.current.append(subselect.queryString());
        this.current.append(")");
        for (String key : subselect.listParams.keySet()) {
            this.listParams.put(key, subselect.listParams.get(key));
        }
        this.appendSpace();
        return this;
    }

    public QueryBuilder order(String path, boolean ascending) {
        this.current = this.order;
        if (this.order.length() == 0) {
            this.order.append("order by ");
        } else {
            this.order.append(", ");
        }
        this.order.append(path);
        this.appendSpace();
        if (ascending) {
            this.order.append("asc ");
        } else {
            this.order.append("desc ");
        }
        return this;
    }

    public QueryBuilder param(int id, Object o) {
        this.seqParams.put(id, o);
        return this;
    }

    public QueryBuilder param(String key, Object o) {
        this.params.put(key, o);
        return this;
    }

    public QueryBuilder paramList(String key, Collection c) {
        this.listParams.put(key, c);
        return this;
    }

    public QueryBuilder filterNow() {
        if (this.filter != null && this.filterTarget != null) {
            String alias;
            if (this.filter.owner() >= 0L) {
                this.and(this.filterTarget + ".details.owner.id = ");
                alias = this.unique_alias("owner");
                this.append(":");
                this.append(alias);
                this.param(alias, (Object)this.filter.owner());
                this.appendSpace();
            }
            if (this.filter.group() >= 0L) {
                this.and(this.filterTarget + ".details.group.id = ");
                alias = this.unique_alias("group");
                this.append(":");
                this.append(alias);
                this.param(alias, (Object)this.filter.group());
                this.appendSpace();
            }
        }
        return this;
    }

    public Query queryWithoutFilter(Session session) {
        return this.__query(session, false);
    }

    public Query query(Session session) {
        return this.__query(session, true);
    }

    private Query __query(Session session, boolean usefilter) {
        Query q;
        block13: {
            if (usefilter) {
                this.filterNow();
            }
            q = null;
            try {
                String s = this.queryString();
                if (this.sqlQuery) {
                    if ((s.startsWith("update") || s.startsWith("delete")) && session instanceof Advised) {
                        Advised advised = (Advised)session;
                        try {
                            session = (Session)advised.getTargetSource().getTarget();
                        }
                        catch (Exception e) {
                            RuntimeException rt = new RuntimeException(e);
                            rt.initCause(e);
                            throw rt;
                        }
                    }
                    q = session.createSQLQuery(this.queryString());
                    break block13;
                }
                q = session.createQuery(this.queryString());
            }
            catch (RuntimeException rt) {
                log.warn("Failed query: " + this.queryString(), rt);
                throw rt;
            }
        }
        for (String string : this.params.keySet()) {
            q.setParameter(string, this.params.get(string));
        }
        for (Integer n : this.seqParams.keySet()) {
            q.setParameter(n.intValue(), this.seqParams.get(n));
        }
        for (String string : this.listParams.keySet()) {
            q.setParameterList(string, this.listParams.get(string));
        }
        if (this.filter != null) {
            if (this.filter.limit != null) {
                q.setMaxResults(this.filter.limit.intValue());
            }
            if (this.filter.offset != null) {
                q.setFirstResult(this.filter.offset.intValue());
            }
        }
        return q;
    }

    public QueryBuilder appendSpace() {
        if (this.current.length() == 0) {
            this.current.append(' ');
        } else if (this.current.charAt(this.current.length() - 1) != ' ') {
            this.current.append(' ');
        }
        return this;
    }

    public String queryString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.select.toString());
        sb.append(this.from.toString());
        sb.append(this.join.toString());
        sb.append(this.where.toString());
        sb.append(this.group.toString());
        sb.append(this.order.toString());
        return sb.toString();
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(this.queryString());
        toString.append(this.params);
        toString.append(this.seqParams);
        toString.append(this.listParams);
        return toString.toString();
    }

    public void update(String table) {
        this._type("update");
        this.select.append(table);
        this.appendSpace();
        this.skipFrom();
    }

    public void delete(String table) {
        if (this.sqlQuery) {
            this._type("delete from ");
        } else {
            this._type("delete");
        }
        this.select.append(table);
        this.appendSpace();
        this.skipFrom();
    }

    public QueryBuilder skipFrom() {
        this.current = this.from;
        this.appendSpace();
        return this;
    }

    public QueryBuilder skipWhere() {
        this.current = this.where;
        this.appendSpace();
        return this;
    }

    public QueryBuilder whereClause() {
        this.current = this.where;
        this.appendSpace();
        return this;
    }

    public void filter(String string, Filter filter) {
        this.filterTarget = string;
        this.filter = filter;
    }

    public void params(Parameters params2) {
        if (params2 != null) {
            for (String key : params2.keySet()) {
                Object o = params2.get((String)key).value;
                if (o instanceof Collection) {
                    this.paramList(key, (Collection)o);
                    continue;
                }
                this.param(key, o);
            }
        }
    }
}

