/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.StatefulServiceInterface;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.meta.Node;
import ome.model.meta.Session;
import ome.model.meta.Share;
import ome.security.ACLVoter;
import ome.security.basic.CurrentDetails;
import ome.system.EventContext;
import ome.tools.hibernate.SessionHandler;
import ome.util.ContextFilter;
import ome.util.Filterable;
import ome.util.Utils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Hibernate;
import org.hibernate.collection.AbstractPersistentCollection;

public class ProxyCleanupFilter
extends ContextFilter {
    protected Map unloadedObjectCache = new IdentityHashMap();
    protected final ACLVoter acl;
    protected final CurrentDetails current;

    public ProxyCleanupFilter() {
        this(null, null);
    }

    public ProxyCleanupFilter(ACLVoter acl, CurrentDetails current) {
        this.acl = acl;
        this.current = current;
    }

    @Override
    public Filterable filter(String fieldId, Filterable f) {
        if (f == null) {
            return null;
        }
        if (this.unloadedObjectCache.containsKey(f)) {
            return (IObject)this.unloadedObjectCache.get(f);
        }
        if (f instanceof Node) {
            return new Node(((Node)f).getId(), false);
        }
        if (!Hibernate.isInitialized((Object)f)) {
            if (f instanceof IObject) {
                IObject proxy = (IObject)f;
                IObject unloaded = Utils.trueInstance(f.getClass().asSubclass(IObject.class));
                unloaded.setId(proxy.getId());
                unloaded.unload();
                this.unloadedObjectCache.put(f, unloaded);
                return unloaded;
            }
            if (f instanceof Details) {
                Details d = (Details)f;
                d = (Details)super.filter(fieldId, d.shallowCopy());
                return d;
            }
            throw new RuntimeException("Bailing out. Don't want to set to a value to null.");
        }
        if (f instanceof IObject && this.acl != null) {
            this.acl.postProcess((IObject)f);
        }
        if (f instanceof Share) {
            Share share = (Share)f;
            if (!share.isLoaded()) {
                return share;
            }
            if (share.retrieve("#2733") == null) {
                return new Share(share.getId(), false);
            }
        } else if (f instanceof Session) {
            Session session = (Session)f;
            if (!session.isLoaded()) {
                return session;
            }
            if (this.acl == null) {
                return new Session(session.getId(), false);
            }
            EventContext ec = this.current.getCurrentEventContext();
            if (!ec.isCurrentUserAdmin()) {
                Long uid = session.getOwner().getId();
                if (!ec.getCurrentUserId().equals(uid)) {
                    return new Session(session.getId(), false);
                }
            }
        }
        return super.filter(fieldId, f);
    }

    @Override
    public Collection filter(String fieldId, Collection c) {
        if (null == c || !Hibernate.isInitialized((Object)c)) {
            return null;
        }
        AbstractCollection retVal = super.filter(fieldId, c);
        if (retVal instanceof AbstractPersistentCollection) {
            if (retVal instanceof Set) {
                retVal = new HashSet(retVal);
            } else if (retVal instanceof List) {
                retVal = new ArrayList(retVal);
            }
        }
        return retVal;
    }

    @Override
    public Map filter(String fieldId, Map m) {
        if (null == m || !Hibernate.isInitialized((Object)m)) {
            return null;
        }
        HashMap retVal = super.filter(fieldId, m);
        if (retVal instanceof AbstractPersistentCollection) {
            retVal = new HashMap(retVal);
        }
        return retVal;
    }

    @Override
    protected void doFilter(String arg0, Object arg1) {
        if (arg1 instanceof Object[]) {
            Object[] arr = (Object[])arg1;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.filter(arg0, arr[i]);
            }
        }
    }

    public static class Interceptor
    implements MethodInterceptor {
        private final SessionHandler sessions;
        private final ACLVoter acl;
        private final CurrentDetails current;
        private final ThreadLocal<Integer> depth = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        public Interceptor(ACLVoter acl, SessionHandler sessions, CurrentDetails current) {
            this.acl = acl;
            this.sessions = sessions;
            this.current = current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation arg0) throws Throwable {
            Object result;
            int d = this.depth.get();
            if (d == 0) {
                this.sessions.cleanThread();
            }
            this.depth.set(++d);
            try {
                result = arg0.proceed();
                if (!StatefulServiceInterface.class.isAssignableFrom(arg0.getThis().getClass())) {
                    result = new ProxyCleanupFilter(this.acl, this.current).filter(null, result);
                }
            }
            finally {
                this.depth.set(--d);
            }
            return result;
        }
    }
}

