/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.InternalException;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.tools.lsid.LsidUtils;
import org.hibernate.Hibernate;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HibernateUtils {
    private static Logger log = LoggerFactory.getLogger(HibernateUtils.class);
    private static String DETAILS = LsidUtils.parseField("ome.model.core.Image_details");

    public static boolean isUnloaded(Object original) {
        return original != null && original instanceof IObject && !((IObject)original).isLoaded();
    }

    public static Long nullSafeOwnerId(IObject iobject) {
        if (iobject == null) {
            return null;
        }
        if (iobject.getDetails() == null) {
            return null;
        }
        if (iobject.getDetails().getOwner() == null) {
            return null;
        }
        return iobject.getDetails().getOwner().getId();
    }

    public static Long nullSafeGroupId(IObject iobject) {
        if (iobject == null) {
            return null;
        }
        if (iobject.getDetails() == null) {
            return null;
        }
        if (iobject.getDetails().getGroup() == null) {
            return null;
        }
        return iobject.getDetails().getGroup().getId();
    }

    public static void fixNulledOrFilteredCollections(IObject entity, IObject target, EntityPersister persister, SessionImplementor source) {
        Object[] currentState = persister.getPropertyValues((Object)entity, source.getEntityMode());
        Object[] previousState = persister.getPropertyValues((Object)target, source.getEntityMode());
        String[] propertyNames = persister.getPropertyNames();
        Type[] types = persister.getPropertyTypes();
        int detailsIndex = HibernateUtils.detailsIndex(propertyNames);
        Details d = (Details)currentState[detailsIndex];
        if (d != null) {
            Set<String> s = d.filteredSet();
            for (String string : s) {
                int idx = HibernateUtils.index(string = LsidUtils.parseField(string), propertyNames);
                Object previous = previousState[idx];
                if (!(previous instanceof Collection)) {
                    throw new InternalException(String.format("Invalid collection found for filtered field %s in previous state for %s", string, entity));
                }
                HibernateUtils.log("Copying filtered collection ", string);
                Collection copy = HibernateUtils.copy((Collection)previous);
                persister.setPropertyValue((Object)entity, idx, (Object)copy, source.getEntityMode());
            }
        }
        for (int i = 0; i < types.length; ++i) {
            Object copy;
            Object previous;
            Type t = types[i];
            if (!t.isCollectionType() || null != currentState[i] || (previous = previousState[i]) == null) continue;
            if (previous instanceof Collection) {
                if (!Hibernate.isInitialized((Object)previous)) {
                    HibernateUtils.log("Skipping uninitialized collection: ", propertyNames[i]);
                    persister.setPropertyValue((Object)entity, i, previous, source.getEntityMode());
                    continue;
                }
                HibernateUtils.log("Copying nulled collection: ", propertyNames[i]);
                copy = HibernateUtils.copy((Collection)previous);
                persister.setPropertyValue((Object)entity, i, copy, source.getEntityMode());
                continue;
            }
            if (previous instanceof Map) {
                if (!Hibernate.isInitialized((Object)previous)) {
                    HibernateUtils.log("Skipping uninitialized map: ", propertyNames[i]);
                    persister.setPropertyValue((Object)entity, i, previous, source.getEntityMode());
                    continue;
                }
                copy = HibernateUtils.copy((Map)previous);
                persister.setPropertyValue((Object)entity, i, copy, source.getEntityMode());
                continue;
            }
            throw new InternalException(String.format("Invalid collection found for null field %s in previous state for %s", propertyNames[i], entity));
        }
    }

    public static boolean onlyPermissionsChanged(Details new_d, Details old_d) {
        return HibernateUtils.idEqual(new_d.getOwner(), old_d.getOwner()) && HibernateUtils.idEqual(new_d.getGroup(), old_d.getGroup()) && HibernateUtils.idEqual(new_d.getCreationEvent(), old_d.getCreationEvent()) && HibernateUtils.idEqual(new_d.getUpdateEvent(), old_d.getUpdateEvent()) && HibernateUtils.idEqual(new_d.getExternalInfo(), old_d.getExternalInfo());
    }

    public static boolean idEqual(IObject arg1, IObject arg2) {
        if (arg1 == null) {
            return arg2 == null;
        }
        if (arg2 == null) {
            return false;
        }
        if (arg1 == arg2) {
            return true;
        }
        Long arg1_id = arg1.getId();
        Long arg2_id = arg2.getId();
        if (arg1_id == null) {
            if (arg2_id == null) {
                return false;
            }
            return false;
        }
        if (arg2_id == null) {
            return false;
        }
        return arg1_id.equals(arg2_id);
    }

    public static Details getDetails(Object[] state, String[] names) {
        return (Details)state[HibernateUtils.detailsIndex(names)];
    }

    public static int detailsIndex(String[] propertyNames) {
        return HibernateUtils.index(DETAILS, propertyNames);
    }

    public static int index(String str, String[] propertyNames) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyNames[i].equals(str)) continue;
            return i;
        }
        throw new InternalException("No \"" + str + "\" property found.");
    }

    protected static Map copy(Map m) {
        HashMap newMap = new HashMap();
        newMap.putAll(m);
        return newMap;
    }

    protected static Collection copy(Collection c) {
        if (c instanceof Set) {
            return new HashSet(c);
        }
        if (c instanceof List) {
            return new ArrayList(c);
        }
        throw new InternalException("Unsupported collection type:" + c.getClass().getName());
    }

    private static void log(Object ... objects) {
        if (log.isDebugEnabled() && objects != null && objects.length > 0) {
            StringBuilder sb = new StringBuilder(objects.length * 16);
            for (Object obj : objects) {
                sb.append(obj.toString());
            }
            log.debug(sb.toString());
        }
    }
}

