/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.model.IAnnotated;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.tools.hibernate.QueryBuilder;
import ome.tools.spring.OnContextRefreshedEventListener;
import org.hibernate.EntityMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

public interface ExtendedMetadata {
    public Set<String> getClasses();

    public Set<Class<IAnnotated>> getAnnotatableTypes();

    public Set<Class<Annotation>> getAnnotationTypes();

    public String getCountQuery(String var1) throws ApiUsageException;

    public Class<IObject> getHibernateClass(String var1);

    public IObject[] getLockCandidates(IObject var1);

    public String[][] getLockCandidateChecks(Class<? extends IObject> var1, boolean var2);

    public String[][] getLockChecks(Class<? extends IObject> var1);

    public Map<String, Long> countLocks(Session var1, Long var2, String[][] var3, String var4);

    public String getRelationship(String var1, String var2);

    public String getSQLJoin(String var1, String var2, String var3, String var4);

    public boolean mayHaveMapProperties(Class<? extends IObject> var1);

    public Set<String> getMapProperties(String var1);

    public static class Immutables {
        String[] immutableFields;
        EntityPersister ep;

        Immutables(ClassMetadata metadata) {
            if (!(metadata instanceof EntityPersister)) {
                throw new IllegalArgumentException("Metadata passed to Immutables must be an instanceof EntityPersister, not " + (metadata == null ? null : metadata.getClass()));
            }
            this.ep = (EntityPersister)metadata;
            ArrayList<String> retVal = new ArrayList<String>();
            Type[] type = this.ep.getPropertyTypes();
            String[] name = this.ep.getPropertyNames();
            boolean[] up = this.ep.getPropertyUpdateability();
            for (int i = 0; i < type.length; ++i) {
                if (!up[i]) {
                    retVal.add(name[i]);
                    continue;
                }
                if (!type[i].isComponentType() || !((ComponentType)type[i]).isEmbedded()) continue;
                EmbeddedComponentType embedded = (EmbeddedComponentType)type[i];
                String[] sub_name = embedded.getPropertyNames();
                Type[] sub_type = embedded.getSubtypes();
                ArrayList name_list = new ArrayList();
                ArrayList type_list = new ArrayList();
                for (int j = 0; j < sub_type.length; ++j) {
                }
            }
            this.immutableFields = retVal.toArray(new String[retVal.size()]);
        }

        public String[] getImmutableFields() {
            return this.immutableFields;
        }
    }

    public static class Locks {
        private final ClassMetadata cm;
        private final int size;
        private int total = 0;
        private final boolean[] include;
        private final String[][] subnames;
        private final Type[][] subtypes;
        private final String[][] checks;
        private final String[][] groupChecks;

        Locks(ClassMetadata classMetadata) {
            this.cm = classMetadata;
            String[] name = this.cm.getPropertyNames();
            Type[] type = this.cm.getPropertyTypes();
            ArrayList<String[]> checks = new ArrayList<String[]>();
            ArrayList<String[]> groupChecks = new ArrayList<String[]>();
            this.size = type.length;
            this.include = new boolean[this.size];
            this.subnames = new String[this.size][];
            this.subtypes = new Type[this.size][];
            for (int i = 0; i < type.length; ++i) {
                if (type[i].isComponentType() && ((ComponentType)type[i]).isEmbedded()) {
                    EmbeddedComponentType embedded = (EmbeddedComponentType)type[i];
                    String[] sub_name = embedded.getPropertyNames();
                    Type[] sub_type = embedded.getSubtypes();
                    ArrayList<String> name_list = new ArrayList<String>();
                    ArrayList<Type> type_list = new ArrayList<Type>();
                    for (int j = 0; j < sub_type.length; ++j) {
                        if (!IObject.class.isAssignableFrom(sub_type[j].getReturnedClass())) continue;
                        String path = name[i] + "." + sub_name[j];
                        name_list.add(path);
                        type_list.add(sub_type[j]);
                        this.addCheck(checks, groupChecks, sub_type[j].getReturnedClass(), path);
                    }
                    this.add(i, name_list.toArray(new String[name_list.size()]), type_list.toArray(new Type[type_list.size()]));
                    continue;
                }
                if (!IObject.class.isAssignableFrom(type[i].getReturnedClass())) continue;
                this.add(i);
                this.addCheck(checks, groupChecks, type[i].getReturnedClass(), name[i]);
            }
            this.checks = (String[][])checks.toArray((T[])new String[checks.size()][]);
            this.groupChecks = (String[][])groupChecks.toArray((T[])new String[groupChecks.size()][]);
        }

        private void addCheck(List<String[]> checks, List<String[]> groupChecks, Class type, String field) {
            String[] s = new String[]{type.getName(), field};
            checks.add(s);
            if (!IGlobal.class.isAssignableFrom(type)) {
                groupChecks.add(s);
            }
        }

        private void add(int i) {
            if (i >= this.size) {
                throw new IllegalArgumentException("size");
            }
            if (this.include[i]) {
                throw new IllegalStateException("set");
            }
            this.include[i] = true;
            this.subnames[i] = new String[0];
            this.subtypes[i] = new Type[0];
            ++this.total;
        }

        private void add(int i, String[] paths, Type[] types) {
            if (i >= this.size) {
                throw new IllegalArgumentException("size");
            }
            if (paths == null) {
                throw new IllegalArgumentException("paths");
            }
            if (types == null) {
                throw new IllegalArgumentException("types");
            }
            if (paths.length != types.length) {
                throw new IllegalStateException("size");
            }
            if (this.include[i]) {
                throw new IllegalStateException("set");
            }
            if (paths.length > 0) {
                this.include[i] = true;
                this.subnames[i] = paths;
                this.subtypes[i] = types;
                this.total += paths.length;
            }
        }

        public void fillRelationships(SessionFactoryImplementor sfi, Map<String, Relationship> value) {
            Type[] types = this.cm.getPropertyTypes();
            for (int t = 0; t < types.length; ++t) {
                Type type = types[t];
                String name = type.getName();
                String to = null;
                Relationship field = null;
                if (type instanceof EntityType) {
                    EntityType entType = (EntityType)type;
                    to = entType.getAssociatedEntityName();
                    field = new Relationship(this.cm.getPropertyNames()[t], false);
                } else if (types[t] instanceof CollectionType) {
                    CollectionType colType = (CollectionType)types[t];
                    Type elemType = colType.getElementType(sfi);
                    if (!elemType.isEntityType()) continue;
                    to = elemType.getName();
                    int open = name.indexOf("(");
                    int close = name.lastIndexOf(")");
                    String role = name.substring(open + 1, close);
                    int dot = role.lastIndexOf(".");
                    field = new Relationship(role.substring(dot + 1), true);
                }
                if (to == null || field == null) continue;
                Map m = sfi.getAllClassMetadata();
                for (Class c : Impl.hierarchy(m, to)) {
                    value.put(c.getName(), field);
                }
            }
        }

        public IObject[] getLockCandidates(IObject o) {
            int idx = 0;
            IObject[] toCheck = new IObject[this.total()];
            Object[] values = this.cm.getPropertyValues((Object)o, EntityMode.POJO);
            for (int i = 0; i < this.size(); ++i) {
                if (!this.include(i)) continue;
                if (this.hasSubtypes(i)) {
                    for (int j = 0; j < this.numberOfSubtypes(i); ++j) {
                        Object value = this.getSubtypeValue(i, j, o);
                        if (value == null) continue;
                        toCheck[idx++] = (IObject)value;
                    }
                    continue;
                }
                if (values[i] == null) continue;
                toCheck[idx++] = (IObject)values[i];
            }
            IObject[] retVal = new IObject[idx];
            System.arraycopy(toCheck, 0, retVal, 0, idx);
            return retVal;
        }

        public String[][] getLockCandidateChecks(boolean onlyWithGroups) {
            if (onlyWithGroups) {
                return this.groupChecks;
            }
            return this.checks;
        }

        public int size() {
            return this.size;
        }

        public int total() {
            return this.total;
        }

        public boolean include(int i) {
            return this.include[i];
        }

        public boolean hasSubtypes(int i) {
            return this.include(i) && this.subtypes[i].length > 0;
        }

        public int numberOfSubtypes(int i) {
            return this.hasSubtypes(i) ? this.subtypes[i].length : 0;
        }

        public Object getSubtypeValue(int i, int j, Object o) {
            return this.cm.getPropertyValue(o, this.subnames[i][j], EntityMode.POJO);
        }

        public boolean subtypeEquals(int i, int j, String klass) {
            return klass.equals(this.subtypes[i][j].getReturnedClass().getName());
        }

        public String subtypeName(int i, int j) {
            return this.subnames[i][j];
        }
    }

    public static class Relationship {
        private final String relationshipName;
        private final boolean collection;

        Relationship(String name, boolean collection) {
            this.relationshipName = name;
            this.collection = collection;
        }
    }

    public static class Impl
    extends OnContextRefreshedEventListener
    implements ExtendedMetadata {
        private static final Logger log = LoggerFactory.getLogger(ExtendedMetadata.class);
        private final Map<String, Locks> locksHolder = new HashMap<String, Locks>();
        private final Map<String, String[][]> lockedByHolder = new HashMap<String, String[][]>();
        private final Map<String, Immutables> immutablesHolder = new HashMap<String, Immutables>();
        private final Map<String, String> collectionCountHolder = new HashMap<String, String>();
        private final Map<String, Class<IObject>> targetHolder = new HashMap<String, Class<IObject>>();
        private final Set<Class<IAnnotated>> annotatableTypes = new HashSet<Class<IAnnotated>>();
        private final Set<Class<Annotation>> annotationTypes = new HashSet<Class<Annotation>>();
        private final Map<String, Map<String, Relationship>> relationships = new HashMap<String, Map<String, Relationship>>();
        private final Map<String, Class<IObject>> hibernateClasses = new HashMap<String, Class<IObject>>();
        private final Set<Class<?>> mapPropertyClasses = new HashSet();
        private final SetMultimap<String, String> mapProperties = HashMultimap.create();
        private boolean initialized = false;
        private static final String field_msg = " is not a valid field for counting. Make sure you use the single-valued (e.g. ImageAnnotation.IMAGE) and not the collection-valued (e.g. Image.ANNOTATIONS) end.";

        @Override
        public void handleContextRefreshedEvent(ContextRefreshedEvent cre) {
            ApplicationContext ctx = cre.getApplicationContext();
            if (ctx.containsBean("sessionFactory")) {
                SessionFactory sessionFactory = (SessionFactory)ctx.getBean("sessionFactory");
                this.setSessionFactory(sessionFactory);
            } else {
                log.warn("No session factory found. Cannot initialize");
            }
        }

        public void setSessionFactory(SessionFactory sessionFactory) {
            ClassMetadata cm;
            if (this.initialized) {
                return;
            }
            log.info("Calculating ExtendedMetadata...");
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            Map m = sessionFactory.getAllClassMetadata();
            for (String string : m.keySet()) {
                ClassMetadata cm2 = (ClassMetadata)m.get(string);
                this.locksHolder.put(string, new Locks(cm2));
            }
            for (String string : m.keySet()) {
                this.lockedByHolder.put(string, this.lockedByFields(string, m));
            }
            for (String string : m.keySet()) {
                ClassMetadata cm2 = (ClassMetadata)m.get(string);
                this.immutablesHolder.put(string, new Immutables(cm2));
            }
            for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                cm = (ClassMetadata)entry.getValue();
                if (this.hibernateClasses.containsKey(key = key.substring(key.lastIndexOf(".") + 1).toLowerCase())) {
                    throw new RuntimeException("Duplicate keys!: " + key);
                }
                this.hibernateClasses.put(key, cm.getMappedClass(EntityMode.POJO));
            }
            for (String string : m.keySet()) {
                boolean bl;
                HashMap<String, Relationship> value = new HashMap<String, Relationship>();
                cm = (ClassMetadata)m.get(string);
                for (Class<?> clazz : Impl.hierarchy(m, string)) {
                    Locks locks = this.locksHolder.get(clazz.getName());
                    locks.fillRelationships(sfi, value);
                }
                HashMap value2 = new HashMap();
                for (Map.Entry i : value.entrySet()) {
                    String k = (String)i.getKey();
                    k = k.substring(k.lastIndexOf(".") + 1);
                    value2.put(k, i.getValue());
                }
                this.relationships.put(string.substring(string.lastIndexOf(".") + 1), value2);
                boolean bl2 = false;
                String[] propertyNames = cm.getPropertyNames();
                Type[] propertyTypes = cm.getPropertyTypes();
                for (int i = 0; i < propertyNames.length; ++i) {
                    CollectionType propertyType;
                    Type elementType;
                    if (!(propertyTypes[i] instanceof CollectionType) || Map.class != propertyTypes[i].getReturnedClass() || String.class != (elementType = (propertyType = (CollectionType)propertyTypes[i]).getElementType((SessionFactoryImplementor)sessionFactory)).getReturnedClass()) continue;
                    this.mapProperties.put(string, propertyNames[i]);
                    bl = true;
                }
                if (!bl) continue;
                for (Class mc = cm.getMappedClass(EntityMode.POJO); mc != null; mc = mc.getSuperclass()) {
                    this.mapPropertyClasses.add(mc);
                }
            }
            HashSet<Class> anns = new HashSet<Class>();
            HashSet<Class> hashSet = new HashSet<Class>();
            for (String key : m.keySet()) {
                ClassMetadata cm3 = (ClassMetadata)m.get(key);
                Map<String, String> map = this.countQueriesAndEditTargets(key, this.lockedByHolder.get(key));
                this.collectionCountHolder.putAll(map);
                Class c = cm3.getMappedClass(EntityMode.POJO);
                if (IAnnotated.class.isAssignableFrom(c)) {
                    anns.add(c);
                }
                if (!Annotation.class.isAssignableFrom(c)) continue;
                hashSet.add(c);
            }
            this.annotatableTypes.addAll(anns);
            this.annotationTypes.addAll(hashSet);
            this.initialized = true;
        }

        @Override
        public Set<String> getClasses() {
            return this.locksHolder.keySet();
        }

        @Override
        public Class<IObject> getHibernateClass(String table) {
            int idx = table.lastIndexOf(".");
            if (idx > 0) {
                table = table.substring(idx + 1);
            }
            table = table.toLowerCase();
            return this.hibernateClasses.get(table);
        }

        private Relationship _getRelationship(String from, String to) {
            Map<String, Relationship> m = this.relationships.get(from);
            if (m != null) {
                return m.get(to);
            }
            return null;
        }

        @Override
        public String getRelationship(String from, String to) {
            Relationship r = this._getRelationship(from, to);
            if (r != null) {
                return r.relationshipName;
            }
            return null;
        }

        @Override
        public String getSQLJoin(String fromType, String fromAlias, String toType, String toAlias) {
            String fromPath = "UNKNOWN";
            String toPath = "UNKNOWN";
            Relationship fromRel = this._getRelationship(fromType, toType);
            Relationship toRel = this._getRelationship(toType, fromType);
            if (fromRel != null && !fromRel.collection) {
                fromPath = fromRel.relationshipName;
                toPath = "id";
            } else if (toRel != null && !toRel.collection) {
                toPath = toRel.relationshipName;
                fromPath = "id";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("fromType=");
                sb.append(fromType);
                sb.append(";toType=");
                sb.append(toType);
                throw new InternalException("Unhandled SQL Join! -- " + sb);
            }
            return String.format("%s.%s = %s.%s", fromAlias, fromPath, toAlias, toPath);
        }

        @Override
        public Set<Class<IAnnotated>> getAnnotatableTypes() {
            return Collections.unmodifiableSet(this.annotatableTypes);
        }

        @Override
        public Set<Class<Annotation>> getAnnotationTypes() {
            return Collections.unmodifiableSet(this.annotationTypes);
        }

        @Override
        public IObject[] getLockCandidates(IObject iObject) {
            if (iObject == null) {
                return new IObject[0];
            }
            Locks l = this.locksHolder.get(iObject.getClass().getName());
            return l.getLockCandidates(iObject);
        }

        @Override
        public String[][] getLockCandidateChecks(Class<? extends IObject> k, boolean onlyWithGroups) {
            Locks l = this.locksHolder.get(k.getName());
            return l.getLockCandidateChecks(onlyWithGroups);
        }

        @Override
        public String[][] getLockChecks(Class<? extends IObject> klass) {
            if (klass == null) {
                throw new ApiUsageException("Cannot proceed with null klass.");
            }
            String[][] checks = this.lockedByHolder.get(klass.getName());
            if (checks == null) {
                throw new ApiUsageException("Metadata not found for: " + klass.getName());
            }
            return checks;
        }

        @Override
        public Map<String, Long> countLocks(Session session, Long id, String[][] checks, String clause) {
            QueryBuilder qb = new QueryBuilder();
            qb.select("count(x.id)");
            qb.from("%s", "x");
            if (id == null) {
                qb.join("x.%s", "y", false, false);
            }
            if (id != null) {
                qb.where();
                qb.and("%s.id = :id");
            }
            if (clause != null && clause.length() > 0) {
                qb.where();
                qb.and(clause);
                qb.appendSpace();
            }
            String queryString = qb.queryString();
            HashMap<String, Long> counts = new HashMap<String, Long>();
            long total = 0L;
            for (String[] check : checks) {
                Long count;
                String hql = String.format(queryString, check[0], check[1]);
                Query q = session.createQuery(hql);
                if (id != null) {
                    q.setLong("id", id.longValue());
                }
                if ((count = (Long)q.uniqueResult()) == null || count <= 0L) continue;
                total += count.longValue();
                counts.put(check[0], count);
            }
            counts.put("*", total);
            return counts;
        }

        public String[] getImmutableFields(Class<? extends IObject> klass) {
            if (klass == null) {
                throw new ApiUsageException("Cannot proceed with null klass.");
            }
            Immutables i = this.immutablesHolder.get(klass.getName());
            return i.getImmutableFields();
        }

        @Override
        public String getCountQuery(String field) throws ApiUsageException {
            String q = this.collectionCountHolder.get(field);
            if (q == null) {
                throw new ApiUsageException(field + field_msg);
            }
            return q;
        }

        public Class<IObject> getTargetType(String field) throws ApiUsageException {
            Class<IObject> k = this.targetHolder.get(field);
            if (k == null) {
                throw new ApiUsageException(field + field_msg);
            }
            return k;
        }

        @Override
        public boolean mayHaveMapProperties(Class<? extends IObject> iObjectClass) {
            return this.mapPropertyClasses.contains(iObjectClass);
        }

        @Override
        public Set<String> getMapProperties(String className) {
            return this.mapProperties.get(className);
        }

        private String[][] lockedByFields(String klass, Map<String, ClassMetadata> m) {
            if (m == null) {
                throw new InternalException("ClassMetadata map cannot be null.");
            }
            ArrayList<String[]> fields = new ArrayList<String[]>();
            for (String k : m.keySet()) {
                ClassMetadata cm = m.get(k);
                Type[] type = cm.getPropertyTypes();
                String[] names = cm.getPropertyNames();
                Locks inverse = this.locksHolder.get(k);
                for (int i = 0; i < inverse.size(); ++i) {
                    if (!inverse.include(i)) continue;
                    if (inverse.hasSubtypes(i)) {
                        for (int j = 0; j < inverse.numberOfSubtypes(i); ++j) {
                            if (!inverse.subtypeEquals(i, j, klass)) continue;
                            fields.add(new String[]{k, inverse.subtypeName(i, j)});
                        }
                        continue;
                    }
                    if (!klass.equals(type[i].getReturnedClass().getName())) continue;
                    fields.add(new String[]{k, names[i]});
                }
            }
            return (String[][])fields.toArray((T[])new String[fields.size()][2]);
        }

        private Map<String, String> countQueriesAndEditTargets(String type, String[][] lockedBy) {
            HashMap<String, String> queries = new HashMap<String, String>();
            for (int t = 0; t < lockedBy.length; ++t) {
                String ltype = lockedBy[t][0];
                String lfield = lockedBy[t][1];
                String field_description = String.format("%s_%s", ltype, lfield);
                queries.put(field_description, String.format("select target.%s.id, count(target) from %s target group by target.%s.id", lfield, ltype, lfield));
                try {
                    this.targetHolder.put(field_description, Class.forName(type));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error getting class: " + ltype, e);
                }
            }
            return queries;
        }

        private static List<Class<?>> hierarchy(Map<String, ClassMetadata> m, String key) {
            ArrayList h = new ArrayList();
            ClassMetadata cm = m.get(key);
            Class c = cm.getMappedClass(EntityMode.POJO);
            h.add(c);
            for (int index = 0; index < h.size(); ++index) {
                for (String key2 : m.keySet()) {
                    if (key.equals(key2) || !(c = (cm = m.get(key2)).getMappedClass(EntityMode.POJO)).getSuperclass().equals(h.get(index))) continue;
                    h.add(c);
                }
            }
            return h;
        }
    }
}

