/*
 * Decompiled with CFR 0.152.
 */
package ome.tools;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.util.CBlock;

public class HierarchyTransformations {
    public static <T extends IObject> Set<T> invertPDI(Set<Image> imagesAll, CBlock<T> block) {
        HashSet<IMutable> cleared = new HashSet<IMutable>();
        HashSet<IMutable> hierarchies = new HashSet<IMutable>();
        Iterator<Image> i = imagesAll.iterator();
        while (i.hasNext()) {
            Image img = (Image)block.call(i.next());
            List<Dataset> d_list = img.linkedDatasetList();
            Iterator<Dataset> d = d_list.iterator();
            if (!d.hasNext()) {
                hierarchies.add(img);
                continue;
            }
            while (d.hasNext()) {
                Dataset ds = (Dataset)block.call(d.next());
                if (!cleared.contains(ds)) {
                    ds.putAt("ome.model.containers.Dataset_imageLinks", new HashSet());
                    cleared.add(ds);
                }
                ds.linkImage(img);
                List<Project> p_list = ds.linkedProjectList();
                Iterator<Project> p = p_list.iterator();
                if (!p.hasNext()) {
                    hierarchies.add(ds);
                    continue;
                }
                while (p.hasNext()) {
                    Project prj = (Project)block.call(p.next());
                    if (!cleared.contains(prj)) {
                        prj.putAt("ome.model.containers.Project_datasetLinks", new HashSet());
                        cleared.add(prj);
                    }
                    prj.linkDataset(ds);
                    hierarchies.add(prj);
                }
            }
        }
        return hierarchies;
    }
}

