/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import com.google.common.base.Predicate;
import java.io.Serializable;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;

public final class Roles
implements Serializable {
    private static final long serialVersionUID = -2488864989534638213L;
    public final Predicate<Experimenter> IS_ROOT_USER = new Predicate<Experimenter>(){

        @Override
        public boolean apply(Experimenter experimenter) {
            return Roles.this.isRootUser(experimenter);
        }
    };
    public final Predicate<ExperimenterGroup> IS_USER_GROUP = new Predicate<ExperimenterGroup>(){

        @Override
        public boolean apply(ExperimenterGroup group) {
            return Roles.this.isUserGroup(group);
        }
    };
    public final Predicate<ExperimenterGroup> IS_SYSTEM_GROUP = new Predicate<ExperimenterGroup>(){

        @Override
        public boolean apply(ExperimenterGroup group) {
            return Roles.this.isSystemGroup(group);
        }
    };
    private final long rId;
    private final String rName;
    private final long sgId;
    private final String sgName;
    private final long ugId;
    private final String ugName;
    private final long guestId;
    private final String guestName;
    private final long ggId;
    private final String ggName;

    public Roles() {
        long nextUserId = 0L;
        long nextGroupId = 0L;
        this.rId = nextUserId++;
        this.rName = "root";
        this.sgId = nextGroupId++;
        this.sgName = "system";
        this.ugId = nextGroupId++;
        this.ugName = "user";
        this.guestId = nextUserId++;
        this.guestName = "guest";
        this.ggId = nextGroupId++;
        this.ggName = "guest";
    }

    public Roles(long rootUserId, String rootUserName, long systemGroupId, String systemGroupName, long userGroupId, String userGroupName, long guestUserId, String guestUserName, long guestGroupId, String guestGroupName) {
        this.rId = rootUserId;
        this.rName = rootUserName;
        this.sgId = systemGroupId;
        this.sgName = systemGroupName;
        this.ugId = userGroupId;
        this.ugName = userGroupName;
        this.guestId = guestUserId;
        this.guestName = guestUserName;
        this.ggId = guestGroupId;
        this.ggName = guestGroupName;
    }

    public boolean isRootUser(Experimenter user) {
        return user == null || user.getId() == null ? false : user.getId().equals(this.getRootId());
    }

    public boolean isUserGroup(ExperimenterGroup group) {
        return group == null || group.getId() == null ? false : group.getId().equals(this.getUserGroupId());
    }

    public boolean isSystemGroup(ExperimenterGroup group) {
        return group == null || group.getId() == null ? false : group.getId().equals(this.getSystemGroupId());
    }

    public long getRootId() {
        return this.rId;
    }

    public String getRootName() {
        return this.rName;
    }

    public long getGuestId() {
        return this.guestId;
    }

    public String getGuestName() {
        return this.guestName;
    }

    public long getSystemGroupId() {
        return this.sgId;
    }

    public String getSystemGroupName() {
        return this.sgName;
    }

    public long getUserGroupId() {
        return this.ugId;
    }

    public String getUserGroupName() {
        return this.ugName;
    }

    public long getGuestGroupId() {
        return this.ggId;
    }

    public String getGuestGroupName() {
        return this.ggName;
    }
}

