/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import ome.system.EventContext;
import ome.system.Preference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.PropertyPlaceholderHelper;

public class PreferenceContext
extends PropertyPlaceholderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(PreferenceContext.class);
    private final Map<String, Preference> preferences = new MapMaker().makeMap();
    private PropertyPlaceholderHelper helper;

    public PreferenceContext() {
        this.setSystemPropertiesMode(2);
        this.setIgnoreResourceNotFound(true);
        this.helper = new PropertyPlaceholderHelper("${", "}", ":", false);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory bf) {
        super.postProcessBeanFactory(bf);
        try {
            log.info("Publishing system properties...");
            Properties properties = this.mergeProperties();
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String key = names.nextElement().toString();
                String value = properties.getProperty(key);
                if (System.getProperty(key) != null) continue;
                System.setProperty(key, value);
                log.debug("Set property: {}={}", (Object)key, (Object)value);
            }
        }
        catch (IOException ioe) {
            log.error("Error on mergeProperties()", ioe);
            throw new FatalBeanException("Error on mergeProperties()", (Throwable)ioe);
        }
    }

    public String getProperty(String key) {
        try {
            key = "${" + key + "}";
            return this.helper.replacePlaceholders(key, new PropertyPlaceholderConfigurerResolver(this.mergeProperties()));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        catch (BeanDefinitionStoreException bdse) {
            return null;
        }
        catch (IOException e) {
            log.error("Error on mergeProperties()", e);
            return null;
        }
        catch (Exception exc) {
            log.error("Other exception on getProperty", exc);
            return null;
        }
    }

    public void setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void setPreferences(List<Preference> preferences) {
        for (Preference pref : preferences) {
            this.preferences.put(pref.getName(), pref);
        }
    }

    public String resolveAlias(String key) {
        if (this.preferences.containsKey(key)) {
            return key;
        }
        for (String current : this.preferences.keySet()) {
            Preference preference = this.preferences.get(current);
            if (!preference.hasAlias(key)) continue;
            return current;
        }
        return key;
    }

    public Set<String> getKeySet() {
        return this.preferences.keySet();
    }

    public boolean checkDatabase(String key) {
        Preference preference = this.getPreferenceOrDefault(key);
        return preference.isDb();
    }

    public boolean canRead(EventContext ec, String key) {
        Preference preference = this.getPreferenceOrDefault(key);
        switch (preference.getVisibility()) {
            case all: {
                return true;
            }
            case admin: {
                return ec.isCurrentUserAdmin();
            }
        }
        return false;
    }

    private Preference getPreferenceOrDefault(String key) {
        Preference preference = this.preferences.get(key);
        if (preference == null) {
            preference = new Preference();
        }
        return preference;
    }

    private class PropertyPlaceholderConfigurerResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Properties props;

        private PropertyPlaceholderConfigurerResolver(Properties props) {
            this.props = props;
        }

        @Override
        public String resolvePlaceholder(String placeholderName) {
            return PreferenceContext.this.resolvePlaceholder(placeholderName, this.props, 2);
        }
    }
}

