/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.conditions.SessionException;
import ome.model.meta.Session;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class ExecutionThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExecutionThread.class);
    protected final SessionManager manager;
    protected final Executor executor;
    protected final Executor.Work work;
    protected final Principal principal;
    private Principal sessionPrincipal = null;
    private Session session = null;

    public ExecutionThread(SessionManager manager, Executor executor, Executor.Work work, Principal principal) {
        Assert.notNull(manager);
        Assert.notNull(executor);
        Assert.notNull(work);
        Assert.notNull(principal);
        this.manager = manager;
        this.executor = executor;
        this.work = work;
        this.principal = principal;
    }

    @Override
    public final void run() {
        this.sessionInit();
        this.doRun();
    }

    public final Principal getPrincipal() {
        return this.sessionPrincipal;
    }

    public abstract void doRun();

    protected final void sessionInit() {
        if (this.sessionPrincipal != null) {
            try {
                this.manager.getEventContext(this.sessionPrincipal);
            }
            catch (SessionException e) {
                this.sessionPrincipal = null;
            }
        }
        if (this.sessionPrincipal == null) {
            this.session = this.manager.createWithAgent(this.principal, "ExecutionThread", null);
            this.sessionPrincipal = new Principal(this.session.getUuid(), this.principal.getGroup(), this.principal.getEventType());
        }
    }
}

