/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ome.model.IEnum;
import ome.model.IGlobal;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class EnsureEnum {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnsureEnum.class);
    private final Executor executor;
    private final Principal principal;
    private final Map<String, String> callContext;

    public EnsureEnum(Executor executor, String uuid, Roles roles) {
        this.executor = executor;
        this.principal = new Principal(uuid, roles.getSystemGroupName(), "Internal");
        this.callContext = ImmutableMap.of("omero.group", Long.toString(roles.getUserGroupId()));
    }

    private <E extends IEnum & IGlobal> Long ensure(Session session, Class<E> enumClass, String enumValue) {
        IEnum instance = (IEnum)session.createCriteria(enumClass).add((Criterion)Restrictions.eq((String)"value", (Object)enumValue)).uniqueResult();
        if (instance != null) {
            return instance.getId();
        }
        String prettyEnum = enumClass.getSimpleName() + '.' + enumValue;
        try {
            instance = (IEnum)enumClass.getConstructor(String.class).newInstance(enumValue);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            LOGGER.error("failed to create enumeration value " + prettyEnum, e);
            return null;
        }
        LOGGER.info("adding to database new enumeration value " + prettyEnum);
        return (Long)session.save((Object)instance);
    }

    public <E extends IEnum & IGlobal> List<Long> ensure(final Class<E> enumClass, final Collection<String> enumValues) {
        if (enumValues.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.executor.execute(this.callContext, this.principal, new Executor.Work<List<Long>>(){

            @Override
            public String description() {
                return "ensure enum values";
            }

            @Override
            @Transactional(readOnly=false)
            public List<Long> doWork(Session session, ServiceFactory sf) {
                ArrayList<Long> enumIds = new ArrayList<Long>(enumValues.size());
                for (String enumValue : enumValues) {
                    enumIds.add(EnsureEnum.this.ensure(session, enumClass, enumValue));
                }
                return enumIds;
            }
        });
    }
}

