/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import ome.system.PreferenceContext;
import ome.system.Roles;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUserCheck {
    public static final Logger log = LoggerFactory.getLogger(DBUserCheck.class);
    private final SqlAction sql;
    private final PreferenceContext prefs;
    private final Roles roles;

    public DBUserCheck(SqlAction sql, PreferenceContext prefs) throws Exception {
        this.sql = sql;
        this.prefs = prefs;
        this.roles = this.load();
    }

    private String getRoleName(String which, String defaultValue) {
        String rv;
        try {
            rv = this.prefs.getProperty("omero.roles." + which);
        }
        catch (Exception e) {
            rv = null;
        }
        if (rv == null) {
            return defaultValue;
        }
        return rv;
    }

    public Roles getRoles() {
        return this.roles;
    }

    public Roles load() throws Exception {
        Long guestGroupID;
        Long sysGroupID;
        String userGroup = this.getRoleName("group.user", "user");
        String sysGroup = this.getRoleName("group.system", "system");
        String guestGroup = this.getRoleName("group.guest", "guest");
        String guestUser = this.getRoleName("user.guest", "guest");
        String rootUser = this.getRoleName("user.root", "root");
        Long rootUserID = -1L;
        try {
            rootUserID = this.sql.getUserId(rootUser);
        }
        catch (Exception e) {
            log.debug("No root user found", e);
        }
        Long guestUserID = -1L;
        try {
            guestUserID = this.sql.getUserId(guestUser);
        }
        catch (Exception e) {
            log.debug("No guest user found", e);
        }
        Map<String, Long> groupIDs = this.sql.getGroupIds(new HashSet<String>(Arrays.asList(userGroup, sysGroup, guestGroup)));
        Long userGroupID = groupIDs.get(userGroup);
        if (userGroupID == null) {
            userGroupID = -1L;
        }
        if ((sysGroupID = groupIDs.get(sysGroup)) == null) {
            sysGroupID = -1L;
        }
        if ((guestGroupID = groupIDs.get(guestGroup)) == null) {
            guestGroupID = -1L;
        }
        log.info("User {}.id = {}", (Object)rootUser, (Object)rootUserID);
        log.info("User {}.id = {}", (Object)guestUser, (Object)guestUserID);
        log.info("Group {}.id = {}", (Object)sysGroup, (Object)sysGroupID);
        log.info("Group {}.id = {}", (Object)userGroup, (Object)userGroupID);
        log.info("Group {}.id = {}", (Object)guestGroup, (Object)guestGroupID);
        return new Roles(rootUserID, rootUser, sysGroupID, sysGroup, userGroupID, userGroup, guestUserID, guestUser, guestGroupID, guestGroup);
    }
}

