/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.conditions.InternalException;
import ome.services.util.BaseDBCheck;
import ome.services.util.Executor;
import ome.system.PreferenceContext;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DBUnicodeUnitsCheck
extends BaseDBCheck {
    public static final Logger LOGGER = LoggerFactory.getLogger(DBUnicodeUnitsCheck.class);

    protected DBUnicodeUnitsCheck(Executor executor, PreferenceContext preferences) {
        super(executor, preferences);
    }

    @Override
    protected void doCheck() {
        boolean hasUnicodeUnits;
        try {
            hasUnicodeUnits = (Boolean)this.executor.executeSql(new Executor.SimpleSqlWork(this, "DBUnicodeUnitsCheck", new Object[0]){

                @Override
                @Transactional(readOnly=true)
                public Boolean doWork(SqlAction sql) {
                    return sql.hasUnicodeUnits();
                }
            });
        }
        catch (Exception e) {
            String message = "Error while checking the encoding of units of measure.";
            LOGGER.error("Error while checking the encoding of units of measure.", e);
            throw new InternalException("Error while checking the encoding of units of measure.");
        }
        if (!hasUnicodeUnits) {
            String message = "Database does not contain correctly encoded units of measure.";
            LOGGER.error("Database does not contain correctly encoded units of measure.");
            throw new InternalException("Database does not contain correctly encoded units of measure.");
        }
        LOGGER.info("Database has the correctly encoded units of measure.");
    }
}

