/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import ome.model.IEnum;
import ome.model.IGlobal;
import ome.services.util.BaseDBCheck;
import ome.services.util.EnsureEnum;
import ome.services.util.Executor;
import ome.system.PreferenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class DBMappedEnumCheck
extends BaseDBCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBMappedEnumCheck.class);
    private static final Pattern ENUMERATION_PATTERN = Pattern.compile("(ome\\.model\\.enums\\.[A-Za-z\\.]+)\\.\\d+\\:(\\S*)");
    private EnsureEnum ensureEnum;

    protected DBMappedEnumCheck(Executor executor, PreferenceContext preferences, EnsureEnum ensureEnum) {
        super(executor, preferences);
        this.ensureEnum = ensureEnum;
    }

    @Override
    protected void doCheck() {
        SetMultimap<String, String> enums = this.getEnums();
        if (enums != null) {
            this.ensureEnums(enums);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SetMultimap<String, String> getEnums() {
        ZipFile jarFile = null;
        InputStream enums = null;
        LinkedHashMultimap<String, String> enumValues = LinkedHashMultimap.create();
        try {
            try {
                URL file2 = ResourceUtils.getURL("classpath:enums.properties");
                jarFile = new JarFile(ResourceUtils.extractJarFileURL(file2).getPath());
                enums = ((JarFile)jarFile).getInputStream(((JarFile)jarFile).getJarEntry("enums.properties"));
            }
            catch (IOException ioe) {
                LOGGER.warn("could not locate mapped enumerations", ioe);
                SetMultimap<String, String> setMultimap = null;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    if (enums != null) {
                        enums.close();
                    }
                }
                catch (IOException ioe2) {
                    LOGGER.warn("failed to close input handle", ioe2);
                }
                return setMultimap;
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(enums));){
                String line;
                while ((line = in.readLine()) != null) {
                    Matcher matcher = ENUMERATION_PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    enumValues.put(matcher.group(1), matcher.group(2));
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("could not read mapped enumerations", ioe);
                SetMultimap<String, String> setMultimap = null;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    if (enums != null) {
                        enums.close();
                    }
                }
                catch (IOException ioe3) {
                    LOGGER.warn("failed to close input handle", ioe3);
                }
                return setMultimap;
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
                if (enums != null) {
                    enums.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("failed to close input handle", ioe);
            }
        }
        return enumValues;
    }

    private static <C extends IEnum & IGlobal> Class<C> getEnumClassForName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private void ensureEnums(SetMultimap<String, String> enumValues) {
        for (Map.Entry<String, Collection<String>> valuesForClass : enumValues.asMap().entrySet()) {
            try {
                this.ensureEnum.ensure(DBMappedEnumCheck.getEnumClassForName(valuesForClass.getKey()), valuesForClass.getValue());
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("cannot find class", cnfe);
            }
        }
    }

    @Override
    protected String getCheckDone() {
        return "done for OMERO version " + this.getOmeroVersion();
    }
}

