/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.util.ArrayList;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import ome.model.enums.Format;
import ome.services.util.BaseDBCheck;
import ome.services.util.EnsureEnum;
import ome.services.util.Executor;
import ome.system.PreferenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEnumCheck
extends BaseDBCheck {
    public static final Logger log = LoggerFactory.getLogger(DBEnumCheck.class);
    private final EnsureEnum ensureEnum;

    public DBEnumCheck(Executor executor, PreferenceContext preferences, EnsureEnum ensureEnum) {
        super(executor, preferences);
        this.ensureEnum = ensureEnum;
    }

    @Override
    protected void doCheck() {
        ArrayList<String> formatNames = new ArrayList<String>();
        for (IFormatReader formatReader : new ImageReader().getReaders()) {
            String name = formatReader.getClass().getSimpleName();
            if (!name.endsWith("Reader") || "Fake".equals(name = name.substring(0, name.length() - 6))) continue;
            formatNames.add(name);
            if (!formatReader.hasCompanionFiles()) continue;
            formatNames.add("Companion/" + name);
        }
        this.ensureEnum.ensure(Format.class, formatNames);
    }

    @Override
    protected String getCheckDone() {
        return "done for Bio-Formats revision " + FormatTools.VCS_REVISION;
    }
}

