/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sharing;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import ome.annotations.NotNull;
import ome.annotations.RolesAllowed;
import ome.api.IShare;
import ome.api.ServiceInterface;
import ome.api.local.LocalAdmin;
import ome.api.local.LocalShare;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel2Service;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.CommentAnnotation;
import ome.model.annotations.SessionAnnotationLink;
import ome.model.internal.Details;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.Session;
import ome.model.meta.Share;
import ome.parameters.Parameters;
import ome.security.AdminAction;
import ome.security.SecureAction;
import ome.security.basic.BasicSecuritySystem;
import ome.services.mail.MailUtil;
import ome.services.sessions.SessionContext;
import ome.services.sessions.SessionManager;
import ome.services.sharing.ShareStore;
import ome.services.sharing.data.Obj;
import ome.services.sharing.data.ShareData;
import ome.services.util.Executor;
import ome.services.util.ServiceHandler;
import ome.system.EventContext;
import ome.system.Principal;
import ome.tools.hibernate.QueryBuilder;
import ome.util.ContextFilter;
import ome.util.Filterable;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ShareBean
extends AbstractLevel2Service
implements LocalShare {
    public static final Logger log = LoggerFactory.getLogger(ShareBean.class);
    public static final String NS_ENABLED = "ome.share.enabled";
    public static final String NS_COMMENT = "ome.share.comment/";
    protected final LocalAdmin admin;
    protected final SessionManager sessionManager;
    protected final ShareStore store;
    protected final Executor executor;
    protected final MailUtil mailUtil;

    @Override
    public final Class<? extends ServiceInterface> getServiceInterface() {
        return IShare.class;
    }

    public ShareBean(LocalAdmin admin, SessionManager mgr, ShareStore store, Executor executor, MailUtil mailUtil) {
        this.admin = admin;
        this.sessionManager = mgr;
        this.store = store;
        this.executor = executor;
        this.mailUtil = mailUtil;
    }

    @Override
    @RolesAllowed(value={"user"})
    public void activate(long shareId) {
        ShareData data = this.getShareIfAccessible(shareId);
        if (data == null) {
            throw new ValidationException("No accessible share:" + shareId);
        }
        if (!data.enabled) {
            throw new ValidationException("Share disabled.");
        }
        this.setShareId(shareId);
    }

    @Override
    @RolesAllowed(value={"user"})
    public void deactivate() {
        this.setShareId(null);
    }

    private Long setShareId(Long shareId) {
        String sessId = this.getSecuritySystem().getEventContext().getCurrentSessionUuid();
        SessionContext sc = (SessionContext)this.sessionManager.getEventContext(new Principal(sessId));
        Long old = sc.getCurrentShareId();
        sc.setShareId(shareId);
        return old;
    }

    @Override
    public void resetReadFilter(org.hibernate.Session s) {
        BasicSecuritySystem bss = (BasicSecuritySystem)this.sec;
        bss.loadEventContext(true);
        bss.updateReadFilter(s);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Map<Long, Long> getMemberCount(final Set<Long> shareIds) {
        if (shareIds == null || shareIds.size() == 0) {
            throw new ApiUsageException("Nothing to do");
        }
        final QueryBuilder qb = new QueryBuilder();
        qb.select("share2.id", "count(distinct links2.id)");
        qb.from("ShareMember", "links2");
        qb.join("links2.parent", "share2", false, false);
        qb.where();
        qb.paramList("ids", shareIds);
        qb.and("share2.id in (:ids) and share2.id in ");
        QueryBuilder sub = new QueryBuilder();
        sub.select("share");
        sub.from("ShareMember", "memberLinks");
        sub.join("memberLinks.parent", "share", false, false);
        sub.join("memberLinks.child", "user", false, false);
        sub.where();
        sub.and("1=1");
        this.applyIfShareAccessible(sub);
        qb.subselect(sub);
        qb.append("group by share2.id");
        final HashMap<Long, Long> rv = new HashMap<Long, Long>(shareIds.size());
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                ShareBean.this.iQuery.execute((HibernateCallback)new HibernateCallback<Object>(){

                    public Object doInHibernate(org.hibernate.Session s) throws HibernateException, SQLException {
                        Query q = qb.query(s);
                        List results = q.list();
                        if (results.size() != shareIds.size()) {
                            throw new ValidationException("Missing or protected shares specified");
                        }
                        for (Object[] values : results) {
                            Long shareId = (Long)values[0];
                            Long count = (Long)values[1];
                            rv.put(shareId, count);
                        }
                        return null;
                    }
                });
            }
        });
        return rv;
    }

    long getCurrentUserId() {
        return this.getSecuritySystem().getEventContext().getCurrentUserId();
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Session> getOwnShares(boolean active) {
        long id = this.getCurrentUserId();
        List<ShareData> shares = this.store.getShares(id, true, active);
        return this.sharesToSessions(shares);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Session> getMemberShares(boolean active) {
        long id = this.getCurrentUserId();
        List<ShareData> shares = this.store.getShares(id, false, active);
        return this.sharesToSessions(shares);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Session> getSharesOwnedBy(@NotNull Experimenter user, boolean active) {
        List<ShareData> shares = this.store.getShares(user.getId(), true, active);
        return this.sharesToSessions(shares);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Session> getMemberSharesFor(@NotNull Experimenter user, boolean active) {
        List<ShareData> shares = this.store.getShares(user.getId(), false, active);
        return this.sharesToSessions(shares);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Share getShare(long sessionId) {
        Share session = null;
        ShareData data = this.getShareIfAccessible(sessionId);
        if (data != null) {
            session = this.shareToSession(data);
        }
        return session;
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> getContents(long shareId) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        return this.list(data.objectList);
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> getContentSubList(long shareId, int start, int finish) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        try {
            return this.list(data.objectList.subList(start, finish));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new ApiUsageException("Invalid range: " + start + " to " + finish);
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> Map<Class<T>, List<Long>> getContentMap(long shareId) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        return this.map(data.objectMap);
    }

    @Override
    @RolesAllowed(value={"user"})
    public int getContentSize(long shareId) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        return data.objectList.size();
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public <T extends IObject> long createShare(final @NotNull String description, Timestamp expiration, List<T> items, List<Experimenter> exps, List<String> guests, final boolean enabled) {
        final long time = ShareBean.expirationAsLong(System.currentTimeMillis(), expiration);
        if (exps == null) {
            exps = Collections.emptyList();
        }
        if (guests == null) {
            guests = Collections.emptyList();
        }
        if (items == null) {
            items = Collections.emptyList();
        }
        EventContext ec = this.getSecuritySystem().getEventContext();
        final String omename = ec.getCurrentUserName();
        final Long user = ec.getCurrentUserId();
        final Long group = ec.getCurrentGroupId();
        Future<Share> future = this.executor.submit(new Callable<Share>(){

            @Override
            public Share call() throws Exception {
                return ShareBean.this.sessionManager.createShare(new Principal(omename), enabled, time, "SHARE", description, group);
            }
        });
        final List<T> _items = items;
        final List<String> _guests = guests;
        final ArrayList<Long> _users = new ArrayList<Long>(exps.size());
        for (Experimenter e : exps) {
            _users.add(e.getId());
        }
        long shareId = this.executor.get(future).getId();
        Share share = this.iQuery.find(Share.class, shareId);
        this.sec.doAction(new SecureShare(){

            @Override
            void doUpdate(Share share) {
                ShareBean.this.store.set(share, user, _items, _users, _guests, enabled);
            }
        }, new Share[]{share});
        this.adminFlush();
        return share.getId();
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setDescription(long shareId, String description) {
        Share share = this.iQuery.find(Share.class, shareId);
        ShareData data = this.store.get(shareId);
        share.setMessage(description);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setExpiration(long shareId, Timestamp expiration) {
        Share share = this.iQuery.find(Share.class, shareId);
        ShareData data = this.store.get(shareId);
        share.setTimeToLive(ShareBean.expirationAsLong(share.getStarted().getTime(), expiration));
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setActive(long shareId, boolean active) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        data.enabled = active;
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void closeShare(long shareId) {
        final String uuid = this.idToUuid(shareId);
        Future<Object> future = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ShareBean.this.sessionManager.close(uuid);
                return null;
            }
        });
        this.executor.get(future);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public <T extends IObject> void addObjects(long shareId, T ... objects) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        Graph graph = new Graph();
        for (T object : objects) {
            graph.filter("top", (Filterable)object);
        }
        this._addGraph(data, graph);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public <T extends IObject> void addObject(long shareId, @NotNull T object) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        Graph graph = new Graph();
        graph.filter("top", object);
        this._addGraph(data, graph);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public <T extends IObject> void removeObjects(long shareId, T ... objects) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        for (T object : objects) {
            List ids = (List)data.objectMap.get(object.getClass().getName());
            if (ids == null) continue;
            ids.remove(object.getId());
        }
        ArrayList<Obj> toRemove = new ArrayList<Obj>();
        for (T object : objects) {
            for (Obj obj : data.objectList) {
                if (!obj.type.equals(object.getClass().getName()) || obj.id != object.getId()) continue;
                toRemove.add(obj);
            }
        }
        data.objectList.removeAll(toRemove);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public <T extends IObject> void removeObject(long shareId, @NotNull T object) {
        ShareData data = this.getShareIfAccessible(shareId);
        List ids = (List)data.objectMap.get(object.getClass().getName());
        if (ids != null) {
            ids.remove(object.getId());
        }
        ArrayList<Obj> toRemove = new ArrayList<Obj>();
        for (Obj obj : data.objectList) {
            if (!obj.type.equals(object.getClass().getName()) || obj.id != object.getId()) continue;
            toRemove.add(obj);
        }
        data.objectList.removeAll(toRemove);
        this.storeShareData(shareId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"user"})
    public Map<Long, Long> getCommentCount(Set<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw new ApiUsageException("Nothing to do");
        }
        final QueryBuilder qb = new QueryBuilder();
        qb.select("share.id", "count(distinct sal)");
        qb.from("ShareMember", "sm");
        qb.join("sm.parent", "share", false, false);
        qb.join("share.annotationLinks", "sal", false, false);
        qb.join("sal.child", "comment", false, false);
        qb.join("sm.child", "user", false, false);
        qb.where();
        qb.and("share.id in (:ids)");
        qb.paramList("ids", ids);
        qb.and("comment.ns like :ns");
        qb.param("ns", (Object)"ome.share.comment/%");
        this.applyIfShareAccessible(qb);
        qb.append("group by share.id");
        final HashMap<Long, Long> rv = new HashMap<Long, Long>(ids.size());
        Long old = this.setShareId(-1L);
        try {
            this.iQuery.execute((HibernateCallback)new HibernateCallback<Object>(){

                public Object doInHibernate(org.hibernate.Session s) throws HibernateException, SQLException {
                    ShareBean.this.resetReadFilter(s);
                    Query q = qb.query(s);
                    List counts = q.list();
                    for (Object[] values : counts) {
                        Long shareId = (Long)values[0];
                        Long count = (Long)values[1];
                        rv.put(shareId, count);
                    }
                    return null;
                }
            });
        }
        finally {
            this.setShareId(old);
        }
        for (Long id : ids) {
            Long value = (Long)rv.get(id);
            if (value != null) continue;
            rv.put(id, 0L);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"user"})
    public List<Annotation> getComments(final long shareId) {
        ArrayList<Annotation> rv = new ArrayList<Annotation>();
        if (this.getShareIfAccessible(shareId) == null) {
            return rv;
        }
        Long oldShareId = this.setShareId(-1L);
        try {
            List links = (List)this.iQuery.execute((HibernateCallback)new HibernateCallback<Object>(){

                public Object doInHibernate(org.hibernate.Session arg0) throws HibernateException, SQLException {
                    ShareBean.this.resetReadFilter(arg0);
                    return arg0.createQuery("select l from SessionAnnotationLink l join fetch l.details.owner join fetch l.parent as share join fetch l.child as comment join fetch comment.details.updateEvent where share.id = :id and comment.ns like :ns ").setParameter("ns", (Object)"ome.share.comment/%").setParameter("id", (Object)shareId).list();
                }
            });
            for (SessionAnnotationLink link : links) {
                rv.add(link.child());
            }
        }
        finally {
            this.setShareId(oldShareId);
        }
        return rv;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public CommentAnnotation addComment(final long shareId, final @NotNull String commentText) {
        this.getShareIfAccessible(shareId);
        ExperimenterGroup group = this.iQuery.get(Share.class, shareId).getGroup();
        final CommentAnnotation[] rv = new CommentAnnotation[1];
        this.sec.runAsAdmin(group, new AdminAction(){

            @Override
            public void runAsAdmin() {
                Share share = ShareBean.this.iQuery.get(Share.class, shareId);
                CommentAnnotation comment = new CommentAnnotation();
                comment.setTextValue(commentText);
                comment.setNs(ShareBean.NS_COMMENT);
                share.linkAnnotation(comment);
                ShareBean.this.iUpdate.flush();
                rv[0] = ShareBean.this.iQuery.get(CommentAnnotation.class, comment.getId());
            }
        });
        return rv[0];
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public CommentAnnotation addReply(long shareId, @NotNull String comment, @NotNull CommentAnnotation replyTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void deleteComment(@NotNull Annotation comment) {
        List links = this.iQuery.findAllByQuery("select l from SessionAnnotationLink l where l.child.id = :id", new Parameters().addId(comment.getId()));
        for (SessionAnnotationLink sessionAnnotationLink : links) {
            this.iUpdate.deleteObject(sessionAnnotationLink);
        }
        this.iUpdate.deleteObject(comment);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Experimenter> getAllMembers(long shareId) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        List<Experimenter> e = this.loadMembers(data);
        return new HashSet<Experimenter>(e);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<String> getAllGuests(long shareId) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        return new HashSet<String>(data.guests);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<String> getAllUsers(long shareId) throws ValidationException {
        ShareData data = this.getShareIfAccessible(shareId);
        List<Experimenter> members = this.loadMembers(data);
        HashSet<String> names = new HashSet<String>();
        for (Experimenter e : members) {
            names.add(e.getOmeName());
        }
        for (String string : data.guests) {
            if (names.contains(string)) {
                throw new ValidationException(string + " is both a guest name and a member name");
            }
            names.add(string);
        }
        return names;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addUsers(long shareId, Experimenter ... exps) {
        List<Experimenter> es = Arrays.asList(exps);
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        for (Experimenter experimenter : es) {
            data.members.add(experimenter.getId());
        }
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addGuests(long shareId, String ... emailAddresses) {
        List<String> addresses = Arrays.asList(emailAddresses);
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        data.guests.addAll(addresses);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeUsers(long shareId, List<Experimenter> exps) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        for (Experimenter experimenter : exps) {
            data.members.remove(experimenter.getId());
        }
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeGuests(long shareId, String ... emailAddresses) {
        List<String> addresses = Arrays.asList(emailAddresses);
        ShareData data = this.getShareIfAccessible(shareId);
        data.guests.removeAll(addresses);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addUser(long shareId, Experimenter exp) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        data.members.add(exp.getId());
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addGuest(long shareId, String emailAddress) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        data.guests.add(emailAddress);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeUser(long shareId, Experimenter exp) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        data.members.remove(exp.getId());
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeGuest(long shareId, String emailAddress) {
        ShareData data = this.getShareIfAccessible(shareId);
        this.throwOnNullData(shareId, data);
        data.guests.remove(emailAddress);
        this.storeShareData(shareId, data);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Map<String, Experimenter> getActiveConnections(long shareId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Event> getEvents(long shareId, Experimenter experimenter, Timestamp from, Timestamp to) {
        throw new UnsupportedOperationException();
    }

    @Override
    @RolesAllowed(value={"user"})
    public Map<String, Experimenter> getPastConnections(long shareId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @RolesAllowed(value={"user"})
    public void invalidateConnection(long shareId, Experimenter exp) {
        throw new UnsupportedOperationException();
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void notifyMembersOfShare(long shareId, String subject, String message, boolean html) {
        EventContext ec = this.getSecuritySystem().getEventContext();
        Set<Experimenter> exps = this.getAllMembers(shareId);
        exps.add(this.getShare(shareId).getOwner());
        HashMap<Experimenter, String> errors = new HashMap<Experimenter, String>();
        for (Experimenter e : exps) {
            if (e.getId() == ec.getCurrentUserId() || e.getEmail() == null || !this.mailUtil.validateEmail(e.getEmail())) continue;
            try {
                this.mailUtil.sendEmail(e.getEmail(), subject, message, html, null, null);
            }
            catch (MailException me) {
                errors.put(e, me.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            log.error(ServiceHandler.getResultsString(errors, null));
        }
    }

    protected String idToUuid(long shareId) {
        Session s = this.iQuery.get(Session.class, shareId);
        return s.getUuid();
    }

    protected List<Experimenter> loadMembers(ShareData data) {
        List<Experimenter> members = new ArrayList<Experimenter>();
        if (data.members.size() > 0) {
            members = this.iQuery.findAllByQuery("select e from Experimenter e where e.id in (:ids)", new Parameters().addIds(data.members));
        }
        return members;
    }

    public static long expirationAsLong(long started, Timestamp expiration) {
        long time;
        if (expiration != null) {
            time = expiration.getTime();
            if (time < System.currentTimeMillis()) {
                throw new ApiUsageException("Expiration time must be in the future.");
            }
        } else {
            time = Long.MAX_VALUE;
        }
        return time - started;
    }

    protected Set<Session> sharesToSessions(List<ShareData> datas) {
        final HashSet<Long> ids = new HashSet<Long>();
        for (ShareData data : datas) {
            ids.add(data.id);
        }
        if (ids.size() == 0) {
            return Collections.emptySet();
        }
        List list = (List)this.iQuery.execute((HibernateCallback)new HibernateCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(org.hibernate.Session arg0) throws HibernateException, SQLException {
                BasicSecuritySystem bss = (BasicSecuritySystem)ShareBean.this.sec;
                try {
                    bss.disableReadFilter(arg0);
                    List list = arg0.createQuery("select sh from Session sh join fetch sh.owner where sh.id in (:ids) ").setParameterList("ids", (Collection)ids).list();
                    return list;
                }
                finally {
                    bss.enableReadFilter(arg0);
                }
            }
        });
        for (Session session : list) {
            if (session == null) continue;
            session.putAt("#2733", "ALLOW");
        }
        return new HashSet<Session>(list);
    }

    protected Share shareToSession(final ShareData data) {
        Share share = (Share)this.iQuery.execute((HibernateCallback)new HibernateCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(org.hibernate.Session arg0) throws HibernateException, SQLException {
                BasicSecuritySystem bss = (BasicSecuritySystem)ShareBean.this.sec;
                try {
                    bss.disableReadFilter(arg0);
                    Object object = arg0.createQuery("select sh from Share sh join fetch sh.owner where sh.id = :id").setParameter("id", (Object)data.id).uniqueResult();
                    return object;
                }
                finally {
                    bss.enableReadFilter(arg0);
                }
            }
        });
        if (share != null) {
            share.putAt("#2733", "ALLOW");
        }
        return share;
    }

    protected <T extends IObject> Map<Class<T>, List<Long>> map(Map<String, List<Long>> map) {
        HashMap<Class<T>, List<Long>> rv = new HashMap<Class<T>, List<Long>>();
        for (String key : map.keySet()) {
            try {
                Class<?> kls = Class.forName(key);
                rv.put(kls, map.get(key));
            }
            catch (Exception e) {
                throw new ValidationException("Share contains invalid type: " + key);
            }
        }
        return rv;
    }

    protected <T extends IObject> List<T> list(List<Obj> objectList) {
        ArrayList<IObject> rv = new ArrayList<IObject>();
        for (Obj o : objectList) {
            IObject t;
            try {
                t = (IObject)Class.forName(o.type).newInstance();
            }
            catch (Exception e) {
                throw new ValidationException("Share contains invalid type: " + o.type);
            }
            t.setId(o.id);
            t.unload();
            rv.add(t);
        }
        return rv;
    }

    protected void adminFlush() {
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                ShareBean.this.iUpdate.flush();
            }
        });
    }

    protected void throwOnNullData(long shareId, ShareData data) {
        if (data == null) {
            throw new ValidationException("Share not found: " + shareId);
        }
    }

    protected void applyIfShareAccessible(QueryBuilder qb) {
        EventContext ec = this.getSecuritySystem().getEventContext();
        if (!ec.isCurrentUserAdmin()) {
            qb.param("userId", (Object)ec.getCurrentUserId());
            qb.and("(");
            qb.append("share.owner.id = :userId");
            qb.append(" OR ");
            qb.append("user.id = :userId");
            qb.append(" ) ");
        }
    }

    protected ShareData getShareIfAccessible(long shareId) {
        EventContext ec = this.getSecuritySystem().getEventContext();
        boolean isAdmin = ec.isCurrentUserAdmin();
        long userId = ec.getCurrentUserId();
        return this.store.getShareIfAccessible(shareId, isAdmin, userId);
    }

    protected void _addGraph(ShareData data, Graph g) {
        for (IObject object : g.objects()) {
            ArrayList<Long> ids = (ArrayList<Long>)data.objectMap.get(object.getClass().getName());
            if (ids == null) {
                ids = new ArrayList<Long>();
                data.objectMap.put(object.getClass().getName(), ids);
            }
            if (ids.contains(object.getId())) continue;
            ids.add(object.getId());
            Obj obj = new Obj();
            obj.type = object.getClass().getName();
            obj.id = object.getId();
            data.objectList.add(obj);
        }
    }

    protected void storeShareData(long shareId, ShareData data) {
        Share share = this.iQuery.get(Share.class, shareId);
        this.sec.doAction(new SecureStore(data), new Share[]{share});
        this.adminFlush();
    }

    class SecureStore
    extends SecureShare {
        ShareData data;

        SecureStore(ShareData data) {
            this.data = data;
        }

        @Override
        void doUpdate(Share share) {
            ShareBean.this.store.update(share, this.data);
        }
    }

    abstract class SecureShare
    implements SecureAction {
        SecureShare() {
        }

        @Override
        public final <T extends IObject> T updateObject(T ... objs) {
            this.doUpdate((Share)objs[0]);
            return null;
        }

        abstract void doUpdate(Share var1);
    }

    private static class Graph
    extends ContextFilter {
        private Graph() {
        }

        public List<IObject> objects() {
            ArrayList<IObject> rv = new ArrayList<IObject>();
            for (Object o : this._cache.keySet()) {
                if (!(o instanceof IObject)) continue;
                IObject obj = (IObject)o;
                rv.add(obj);
            }
            return rv;
        }

        @Override
        protected void doFilter(String fieldId, Filterable f) {
            if (!(f instanceof Details)) {
                super.doFilter(fieldId, f);
            }
        }
    }
}

